/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.viewers.ui.content;

public enum VisibleResultPortType {
    INPUT(1),
    OUTPUT(2),
    INPUT_CONTROL(3),
    OUTPUT_CONTROL(4);

    private int id;

    private VisibleResultPortType(int id) {
        this.id = id;
    }

    public String toString() {
        return String.valueOf(this.id);
    }

    public static VisibleResultPortType of(int portType) {
        switch (portType) {
            case 1: {
                return INPUT;
            }
            case 2: {
                return OUTPUT;
            }
            case 3: {
                return INPUT_CONTROL;
            }
            case 4: {
                return OUTPUT_CONTROL;
            }
        }
        throw new IllegalArgumentException("Unsupported portType");
    }

    public static VisibleResultPortType of(String type) {
        if (type.equalsIgnoreCase("input")) {
            return INPUT;
        }
        if (type.equalsIgnoreCase("input_control")) {
            return INPUT_CONTROL;
        }
        if (type.equalsIgnoreCase("output")) {
            return OUTPUT;
        }
        if (type.equalsIgnoreCase("output_control")) {
            return OUTPUT_CONTROL;
        }
        throw new IllegalArgumentException(String.format("Port type name not found: %s", type));
    }

    public boolean isInput() {
        return this == INPUT || this == INPUT_CONTROL;
    }

    public boolean isOutput() {
        return this == OUTPUT || this == OUTPUT_CONTROL;
    }
}

