/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.viewers.ui.content.sph;

import com.siams.cv.monitor.model.viewer.SphViewerModel;
import com.siams.cv.monitor.viewers.ui.content.sph.SphViewer;
import com.siams.fxml.loader.CustomFXMLLoader;
import com.siams.preferences.UIPreference;
import java.io.IOException;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Group;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.MenuButton;
import javafx.scene.control.Slider;
import javafx.scene.control.Spinner;
import javafx.scene.control.SplitPane;
import javafx.scene.image.ImageView;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.VBox;
import javafx.scene.shape.Rectangle;

class SphViewerContent
extends VBox
implements Initializable,
UIPreference {
    private static final Logger logger = Logger.getLogger(SphViewerContent.class.getCanonicalName());
    private final SphViewer sphViewer;
    @FXML
    Button btnResetZoom;
    @FXML
    VBox vBoxZoomControls;
    @FXML
    ImageView imageView;
    @FXML
    Rectangle highlighter;
    @FXML
    Group groupDisplayable;
    @FXML
    Button btnZoomOut;
    @FXML
    Button btnZoomIn;
    @FXML
    VBox viewerRoot;
    @FXML
    AnchorPane rasterContainer;
    @FXML
    AnchorPane apStatusBarHolder;
    @FXML
    CheckBox cbCuttingZPlane;
    @FXML
    Slider sliderCuttingZPlane;
    @FXML
    Spinner<Double> spinnerCuttingZPane;
    @FXML
    SplitPane splitPaneControls;
    @FXML
    VBox vbSphKinds;
    @FXML
    CheckBox cbUpwardAxisY;
    @FXML
    Spinner<Integer> spinnerXRotation;
    @FXML
    Spinner<Integer> spinnerYRotation;
    @FXML
    Spinner<Integer> spinnerZRotation;
    MenuButton mbView;
    CheckMenuItem cmiZoomControls;

    SphViewerContent(SphViewer sphViewer) {
        this.sphViewer = sphViewer;
        try {
            CustomFXMLLoader.loadElement((Object)((Object)this));
            this.initializeMenuView();
        }
        catch (IOException e) {
            logger.severe(e.getMessage());
        }
    }

    private void initializeMenuView() {
        this.cmiZoomControls = new CheckMenuItem("Zoom controls");
        this.cmiZoomControls.selectedProperty().addListener((ob, o, selected) -> {
            this.vBoxZoomControls.setVisible(selected.booleanValue());
            this.vBoxZoomControls.setManaged(selected.booleanValue());
        });
        this.mbView = new MenuButton("View");
        this.mbView.getItems().add((Object)this.cmiZoomControls);
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.restorePreference();
    }

    public void restorePreference() {
        Platform.runLater(() -> {
            SphViewerModel model = (SphViewerModel)this.sphViewer.getViewerModel();
            this.spinnerCuttingZPane.getEditor().setText(String.valueOf(model.getZSection().intValue()));
            this.sliderCuttingZPlane.setValue(model.getZSection().doubleValue());
            this.cbCuttingZPlane.setSelected(model.getZSectionEnabled().booleanValue());
            this.cbUpwardAxisY.setSelected(model.getUpwardAxisY().booleanValue());
            this.splitPaneControls.setDividerPositions(new double[]{model.getSplitterPosition()});
            this.vBoxZoomControls.setVisible(model.getDisplayZoomControls().booleanValue());
            this.vBoxZoomControls.setManaged(model.getDisplayZoomControls().booleanValue());
            this.cmiZoomControls.setSelected(model.getDisplayZoomControls().booleanValue());
            this.spinnerXRotation.getEditor().setText(String.valueOf(model.getXRotateDegree()));
            this.spinnerYRotation.getEditor().setText(String.valueOf(model.getYRotateDegree()));
            this.spinnerZRotation.getEditor().setText(String.valueOf(model.getZRotateDegree()));
        });
    }
}

