/*
 * Decompiled with CFR 0.152.
 */
package com.siams.stare.api.client;

import com.siams.stare.api.Any;
import com.siams.stare.api.StareApi;
import com.siams.stare.api.client.StareClient;
import com.siams.stare.api.url.UrlBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.logging.Logger;

public class StareSubchainClient
extends StareClient {
    private static final Logger logger = Logger.getLogger(StareSubchainClient.class.getCanonicalName());
    private String subchainBlockName = null;
    private String subchainBlockUrl = null;

    public StareSubchainClient(StareApi rpc) {
        super(rpc);
    }

    public StareSubchainClient setSubchainBlockName(String subchainBlockName) {
        this.subchainBlockName = subchainBlockName;
        return this;
    }

    private String getSubchainBlockName() {
        return this.subchainBlockName == null ? "null" : this.subchainBlockName;
    }

    private String getSubchainBlockUrl() {
        return this.subchainBlockUrl == null ? "null" : this.subchainBlockUrl;
    }

    @Override
    public CompletableFuture<String> rqCreateProject() {
        return super.rqCreateProject().thenCompose(deferredProjectUrl -> this.fetchSubchainBlockUrl().thenApply(subchainBlockUrl -> {
            logger.info("subchainBlockUrl = " + subchainBlockUrl);
            this.subchainBlockUrl = subchainBlockUrl;
            return deferredProjectUrl;
        }));
    }

    @Override
    protected String getInputUrl(String inputName) {
        return UrlBuilder.sessionProjectWorkerInput(this.sessionId, this.projectId, this.subchainBlockName, inputName);
    }

    @Override
    protected String getSettingUrl(String settingName) {
        return UrlBuilder.sessionProjectWorkerProperty(this.sessionId, this.projectId, this.subchainBlockName, settingName);
    }

    @Override
    protected String getOutputUrl(String projectUrl, String outputName) {
        return String.format("%s/worker:%s/output:%s", this.getProjectUrl(), this.subchainBlockName, outputName);
    }

    private CompletableFuture<String> fetchSubchainBlockUrl() {
        logger.info(String.format("%s: fetchSubchainBlockUrl(), block system name = %s", this.getClass().getCanonicalName(), this.subchainBlockName));
        return this.rpc.getList(String.format("%s/worker", this.getProjectUrl())).thenCompose(workerUrls -> {
            HashMap urlToName = new HashMap(workerUrls.size());
            return CompletableFuture.allOf((CompletableFuture[])workerUrls.stream().map(workerUrl -> {
                CompletableFuture<Any> name = this.rpc.getData(String.format("%s/system:name", workerUrl));
                urlToName.put(workerUrl, name);
                return name;
            }).toArray(CompletableFuture[]::new)).thenApply(v -> {
                String subchainBlockUrl = "";
                for (Map.Entry entry : urlToName.entrySet()) {
                    Optional<String> optName = ((Any)((CompletableFuture)entry.getValue()).join()).getData(String.class);
                    if (!optName.isPresent()) continue;
                    logger.info("Subchain block name found: " + String.valueOf(optName));
                    String systemName = optName.get();
                    if (!systemName.equals(this.getSubchainBlockName())) continue;
                    subchainBlockUrl = (String)entry.getKey();
                }
                if (subchainBlockUrl.isEmpty()) {
                    throw new CompletionException(new Throwable("Correct subchain block not found."));
                }
                return subchainBlockUrl;
            });
        });
    }
}

