/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.demo;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import net.algart.executors.api.ExecutionBlock;
import net.algart.executors.api.chains.Chain;
import net.algart.executors.api.chains.ChainSpecification;
import net.algart.executors.api.chains.core.ChainExecutor;
import net.algart.executors.api.chains.core.UseChain;
import net.algart.executors.api.data.SScalar;
import net.algart.executors.api.parameters.Parameters;
import net.algart.executors.api.system.CreateMode;
import net.algart.executors.api.system.ExecutorFactory;

public class CallSimpleChain {
    private static final boolean CUSTOMIZING_USE = true;
    boolean executeAll = false;
    double x;
    double y;
    Double a;
    Double b;

    private ChainExecutor createExecutor(Path chainPath) throws IOException {
        if (!this.executeAll) {
            return UseChain.newSharedExecutor((Path)chainPath);
        }
        ChainSpecification specification = ChainSpecification.read((Path)chainPath);
        UseChain use = UseChain.getSharedInstance().setOverrideBehaviour(true).setExecuteAll(true);
        return use.newExecutor(specification, CreateMode.REQUEST_ALL);
    }

    private void executeChainAsExecutor(Path chainPath) throws IOException {
        try (ChainExecutor executor = this.createExecutor(chainPath);){
            executor.putDoubleScalar("x", this.x);
            executor.putDoubleScalar("y", this.y);
            executor.setParameter("a", (Object)this.a);
            executor.setParameter("b", (Object)this.b);
            executor.execute();
            System.out.println("Executor finished: " + String.valueOf(executor));
        }
    }

    private void executeChainDirectly(Path chainPath) throws IOException {
        ChainSpecification chainSpecification = ChainSpecification.read((Path)chainPath);
        ExecutorFactory executorFactory = ExecutorFactory.newFactory((String)"MySession");
        try (Chain chain = Chain.of(null, (ExecutorFactory)executorFactory, (ChainSpecification)chainSpecification);){
            chain.setExecuteAll(this.executeAll);
            chain.reinitializeAll();
            chain.setParameters(new Parameters().set("a", (Object)this.a).set("b", (Object)this.b));
            HashMap<String, SScalar> inputs = new HashMap<String, SScalar>();
            inputs.put("x", SScalar.of((Object)this.x));
            inputs.put("y", SScalar.of((Object)this.y));
            chain.setInputData(inputs);
            chain.execute();
            System.out.println("Chain finished: " + String.valueOf(chain));
        }
    }

    public static void main(String[] args) throws IOException {
        CallSimpleChain demo = new CallSimpleChain();
        boolean lowLevel = false;
        int startArgIndex = 0;
        if (args.length > startArgIndex && args[startArgIndex].equalsIgnoreCase("-lowLevel")) {
            lowLevel = true;
            ++startArgIndex;
        }
        if (args.length > startArgIndex && args[startArgIndex].equalsIgnoreCase("-all")) {
            demo.executeAll = true;
            ++startArgIndex;
        }
        if (args.length < startArgIndex + 3) {
            System.out.printf("Usage: %s [-lowLevel] [-all] some_chain.chain%nsome_chain.chain should be a chain with settings, which process 2 scalars x and y and have 2 parameters named a and b. However, this is not necessary.%nNote: in the low-level mode, the chain must not use any chains, settings or other dynamic executors.", CallSimpleChain.class.getName());
            return;
        }
        demo.x = Double.parseDouble(args[startArgIndex + 1]);
        demo.y = Double.parseDouble(args[startArgIndex + 2]);
        demo.a = args.length > startArgIndex + 3 ? Double.valueOf(args[startArgIndex + 3]) : null;
        demo.b = args.length > startArgIndex + 4 ? Double.valueOf(args[startArgIndex + 4]) : null;
        Path chainPath = Paths.get(args[startArgIndex], new String[0]);
        ExecutionBlock.initializeExecutionSystem();
        if (lowLevel) {
            demo.executeChainDirectly(chainPath);
        } else {
            demo.executeChainAsExecutor(chainPath);
        }
    }
}

