/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.demo;

import jakarta.json.JsonObject;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.algart.executors.api.ExecutionBlock;
import net.algart.executors.api.demo.CallSimpleChainForImage;
import net.algart.executors.api.multichains.core.CombineMultiChainSettings;
import net.algart.executors.api.multichains.core.MultiChainExecutor;
import net.algart.executors.api.multichains.core.UseMultiChain;
import net.algart.executors.api.parameters.Parameters;
import net.algart.executors.api.settings.SettingsBuilder;
import net.algart.executors.api.system.ExecutorSpecification;
import net.algart.executors.api.system.ExecutorSpecificationFactory;
import net.algart.executors.api.system.SettingsTree;
import net.algart.json.Jsons;

public class CallSimpleMultiChain {
    private static void customizeViaParameters(MultiChainExecutor executor, String variant, String a, String b) {
        executor.selectChainVariant(variant);
        executor.setStringParameter("a", a);
        executor.setStringParameter("b", b);
    }

    private static void customizeViaBuilder(MultiChainExecutor executor, String variant, String a, String b) {
        SettingsBuilder settingsBuilder = executor.settingsBuilder();
        Parameters parameters = new Parameters().setString(executor.multiChain().selectedChainParameter(), variant).setString("a", a).setString("b", b).setString(variant, "{\"delta\": 0.003}");
        JsonObject settingsJson = settingsBuilder.build(parameters);
        System.out.printf("%nSettings JSON: %s%n%n", Jsons.toPrettyString((JsonObject)settingsJson));
        executor.putSettings(settingsJson);
    }

    private static void customizeViaCombiner(MultiChainExecutor executor, String variant, String a, String b) {
        CombineMultiChainSettings combiner = executor.newCombine();
        combiner.selectChainVariant(variant);
        combiner.setStringParameter("a", a);
        combiner.setStringParameter("b", b);
        combiner.putStringScalar(variant, "{\"delta\": 0.003}");
        String settings = combiner.combine();
        System.out.printf("%nCombined JSON: %s%n%n", settings);
        executor.putSettings(settings);
    }

    private static void customizeViaTree(MultiChainExecutor executor, String variant, String a, String b) {
        CombineMultiChainSettings combiner = executor.newCombine();
        SettingsTree tree = SettingsTree.of((ExecutorSpecificationFactory)executor.executorFactory(), (ExecutorSpecification)combiner.getSpecification());
        System.out.printf("%nTree of default JSON values: %s%n", tree.defaultSettingsJsonString());
        JsonObject settings = tree.settingsJson(path -> {
            if (path.lastName().equals("delta")) {
                return Jsons.doubleValue((double)0.003);
            }
            return switch (path.toString()) {
                case "/___selectedChainName" -> Jsons.stringValue((String)variant);
                case "/a" -> Jsons.stringValue((String)a);
                case "/b" -> Jsons.stringValue((String)b);
                default -> path.reqControl().getDefaultJsonValue();
            };
        });
        System.out.printf("%nCombined tree JSON: %s%n%n", Jsons.toPrettyString((JsonObject)settings));
        executor.putSettings(settings);
    }

    public static void main(String[] args) throws IOException {
        boolean builder = false;
        int startArgIndex = 0;
        boolean combine = false;
        boolean tree = false;
        if (args.length > startArgIndex && args[startArgIndex].equalsIgnoreCase("-builder")) {
            builder = true;
            ++startArgIndex;
        } else if (args.length > startArgIndex && args[startArgIndex].equalsIgnoreCase("-combine")) {
            combine = true;
            ++startArgIndex;
        } else if (args.length > startArgIndex && args[startArgIndex].equalsIgnoreCase("-tree")) {
            tree = true;
            ++startArgIndex;
        }
        if (args.length < startArgIndex + 4) {
            System.out.printf("Usage: %s [-builder|-combine|-tree] some_multi_chain.mchain x y chain_variant [a b]%nsome_multi_chain.mchain should be a multi-chain, which process 2 scalars x and y and have 2 parameters named a and b;%nit should calculate some formula like ax+by and return the result in the output.", CallSimpleMultiChain.class.getName());
            return;
        }
        Path multiChainPath = Paths.get(args[startArgIndex], new String[0]);
        String x = args[startArgIndex + 1];
        String y = args[startArgIndex + 2];
        String variant = args[startArgIndex + 3];
        String parameterA = args.length > startArgIndex + 4 ? args[startArgIndex + 4] : null;
        String parameterB = args.length > startArgIndex + 5 ? args[startArgIndex + 5] : null;
        ExecutionBlock.initializeExecutionSystem();
        System.out.printf("Loading %s...%n", multiChainPath.toAbsolutePath());
        try (MultiChainExecutor executor = UseMultiChain.newSharedExecutor((Path)multiChainPath);){
            CallSimpleChainForImage.printChainExecutors();
            CallSimpleChainForImage.printExecutorInterface((ExecutionBlock)executor);
            executor.putStringScalar("x", x);
            executor.putStringScalar("y", y);
            if (combine) {
                CallSimpleMultiChain.customizeViaCombiner(executor, variant, parameterA, parameterB);
            } else if (builder) {
                CallSimpleMultiChain.customizeViaBuilder(executor, variant, parameterA, parameterB);
            } else if (tree) {
                CallSimpleMultiChain.customizeViaTree(executor, variant, parameterA, parameterB);
            } else {
                CallSimpleMultiChain.customizeViaParameters(executor, variant, parameterA, parameterB);
            }
            executor.execute();
            System.out.printf("%s%nDone: result is %s%n", executor, executor.getData());
        }
    }
}

