/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.tests;

import jakarta.json.JsonObject;
import java.io.IOException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.algart.executors.api.ExecutionBlock;
import net.algart.executors.api.Executor;
import net.algart.executors.api.system.ExecutorSpecification;

public class ExecutorSpecificationTest {
    public static void main(String[] args) throws IOException, InterruptedException {
        if (args.length < 4) {
            System.out.printf("Usage: %s executor_specification.json result_1.json result_2.json result_3.json%n", ExecutorSpecification.class.getName());
            return;
        }
        Path specificationFile = Paths.get(args[0], new String[0]);
        Path resultFile1 = Paths.get(args[1], new String[0]);
        Path resultFile2 = Paths.get(args[2], new String[0]);
        Path resultFile3 = Paths.get(args[3], new String[0]);
        ExecutorSpecification specification = ExecutorSpecification.read((Path)specificationFile);
        specification.write(resultFile1, new OpenOption[0]);
        System.out.printf("Java configuration:%n", new Object[0]);
        System.out.println(specification.minimalSpecification());
        System.out.printf("%nFull specification:%n", new Object[0]);
        System.out.println(specification);
        System.out.printf("%nExecutor object:%n", new Object[0]);
        Thread.sleep(100L);
        try {
            ExecutionBlock executionBlock = ExecutionBlock.newExecutor(null, (ExecutorSpecification)specification);
            Thread.sleep(100L);
            System.out.println(executionBlock);
            if (executionBlock instanceof Executor) {
                specification.setTo((Executor)executionBlock);
                specification.write(resultFile2, new OpenOption[0]);
                System.out.printf("%nReloaded full specification:%n", new Object[0]);
                System.out.println(specification);
                specification = ExecutorSpecification.of((Executor)((Executor)executionBlock), (String)"12345678");
                specification.write(resultFile3, new OpenOption[0]);
                System.out.printf("%nSpecification, created from executor:%n", new Object[0]);
                System.out.println(specification);
                System.out.printf("%nExecutor specification:%n", new Object[0]);
                System.out.println(executionBlock.getSpecification());
            }
            ExecutionBlock block1 = null;
            ExecutionBlock block2 = null;
            for (int test = 1; test <= 16; ++test) {
                System.out.printf("Timing test %d...%n", test);
                int n = 1000;
                JsonObject json = null;
                String minimal = null;
                long t1 = System.nanoTime();
                for (int i = 0; i < 1000; ++i) {
                    json = specification.toJson();
                }
                long t2 = System.nanoTime();
                for (int i = 0; i < 1000; ++i) {
                    minimal = specification.minimalSpecification();
                }
                long t3 = System.nanoTime();
                for (int i = 0; i < 1000; ++i) {
                    block1 = ExecutionBlock.newExecutor(null, (ExecutorSpecification)specification);
                }
                long t4 = System.nanoTime();
                for (int i = 0; i < 1000; ++i) {
                    block2 = ExecutionBlock.newExecutor(null, (String)minimal);
                }
                long t5 = System.nanoTime();
                System.out.printf("ExecutorSpecification.toJson(): %.3f mcs%n", (double)(t2 - t1) * 0.001 / 1000.0);
                System.out.printf("ExecutorSpecification.minimalSpecification(): %.3f mcs%n", (double)(t3 - t2) * 0.001 / 1000.0);
                System.out.printf("Creating execution block from specification: %.3f mcs%n", (double)(t4 - t3) * 0.001 / 1000.0);
                System.out.printf("Creating execution block from minimal string:  %.3f mcs%n", (double)(t5 - t4) * 0.001 / 1000.0);
            }
            System.out.printf("Full execution block:%n%s%n%n", block1.getSpecification().jsonString());
            System.out.printf("Minimal execution block:%n%s%n%n", block2.getSpecification().jsonString());
        }
        catch (ClassNotFoundException e) {
            System.out.printf("Cannot load required class: %s%n", e);
        }
    }
}

