/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.tests;

import java.util.Map;
import net.algart.executors.api.parameters.NoValidParameterException;
import net.algart.executors.api.parameters.Parameters;

public class ParametersTest {
    private static void show(Parameters p, String name) {
        System.out.printf("%n%s: [%s] = \"%s\" (string) = %s (int) = %s (long) = %s (double) = %s (boolean) = %s (json) [type: %s]%n", name, p.get((Object)name), p.getString(name, null), p.getInteger(name, -1), p.getLong(name, -1L), p.getDouble(name, Double.NaN), p.getBoolean(name, false), p.getJsonValue(name), p.get((Object)name) == null ? "null" : p.get((Object)name).getClass().getName());
        try {
            if (!p.getString(name).equals(p.getString(name, null))) {
                throw new AssertionError();
            }
        }
        catch (NoValidParameterException e) {
            System.out.printf("%s cannot be read as String: %s%n", new Object[]{name, e});
        }
        try {
            if (p.getInteger(name) != p.getInteger(name, -1)) {
                throw new AssertionError();
            }
        }
        catch (NoValidParameterException e) {
            System.out.printf("%s cannot be read as integer: %s%n", new Object[]{name, e});
        }
        try {
            if (p.getLong(name) != p.getLong(name, -1L)) {
                throw new AssertionError();
            }
        }
        catch (NoValidParameterException e) {
            System.out.printf("%s cannot be read as long: %s%n", new Object[]{name, e});
        }
        try {
            if (p.getDouble(name) != p.getDouble(name, -1.0)) {
                throw new AssertionError();
            }
        }
        catch (NoValidParameterException e) {
            System.out.printf("%s cannot be read as double: %s%n", new Object[]{name, e});
        }
        try {
            if (p.getBoolean(name) != p.getBoolean(name, false)) {
                throw new AssertionError();
            }
        }
        catch (NoValidParameterException e) {
            System.out.printf("%s cannot be read as boolean: %s%n", new Object[]{name, e});
        }
    }

    public static void main(String[] args) {
        Parameters p = new Parameters();
        System.out.println("Testing normal setters:");
        p.setLong("a", 123L);
        p.setInteger("b", 124);
        p.setBoolean("c", true);
        p.setDouble("d", 125.0);
        p.setString("e", "eeee");
        System.out.println(p);
        for (String name : p.keySet()) {
            ParametersTest.show(p, name);
        }
        ParametersTest.show(p, "absent");
        Parameters other = new Parameters((Map)p);
        if (!other.equals((Object)p)) {
            throw new AssertionError();
        }
        System.out.println();
        System.out.println();
        System.out.println("Testing string-value setters:");
        p = new Parameters();
        p.setLong("a", "123.00");
        p.setInteger("b", "12422222");
        p.setBoolean("c", "True");
        p.setDouble("d", "125e10");
        p.setString("e", null);
        System.out.println(p);
        for (String name : p.keySet()) {
            ParametersTest.show(p, name);
        }
    }
}

