/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.tests;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Stream;
import net.algart.executors.api.multichains.MultiChainSpecification;

public class ReadWriteMultiChainTest {
    public static void main(String[] args) throws IOException {
        List<Path> files;
        boolean rewrite = false;
        int startArgIndex = 0;
        if (args.length > startArgIndex && args[startArgIndex].equals("-rewrite")) {
            rewrite = true;
            ++startArgIndex;
        }
        if (args.length < startArgIndex + 1) {
            System.out.printf("Usage: %s [-rewrite] multi_chain.mchain | folder_with_multi_chains%n", ReadWriteMultiChainTest.class.getName());
            return;
        }
        Path path = Paths.get(args[startArgIndex], new String[0]);
        if (Files.isDirectory(path, new LinkOption[0])) {
            try (Stream<Path> list = Files.list(path);){
                files = list.filter(MultiChainSpecification::isMultiChainSpecificationFile).toList();
            }
        } else {
            files = List.of(path);
        }
        for (Path file : files) {
            System.out.printf("Reading %s...%n", file);
            MultiChainSpecification specification = MultiChainSpecification.readIfValid((Path)file);
            if (specification == null) {
                System.out.printf("Skipping %s (not a multi-chain)...%n", file);
                continue;
            }
            if (rewrite) {
                System.out.printf("Writing %s...%n", file);
                specification.write(file, new OpenOption[0]);
            }
            if (files.size() != 1) continue;
            System.out.println("Specification:");
            System.out.println(specification);
            System.out.println();
            System.out.println("JSON:");
            System.out.println(specification.jsonString());
            System.out.println();
        }
    }
}

