/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.tests;

import jakarta.json.JsonException;
import jakarta.json.JsonObject;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.algart.executors.api.chains.ChainSpecification;
import net.algart.json.Jsons;

public class ReplaceChainsInFolder {
    boolean doChanges = false;
    int count = 0;

    private void replace(Path f) throws IOException {
        ChainSpecification specification;
        try {
            specification = ChainSpecification.readIfValid((Path)f);
        }
        catch (JsonException e) {
            System.err.println(e.getMessage());
            return;
        }
        if (specification == null) {
            System.out.printf("%s is not a chain%n", f);
            return;
        }
        String jsonString = specification.jsonString();
        ChainSpecification reverse = ChainSpecification.of((JsonObject)Jsons.toJson((String)jsonString));
        if (!reverse.jsonString().equals(jsonString)) {
            throw new AssertionError((Object)("Cannot reproduce JSON structure for " + String.valueOf(f)));
        }
        if (this.doChanges) {
            specification.rewriteChainSection(f, new OpenOption[0]);
            System.out.printf("%s successfully rewritten%n", f);
        }
        ++this.count;
    }

    private void replaceAll(Path folder) throws IOException {
        try (DirectoryStream<Path> files = Files.newDirectoryStream(folder);){
            for (Path file : files) {
                if (Files.isDirectory(file, new LinkOption[0])) {
                    this.replaceAll(file);
                    continue;
                }
                if (!ChainSpecification.isChainSpecificationFile((Path)file)) continue;
                this.replace(file);
            }
        }
    }

    public static void main(String[] args) throws IOException, InterruptedException {
        ReplaceChainsInFolder replacer = new ReplaceChainsInFolder();
        int startArgIndex = 0;
        if (args.length > startArgIndex && args[startArgIndex].equals("-f")) {
            replacer.doChanges = true;
            ++startArgIndex;
        }
        if (args.length < startArgIndex + 1) {
            System.out.printf("Usage: %s [-f] folder_with_chains%nWarning: with -f flag, this utility will replace all chains in this folder and its subfolders!", ReplaceChainsInFolder.class.getName());
            return;
        }
        Path folder = Paths.get(args[startArgIndex], new String[0]);
        replacer.replaceAll(folder);
    }
}

