/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.tests;

import java.nio.ByteBuffer;
import net.algart.executors.api.data.SMat;

public class SMatSpeed {
    private static void test() {
        int k;
        SMat mat = new SMat();
        mat.setAll(new long[]{10L, 10L}, SMat.Depth.S8, 1, ByteBuffer.allocate(100), false);
        System.out.printf("Testing %s...%n", mat);
        long t1 = System.nanoTime();
        long width = mat.getDimX();
        long height = mat.getDimY();
        long t2 = System.nanoTime();
        System.out.printf("getDimX-1: %d ns%n", t2 - t1);
        for (k = 0; k < 1000000; ++k) {
            mat.getDimX();
            mat.getDimY();
        }
        t1 = System.nanoTime();
        width = mat.getDimX();
        height = mat.getDimY();
        t2 = System.nanoTime();
        System.out.printf("getDimX-2: %d ns%n", t2 - t1);
        t1 = System.nanoTime();
        for (k = 0; k < 1000000; ++k) {
            width = mat.getDimX();
        }
        t2 = System.nanoTime();
        System.out.printf("getDimX-3 in loop: %.6f ns%n", (double)(t2 - t1) * 1.0E-6);
        t1 = System.nanoTime();
        width = mat.getDimX();
        height = mat.getDimY();
        t2 = System.nanoTime();
        System.out.printf("getDimX-4: %d ns%n", t2 - t1);
    }

    public static void main(String[] args) {
        for (int iteration = 0; iteration < 5; ++iteration) {
            System.out.printf("%nText %d:%n", iteration);
            SMatSpeed.test();
        }
    }
}

