/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.tests;

import jakarta.json.JsonObject;
import java.io.IOException;
import java.nio.file.Paths;
import net.algart.executors.api.parameters.Parameters;
import net.algart.executors.api.settings.SettingsBuilder;
import net.algart.executors.api.settings.SettingsSpecification;
import net.algart.executors.api.settings.core.CombineSettings;
import net.algart.executors.api.settings.core.UseSettings;
import net.algart.executors.api.system.ExecutorFactory;
import net.algart.json.Jsons;

public class SettingsTest {
    private static final SettingsSpecification SETTINGS_SPECIFICATION = SettingsSpecification.of((String)"{\n  \"app\": \"settings\",\n  \"name\": \"test\",\n  \"id\": \"TEST_1234\",\n  \"controls\": [\n    {\n      \"name\": \"a\",\n      \"value_type\": \"double\",\n      \"edition_type\": \"value\",\n      \"default\": 100\n    },\n    {\n      \"name\": \"b\",\n      \"value_type\": \"double\",\n      \"edition_type\": \"value\"\n    },\n    {\n      \"name\": \"path\",\n      \"value_type\": \"String\",\n      \"edition_type\": \"file\",\n      \"default\": \"./\"\n    },\n    {\n      \"name\": \"details\",\n      \"value_type\": \"settings\",\n      \"edition_type\": \"value\"\n    }\n  ]\n}\n");

    public static void main(String[] args) throws IOException {
        SettingsBuilder settingsBuilder = SettingsBuilder.of((SettingsSpecification)SETTINGS_SPECIFICATION);
        settingsBuilder.setAddSettingsClass(true);
        JsonObject jsonDefault = settingsBuilder.buildDefault();
        System.out.printf("Defaults:%n%s%n", Jsons.toPrettyString((JsonObject)jsonDefault));
        Parameters parameters = new Parameters().setString("a", "2.0").setDouble("b", 3.0).setString("details", "{\"delta\":0.001}").setString("path", "my_file.dat");
        JsonObject jsonParameters = settingsBuilder.build(parameters);
        System.out.printf("Parameters:%n%s%n", Jsons.toPrettyString((JsonObject)jsonParameters));
        System.setProperty("net.algart.executors.root", "build");
        ExecutorFactory factory = ExecutorFactory.newSharedFactory();
        try (CombineSettings executor = UseSettings.newSharedExecutor((ExecutorFactory)factory, (SettingsSpecification)SETTINGS_SPECIFICATION);){
            executor.setCurrentDirectory(Paths.get(".", new String[0]).toAbsolutePath());
            executor.setParameters(parameters);
            executor.putStringScalar("details", "{\"delta\":0.002}");
            String result = executor.combine();
            System.out.printf("%s%nResult of executor is%n%s%n", executor, result);
        }
    }
}

