/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.demo;

import java.util.Map;
import net.algart.executors.api.ExecutionBlock;
import net.algart.executors.api.parameters.Parameters;

public final class ExampleLowLevelParameters
extends ExecutionBlock {
    private static final System.Logger LOG = System.getLogger(ExampleLowLevelParameters.class.getName());

    private void checkParameter(StringBuilder sb, String name) {
        Parameters parameters = this.parameters();
        sb.append("    ").append("getString: ");
        try {
            String s = "\"" + parameters.getString(name) + "\"";
            sb.append(s);
        }
        catch (RuntimeException e) {
            sb.append(e);
        }
        sb.append("\n");
        sb.append("    ").append("getInteger: ");
        try {
            sb.append(parameters.getInteger(name));
        }
        catch (RuntimeException e) {
            sb.append(e);
        }
        sb.append("\n");
        sb.append("    ").append("getLong: ");
        try {
            sb.append(parameters.getLong(name));
        }
        catch (RuntimeException e) {
            sb.append(e);
        }
        sb.append("\n");
        sb.append("    ").append("getDouble: ");
        try {
            sb.append(parameters.getDouble(name));
        }
        catch (RuntimeException e) {
            sb.append(e);
        }
        sb.append("\n");
        sb.append("    ").append("getBoolean: ");
        try {
            sb.append(parameters.getBoolean(name));
        }
        catch (RuntimeException e) {
            sb.append(e);
        }
        sb.append("\n");
    }

    public void execute() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : this.parameters().entrySet()) {
            Object value = entry.getValue();
            sb.append((String)entry.getKey()).append("=").append(value);
            if (value != null) {
                sb.append(" - type ").append(value.getClass().getName());
            }
            sb.append("\n");
            this.checkParameter(sb, (String)entry.getKey());
        }
        this.getScalar().setTo(sb.toString());
    }

    public void onChangeParameter(String name) {
        Object value = this.parameters().get((Object)name);
        LOG.log(System.Logger.Level.INFO, "Setting parameter " + name + " to " + String.valueOf(value) + (String)(value == null ? "" : " - " + String.valueOf(value.getClass())));
    }
}

