/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.demo;

import java.util.AbstractList;
import java.util.List;
import net.algart.arrays.ByteArray;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.executors.api.Executor;
import net.algart.executors.api.data.DataType;
import net.algart.executors.api.data.Port;
import net.algart.executors.modules.core.common.matrices.MultiMatrixGenerator;
import net.algart.math.functions.Func;
import net.algart.math.functions.Func2;
import net.algart.multimatrix.MultiMatrix;

public final class ExampleSMatFunction
extends Executor {
    private int width = 1000;
    private int height = 1000;
    private Class<?> elementType = Byte.TYPE;

    public void process() {
        System.out.printf("Creating beautiful test %dx%d%n", this.width, this.height);
        AbstractList<Matrix<? extends PArray>> m = new AbstractList<Matrix<? extends PArray>>(){

            @Override
            public Matrix<ByteArray> get(int index) {
                return Matrices.asCoordFuncMatrix((boolean)false, (Func)((Func2)(x, y) -> {
                    if (y < (double)ExampleSMatFunction.this.height / 4.0) {
                        return x;
                    }
                    if (y < (double)ExampleSMatFunction.this.height / 2.0) {
                        return index > 0 ? 0.0 : x / 2.0;
                    }
                    return x * y * (double)(index + 1) / 10.0;
                }), ByteArray.class, (long[])new long[]{ExampleSMatFunction.this.width, ExampleSMatFunction.this.height});
            }

            @Override
            public int size() {
                return 3;
            }
        };
        this.getMat().setTo((MultiMatrix)MultiMatrix.of2DRGBA((List)m).asPrecision(this.elementType));
    }

    public void onChangeParameter(String name) {
        switch (name) {
            case "width": {
                this.width = this.parameters().getInteger(name);
                break;
            }
            case "height": {
                this.height = this.parameters().getInteger(name);
                break;
            }
            case "elementType": {
                this.elementType = MultiMatrixGenerator.elementType((String)this.parameters().getString(name));
            }
        }
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.printf("Usage: %s target_image%n", ExampleSMatFunction.class);
            return;
        }
        ExampleSMatFunction e = new ExampleSMatFunction();
        e.addPort(Port.newOutput((String)DEFAULT_OUTPUT_PORT, (DataType)DataType.MAT));
        e.execute();
    }
}

