/*
 * Decompiled with CFR 0.152.
 */
package net.algart.graalvm.tests;

import java.util.HashMap;
import java.util.Locale;
import javax.script.ScriptException;
import net.algart.executors.api.graalvm.GraalSafety;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.Source;
import org.graalvm.polyglot.Value;

public class GraalBindingSpeed {
    private static final int N = 1000;
    Context safe = GraalSafety.SAFE.newBuilder(new String[0]).build();
    Context pure = GraalSafety.PURE.newBuilder(new String[0]).build();
    Source creation = Source.newBuilder((String)"js", (CharSequence)"function createObject() { return new Object() }\ncreateObject", (String)"test.mjs").buildLiteral();
    Source quickCode = Source.newBuilder((String)"js", (CharSequence)"function exec(obj) {   return obj.c = obj.a + obj.b}\n\nexec", (String)"test1.mjs").buildLiteral();
    Source detailedCode = Source.newBuilder((String)"js", (CharSequence)"function exec(obj) {   obj.c = obj.a + obj.b;\n   print(obj, typeof(obj));\n   print(obj.a, typeof(obj.a));\n   print(obj.b, typeof(obj.b));\n   print(obj.c, typeof(obj.c));\n   return obj.c\n}\n\nexec", (String)"test2.mjs").buildLiteral();

    public void testMap(Context context, boolean detailed) {
        Source code = detailed ? this.detailedCode : this.quickCode;
        int n = detailed ? 1 : 1000;
        long t1 = System.nanoTime();
        Value func = null;
        for (int k = 0; k < n; ++k) {
            func = context.eval(code);
        }
        assert (func != null);
        long t2 = System.nanoTime();
        HashMap<String, Integer> map = null;
        for (int k = 0; k < n; ++k) {
            map = new HashMap<String, Integer>();
            map.put("a", 1);
            map.put("b", 2);
        }
        long t3 = System.nanoTime();
        Value result = null;
        for (int k = 0; k < n; ++k) {
            result = func.execute(new Object[]{map});
        }
        long t4 = System.nanoTime();
        System.out.printf(Locale.US, "Found %s = %s: %.3f mcs = script %.3f mcs + creating map %.3f mcs + performing %.3f mcs%n", result, map.get("c"), (double)(t4 - t1) * 0.001 / (double)n, (double)(t2 - t1) * 0.001 / (double)n, (double)(t3 - t2) * 0.001 / (double)n, (double)(t4 - t3) * 0.001 / (double)n);
    }

    public void testJSObject(Context context, boolean detailed) {
        Source code = detailed ? this.detailedCode : this.quickCode;
        int n = detailed ? 1 : 1000;
        long t1 = System.nanoTime();
        Value func = null;
        Value creator = null;
        for (int k = 0; k < n; ++k) {
            func = context.eval(code);
            creator = context.eval(this.creation);
        }
        assert (func != null);
        long t2 = System.nanoTime();
        Value obj = null;
        for (int k = 0; k < n; ++k) {
            obj = creator.execute(new Object[0]);
            obj.putMember("a", (Object)10);
            obj.putMember("b", (Object)20);
        }
        long t3 = System.nanoTime();
        Value result = null;
        for (int k = 0; k < n; ++k) {
            result = func.execute(new Object[]{obj});
        }
        long t4 = System.nanoTime();
        System.out.printf(Locale.US, "Found %s = %s: %.3f mcs = script %.3f mcs + creating map %.3f mcs + performing %.3f mcs%n", result, obj.getMember("c"), (double)(t4 - t1) * 0.001 / (double)n, (double)(t2 - t1) * 0.001 / (double)n, (double)(t3 - t2) * 0.001 / (double)n, (double)(t4 - t3) * 0.001 / (double)n);
    }

    public static void main(String[] args) throws ScriptException, InterruptedException {
        GraalBindingSpeed test = new GraalBindingSpeed();
        for (int k = 1; k <= 200; ++k) {
            System.out.printf("Test #%d%n", k);
            System.out.print("Map, safe:    ");
            test.testMap(test.safe, false);
            System.out.print("Object, safe: ");
            test.testJSObject(test.safe, false);
            System.out.print("Object, pure: ");
            test.testJSObject(test.pure, false);
        }
        System.out.println();
        System.out.println("Safe, map:");
        test.testMap(test.safe, true);
        System.out.println();
        test.testMap(test.safe, true);
        System.out.println();
        System.out.println("Safe, JS object:");
        test.testJSObject(test.safe, true);
        System.out.println();
        test.testJSObject(test.safe, true);
        System.out.println();
        System.out.println("Pure, JS object:");
        test.testJSObject(test.pure, true);
        System.out.println();
        test.testJSObject(test.pure, true);
        System.out.println();
    }
}

