/*
 * Decompiled with CFR 0.152.
 */
package net.algart.graalvm.tests;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Locale;
import javax.script.ScriptException;
import net.algart.graalvm.GraalContextCustomizer;
import net.algart.graalvm.GraalPerformer;
import net.algart.graalvm.GraalPerformerContainer;
import net.algart.graalvm.GraalSourceContainer;
import net.algart.graalvm.JSType;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.Source;
import org.graalvm.polyglot.Value;

public class GraalContextImportTest {
    public static void main(String[] args) throws ScriptException {
        Path currentDirectory = Paths.get("src/test/java/net/algart/graalvm/tests", new String[0]);
        String moduleFile = "./js/sometest.mjs";
        Path modulePath = currentDirectory.resolve(Paths.get("./js/sometest.mjs", new String[0]));
        String src = "import {test} from './js/sometest.mjs';\nconst foo = test(['Literal script','A','B']);\nexport function myFunc(o) { return test(o); }\nexport function myFunc2() { return externalValue; }\nmyFunc2";
        System.out.printf("Evaluating:%n*****%n%s%n*****%n", src);
        for (int test = 1; test <= 10; ++test) {
            System.out.printf("%n%nTest #%d%n", test);
            long t1 = System.nanoTime();
            GraalPerformerContainer.Local performerContainer = GraalPerformerContainer.getLocal((GraalContextCustomizer)GraalContextCustomizer.ALL_ACCESS).setWorkingDirectory(currentDirectory.toAbsolutePath());
            long t2 = System.nanoTime();
            GraalSourceContainer sourceContainer = GraalSourceContainer.newLiteralContainer().setModuleJS((CharSequence)src, "test");
            long t3 = System.nanoTime();
            GraalPerformer performer = performerContainer.performer();
            long t4 = System.nanoTime();
            Source source = sourceContainer.source();
            long t5 = System.nanoTime();
            Value bindings = performer.bindingsJS();
            long t6 = System.nanoTime();
            bindings.putMember("externalValue", (Object)"**Value from java**");
            long t7 = System.nanoTime();
            Value func = performer.perform(source);
            long t8 = System.nanoTime();
            func.execute(new Object[0]);
            long t9 = System.nanoTime();
            Context simpleContext = Context.create((String[])new String[0]);
            simpleContext.getBindings("js");
            long t10 = System.nanoTime();
            System.out.printf(Locale.US, "Creating context container: %.3f mcs%nCreating source container: %.3f mcs%nGetting performer: %.3f mcs%nGetting source: %.3f mcs%nGetting JavaScript bindings: %.3f mcs%nPutting value into bindings: %.3f mcs%nPerforming code: %.3f mcs%nCalling function: %.3f mcs%nCreating simple test context: %.3f mcs%n%n", (double)(t2 - t1) * 0.001, (double)(t3 - t2) * 0.001, (double)(t4 - t3) * 0.001, (double)(t5 - t4) * 0.001, (double)(t6 - t5) * 0.001, (double)(t7 - t6) * 0.001, (double)(t8 - t7) * 0.001, (double)(t9 - t8) * 0.001, (double)(t10 - t9) * 0.001);
            System.out.println("eval result: " + String.valueOf(func));
            System.out.println("Function: " + String.valueOf(func));
            System.out.println();
            System.out.println("Again, same source:");
            performer.perform(sourceContainer);
            System.out.println();
            System.out.println("Again, new source with same name:");
            sourceContainer = GraalSourceContainer.newLiteralContainer();
            sourceContainer.setJS(JSType.MODULE, (CharSequence)src, "test");
            performer.perform(sourceContainer);
            System.out.println();
            System.out.println("Again, new source with other name:");
            sourceContainer.setName("test1.mjs");
            performer.perform(sourceContainer);
            System.out.println();
            System.out.println("Calling function");
            t1 = System.nanoTime();
            int[] intArray = new int[]{11, 12, 13};
            Value execute = func.execute(new Object[]{intArray});
            t2 = System.nanoTime();
            System.out.printf(Locale.US, "Calling function: %.3f mcs%n", (double)(t2 - t1) * 0.001);
            System.out.println(execute);
            String jsObjectScript = "new Object()";
            Value jsObject = performer.perform(Source.create((String)"js", (CharSequence)"new Object()"));
            jsObject.putMember("c", (Object)new double[]{111.0, 111.1});
            jsObject.putMember("d", (Object)"Java-string");
            System.out.println(jsObject);
            System.out.println("Caling function");
            execute = func.execute(new Object[]{jsObject});
            System.out.println(execute);
        }
    }
}

