/*
 * Decompiled with CFR 0.152.
 */
package net.algart.graalvm.tests;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Locale;
import javax.script.ScriptException;
import net.algart.graalvm.GraalContextCustomizer;
import net.algart.graalvm.GraalPerformer;
import net.algart.graalvm.GraalPerformerContainer;
import net.algart.graalvm.GraalSourceContainer;
import org.graalvm.polyglot.Source;
import org.graalvm.polyglot.Value;

public class GraalSourceFileTest {
    public static void main(String[] args) throws ScriptException {
        Path currentDirectory = Paths.get("src/test/java/net/algart/graalvm/tests", new String[0]);
        String moduleFile = "./js/sometest.mjs";
        Path modulePath = currentDirectory.resolve(Paths.get("./js/sometest.mjs", new String[0]));
        for (int test = 1; test <= 10; ++test) {
            System.out.printf("%n%nTest #%d%n", test);
            long t1 = System.nanoTime();
            GraalPerformerContainer.Local performerContainer = GraalPerformerContainer.getLocal((GraalContextCustomizer)GraalContextCustomizer.ALL_ACCESS).setJsEsmEvalReturnsExports(true).setWorkingDirectory(currentDirectory.toAbsolutePath());
            long t2 = System.nanoTime();
            GraalSourceContainer sourceContainer = GraalSourceContainer.newFileContainer().setModuleJS(modulePath, "test");
            long t3 = System.nanoTime();
            GraalPerformer performer = performerContainer.performer();
            long t4 = System.nanoTime();
            Source source = sourceContainer.source();
            long t5 = System.nanoTime();
            Value func = performer.perform(source).getMember("simpleTest");
            long t6 = System.nanoTime();
            Value result = func.execute(new Object[0]);
            long t7 = System.nanoTime();
            System.out.printf(Locale.US, "Creating context container: %.3f mcs%nCreating source container: %.3f mcs%nGetting performer: %.3f mcs%nGetting source: %.3f mcs%nPerforming code: %.3f mcs%nCalling function: %.3f mcs%n%n", (double)(t2 - t1) * 0.001, (double)(t3 - t2) * 0.001, (double)(t4 - t3) * 0.001, (double)(t5 - t4) * 0.001, (double)(t6 - t5) * 0.001, (double)(t7 - t6) * 0.001);
            System.out.println("execute result: " + String.valueOf(result));
            System.out.println("Function: " + String.valueOf(func));
        }
    }
}

