/*
 * Decompiled with CFR 0.152.
 */
package net.algart.graalvm.tests;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.script.ScriptException;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.Source;
import org.graalvm.polyglot.Value;

public class GraalVMImportTest {
    private static final boolean USE_EXPORTS = false;

    public static void main(String[] args) throws ScriptException {
        Path currentDirectory = Paths.get("src/test/java/net/algart/graalvm/tests", new String[0]);
        String moduleFile = "./js/sometest.mjs";
        Path modulePath = currentDirectory.resolve(Paths.get("./js/sometest.mjs", new String[0]));
        System.out.println("Loading " + String.valueOf(modulePath.toAbsolutePath()));
        if (!Files.exists(modulePath, new LinkOption[0])) {
            throw new IllegalStateException("No file at " + String.valueOf(modulePath));
        }
        String src = "import {test} from './js/sometest.mjs';\nconst foo = test(['Literal script','A','B']);\nexport function myFunc(o) { return test(o); }\nexport function myFunc2(o) { return test(o); }\nconsole.log('----- 5+3=' + (5+3));console.log(foo);\n[test, myFunc]";
        System.out.printf("Evaluating:%n*****%n%s%n*****%n", src);
        Context.Builder builder = Context.newBuilder((String[])new String[]{"js"}).allowAllAccess(true).currentWorkingDirectory(currentDirectory.toAbsolutePath());
        Context context = builder.build();
        Source source = Source.newBuilder((String)"js", (CharSequence)src, (String)"test.mjs").buildLiteral();
        Value result = context.eval(source);
        System.out.println("eval result: " + String.valueOf(result));
        Value func = context.eval(source).getArrayElement(1L);
        System.out.println("Function: " + String.valueOf(func));
        System.out.println();
        System.out.println("Again, same source:");
        context.eval(source);
        System.out.println();
        System.out.println("Again, new source with same name:");
        source = Source.newBuilder((String)"js", (CharSequence)src, (String)"test.mjs").buildLiteral();
        context.eval(source);
        System.out.println();
        System.out.println("Again, new source with other name:");
        source = Source.newBuilder((String)"js", (CharSequence)src, (String)"test1.mjs").buildLiteral();
        context.eval(source);
        System.out.println();
        System.out.println("Caling function");
        int[] intArray = new int[]{11, 12, 13};
        Value execute = func.execute(new Object[]{intArray});
        System.out.println(execute);
        String jsObjectScript = "new Object()";
        Value jsObject = context.eval(Source.create((String)"js", (CharSequence)"new Object()"));
        jsObject.putMember("c", (Object)new double[]{111.0, 111.1});
        jsObject.putMember("d", (Object)"Java-string");
        System.out.println(jsObject);
        System.out.println("Caling function");
        execute = func.execute(new Object[]{jsObject});
        System.out.println(execute);
    }
}

