/*
 * Decompiled with CFR 0.152.
 */
package net.algart.json;

import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.algart.json.Jsons;

public class EscapingJsonStringTest {
    private static void writeEscapedString(StringBuilder sb, CharSequence string) {
        int len = string.length();
        block8: for (int i = 0; i < len; ++i) {
            int begin = i;
            int end = i;
            char c = string.charAt(i);
            while (c >= ' ' && c != '\"' && c != '\\') {
                end = ++i;
                if (i >= len) break;
                c = string.charAt(i);
            }
            if (begin < end) {
                sb.append(string, begin, end);
                if (i == len) break;
            }
            switch (c) {
                case '\"': 
                case '\\': {
                    sb.append('\\');
                    sb.append(c);
                    continue block8;
                }
                case '\b': {
                    sb.append('\\');
                    sb.append('b');
                    continue block8;
                }
                case '\f': {
                    sb.append('\\');
                    sb.append('f');
                    continue block8;
                }
                case '\n': {
                    sb.append('\\');
                    sb.append('n');
                    continue block8;
                }
                case '\r': {
                    sb.append('\\');
                    sb.append('r');
                    continue block8;
                }
                case '\t': {
                    sb.append('\\');
                    sb.append('t');
                    continue block8;
                }
                default: {
                    String hex = "000" + Integer.toHexString(c);
                    sb.append("\\u").append(hex.substring(hex.length() - 4));
                }
            }
        }
    }

    public static void main(String[] args) throws IOException {
        if (args.length < 1) {
            System.out.printf("Usage: %s some_file_with_large_string%n", EscapingJsonStringTest.class.getName());
            return;
        }
        Path file = Paths.get(args[0], new String[0]);
        byte[] bytes = Files.readAllBytes(file);
        String s = new String(bytes, StandardCharsets.UTF_8);
        System.out.println(s);
        System.out.println();
        JsonObjectBuilder builder = Json.createObjectBuilder();
        builder.add("value", s);
        JsonObject json = builder.build();
        String escapedJson = Jsons.toPrettyString((JsonObject)json);
        System.out.println(escapedJson);
        System.out.println();
        StringBuilder sb = new StringBuilder();
        EscapingJsonStringTest.writeEscapedString(sb, s);
        String escaped = "\"" + String.valueOf(sb) + "\"";
        System.out.println(sb);
        System.out.println();
        if (!escapedJson.contains(escaped)) {
            throw new AssertionError((Object)"Invalid escaping");
        }
    }
}

