/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.application;

import com.siams.cv.monitor.ui.factory.Deletable;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public abstract class BasePooling
implements Deletable {
    private final Logger logger = Logger.getLogger(BasePooling.class);
    protected long interval = 1L;
    protected TimeUnit timeUnit = TimeUnit.SECONDS;
    protected Timer timer = null;
    private boolean poolingInProgress = false;

    public abstract void startPooling();

    public void startPooling(final String timerName) {
        int period = (int)TimeUnit.MILLISECONDS.convert(this.interval, this.timeUnit);
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
        this.timer = new Timer(true);
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                if (BasePooling.this.poolingInProgress) {
                    BasePooling.this.logger.info((Object)String.format("Prevent additional pooling request: %s", timerName));
                    return;
                }
                BasePooling.this.poolingInProgress = true;
                BasePooling.this.timerTask().whenComplete((v, t) -> {
                    BasePooling.this.poolingInProgress = false;
                });
            }
        }, 0L, (long)period);
    }

    protected abstract CompletableFuture<Void> timerTask();

    public void stopPooling() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
        this.poolingInProgress = false;
    }

    @Override
    public void release() {
        this.stopPooling();
    }
}

