/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.application;

import com.scichains.ide.application.SciChainsIDE;
import com.siams.cv.monitor.application.App;
import com.siams.cv.monitor.transport.grpc.GrpcTransport;
import com.siams.stare.api.StareApi;
import com.siams.stare.grpc.StareGrpc;
import io.grpc.ConnectivityState;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class BlockChain {
    private static final Logger logger = Logger.getLogger(BlockChain.class);
    private static String SessionId = "";
    private static StareApi stareApi;
    private static ConnectivityListener connectivityListener;
    private static final Object acceptConnectivityState;

    public static void openProject(String projectUrl) {
        try {
            String jdk = BlockChain.currentJavaHome();
            Path java = BlockChain.javaExecutable(jdk);
            ArrayList<String> commands = new ArrayList<String>();
            commands.add(java.toFile().getAbsolutePath());
            commands.add("-classpath");
            commands.add("stare-javafx-client-2.0.0.jar" + File.pathSeparatorChar + "lib/*" + File.pathSeparatorChar + "modules/*");
            Matcher matcher = Pattern.compile("^(\\d*)").matcher(System.getProperty("java.version"));
            if (matcher.find() && Integer.parseInt(matcher.group(1)) > 8) {
                commands.add("--module-path");
                commands.add(BlockChain.getMavenModulePath());
                commands.add("--add-modules");
                commands.add(BlockChain.listUsedJavaModules());
            }
            commands.add(SciChainsIDE.class.getCanonicalName());
            if (App.getInstance().getProgramArguments().isDebug()) {
                commands.add("debug=1");
            }
            if (projectUrl != null) {
                commands.add(String.format("\"project=%s\"", projectUrl));
            }
            if (logger.isDebugEnabled()) {
                commands.forEach(arg_0 -> ((Logger)logger).debug(arg_0));
            }
            ProcessBuilder pb = new ProcessBuilder(commands);
            pb.inheritIO();
            pb.start();
        }
        catch (Throwable t) {
            logger.error((Object)String.format("Failed run StareMonitor with project: %s", projectUrl), t);
        }
    }

    public static void openNewProject(File initialProject) throws IOException {
        String jdk = BlockChain.currentJavaHome();
        Path java = BlockChain.javaExecutable(jdk);
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(java.toFile().getAbsolutePath());
        commands.add("-classpath");
        commands.add("stare-javafx-client-2.0.0.jar" + File.pathSeparatorChar + "lib/*" + File.pathSeparatorChar + "modules/*");
        Matcher matcher = Pattern.compile("^(\\d*)").matcher(System.getProperty("java.version"));
        if (matcher.find() && Integer.parseInt(matcher.group(1)) > 8) {
            commands.add("--module-path");
            commands.add(BlockChain.getMavenModulePath());
            commands.add("--add-modules");
            commands.add(BlockChain.listUsedJavaModules());
        }
        System.getProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
            if (key instanceof String) {
                String k = (String)key;
                if (value instanceof String) {
                    String v = (String)value;
                    if (k.startsWith("com.scichains") || k.startsWith("net.algart")) {
                        commands.add(String.format("-D%s=%s", k, v));
                    }
                }
            }
        }));
        commands.add(SciChainsIDE.class.getCanonicalName());
        if (App.getInstance().getProgramArguments().isDebug()) {
            commands.add("debug=1");
        }
        if (initialProject != null) {
            commands.add(String.format("initProject=%s", initialProject.getAbsolutePath()));
        }
        if (logger.isDebugEnabled()) {
            commands.forEach(arg_0 -> ((Logger)logger).debug(arg_0));
        }
        logger.info((Object)String.format("Running new process: %s", String.join((CharSequence)" ", commands)));
        ProcessBuilder pb = new ProcessBuilder(commands);
        pb.inheritIO();
        pb.start();
    }

    public static void main(String[] args) throws InterruptedException {
        PropertyConfigurator.configure((String)"log4j.blockchain.properties");
        logger.info((Object)"****************************************** BlockChain *******************************************");
        BlockChain.parseArgs(args);
        if (!SessionId.isEmpty()) {
            BlockChain.restoreSession(SessionId);
        } else {
            BlockChain.startMonitor(args);
        }
    }

    private static void startMonitor(String[] args) {
        logger.trace((Object)"Starting monitor...");
        SciChainsIDE.main(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void restoreSession(String sessionId) throws InterruptedException {
        logger.trace((Object)String.format("Restore session: %s", sessionId));
        String host = GrpcTransport.DEFAULT_CONNECTION_HOST;
        int port = GrpcTransport.DEFAULT_CONNECTION_PORT;
        logger.trace((Object)String.format("Connect to grpc server %s:%d", host, port));
        stareApi = StareGrpc.create((String)host, (int)port, (Consumer)connectivityListener);
        Object object = acceptConnectivityState;
        synchronized (object) {
            logger.trace((Object)"acceptConnectivityState.wait(30s)");
            acceptConnectivityState.wait(30000L);
        }
    }

    private static void openProjects(String sessionId) {
        String resourceUrl = String.format("/session:%s/project", sessionId);
        ((CompletableFuture)stareApi.getList(resourceUrl).thenAccept(list -> {
            if (list.isEmpty()) {
                logger.info((Object)String.format("Empty project list: %s", resourceUrl));
            }
            List projectUrls = list.stream().filter(url -> url.contains(String.format("/session:%s/project:", sessionId))).collect(Collectors.toList());
            for (String projectUrl : projectUrls) {
                BlockChain.openProject(projectUrl);
            }
            Object object = acceptConnectivityState;
            synchronized (object) {
                logger.trace((Object)"acceptConnectivityState.notify()");
                acceptConnectivityState.notify();
            }
        })).exceptionally(t -> {
            logger.error((Object)String.format("Failed get list: /session:%s/project", sessionId), t);
            return null;
        });
    }

    private static void parseArgs(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            logger.trace((Object)String.format("arg[%d] '%s'", i, arg));
            if (!arg.startsWith("session:")) continue;
            SessionId = arg.substring("session:".length());
        }
    }

    private static String currentJavaHome() {
        String s = System.getProperty("java.home");
        if (s == null) {
            throw new IllegalStateException("Null java.home system property");
        }
        return s;
    }

    private static Path javaExecutable(String jdkHome) throws RuntimeException {
        if (jdkHome == null) {
            throw new NullPointerException("Null jdkHome argument");
        }
        Path jdkPath = Paths.get(jdkHome, new String[0]);
        if (!Files.exists(jdkPath, new LinkOption[0])) {
            throw new RuntimeException("Java home directory " + String.valueOf(jdkPath) + " does not exist");
        }
        Path javaBin = jdkPath.resolve("bin");
        Path javaFile = javaBin.resolve("java");
        if (!Files.exists(javaFile, new LinkOption[0])) {
            javaFile = javaBin.resolve("java.exe");
        }
        if (!Files.exists(javaFile, new LinkOption[0])) {
            throw new RuntimeException("Cannot find java utility at " + String.valueOf(javaFile));
        }
        return javaFile;
    }

    private static String getMavenModulePath() {
        StringJoiner sj = new StringJoiner(";");
        sj.add("modules");
        return sj.toString();
    }

    private static String listUsedJavaModules() {
        StringJoiner sj = new StringJoiner(",");
        sj.add("javafx.base");
        sj.add("javafx.controls");
        sj.add("javafx.fxml");
        sj.add("javafx.graphics");
        sj.add("javafx.media");
        sj.add("javafx.swing");
        sj.add("javafx.web");
        return sj.toString();
    }

    static {
        connectivityListener = new ConnectivityListener();
        acceptConnectivityState = new Object();
    }

    private static class ConnectivityListener
    implements Consumer<ConnectivityState> {
        private static boolean initialized = false;

        private ConnectivityListener() {
        }

        @Override
        public void accept(ConnectivityState state) {
            if (!initialized && state == ConnectivityState.READY) {
                initialized = true;
                BlockChain.openProjects(SessionId);
            }
        }
    }
}

