/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.application;

import com.siams.cv.monitor.application.App;
import com.siams.cv.monitor.application.UserAction;
import com.siams.cv.monitor.model.IIdentifiable;
import com.siams.cv.monitor.model.storage.NodeStorage;
import com.siams.cv.monitor.ui.factory.UIBlock;
import com.siams.notifications.StareNotification;
import javafx.scene.Scene;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;

public class GlobalHotKeys {
    private static final App app = App.getInstance();

    public static void initializeGlobalHotKeys(Scene scene) {
        scene.addEventFilter(KeyEvent.KEY_PRESSED, e -> {
            boolean isConsumed = true;
            switch (e.getCode()) {
                case F5: {
                    if (e.isControlDown() || e.isShiftDown()) break;
                    UserAction.executeChain();
                    break;
                }
                default: {
                    isConsumed = false;
                }
            }
            if (isConsumed) {
                e.consume();
            }
        });
        scene.addEventHandler(KeyEvent.KEY_RELEASED, e -> {
            boolean isConsumed = true;
            switch (e.getCode()) {
                case F2: {
                    if (e.isControlDown()) {
                        UserAction.interruptChain(false);
                        break;
                    }
                    UserAction.editUiBlockModelCaption();
                    break;
                }
                case F3: {
                    IIdentifiable introspectedObject;
                    if (e.isAltDown() || e.isControlDown() || e.isShiftDown() || !((introspectedObject = app.getIntrospectedObject()) instanceof UIBlock)) break;
                    ((UIBlock)introspectedObject).callViewer();
                    break;
                }
                case F4: {
                    IIdentifiable introspectedObject;
                    if (e.isAltDown() || e.isControlDown() || e.isShiftDown() || !((introspectedObject = app.getIntrospectedObject()) instanceof UIBlock)) break;
                    UserAction.openBlockTuner(((UIBlock)introspectedObject).getNodeModel());
                    break;
                }
                case F5: {
                    if (!e.isControlDown() || !e.isShiftDown()) break;
                    app.getSelectedObjects().forEach(stareNode -> NodeStorage.getInstance().findFirst(UIBlock.class, stareNode.getUuid()).ifPresent(uiBlock -> UserAction.executeWorker(uiBlock.getUuid())));
                    break;
                }
                case F7: {
                    UserAction.scrollToModel();
                    break;
                }
                case F8: {
                    UserAction.scrollToFunction();
                    break;
                }
                case F10: {
                    UserAction.executeChainStep();
                    break;
                }
                case A: {
                    IIdentifiable introspected;
                    if (!e.isControlDown() || !e.isShiftDown() || (introspected = app.getIntrospectedObject()) == null) break;
                    UserAction.addViewerToCompare(introspected.getUuid(), 1);
                    break;
                }
                case D: {
                    if (!e.isControlDown()) break;
                    boolean isEnabled = e.isShiftDown();
                    app.getSelectedObjects().forEach(stareNode -> app.rqSetEnabled((IIdentifiable)stareNode, isEnabled).thenAccept(v -> NodeStorage.getInstance().findFirst(stareNode.getUuid(), UIBlock.class).ifPresent(uiBlock -> uiBlock.setEnabled(isEnabled))));
                    break;
                }
                case F: {
                    if (!e.isControlDown()) break;
                    UserAction.setFocus(UserAction.Focus.REGISTERED_COMPONENT_FILTER);
                    break;
                }
                case L: {
                    if (!e.isControlDown() || !e.isAltDown()) break;
                    UserAction.loadingLeastRecentStareProject().exceptionally(err -> {
                        StareNotification.showWarn((String)"Failed open project");
                        err.printStackTrace();
                        return null;
                    });
                    break;
                }
                case Q: {
                    if (!e.isControlDown()) break;
                    UserAction.showHelpSelectedObject();
                    break;
                }
                case R: {
                    if (!e.isControlDown()) break;
                    UserAction.reloadCurrentChain().exceptionally(t -> {
                        StareNotification.showWarn((String)"Failed to reload current chain", (Throwable)t);
                        return null;
                    });
                    break;
                }
                case W: {
                    if (!e.isControlDown()) break;
                    UserAction.showCompareViewer(1);
                    break;
                }
                case DIGIT1: 
                case DIGIT2: 
                case DIGIT3: 
                case DIGIT4: 
                case DIGIT5: 
                case DIGIT6: 
                case DIGIT7: 
                case DIGIT8: 
                case DIGIT9: {
                    int groupNumber = e.getCode().ordinal() - KeyCode.DIGIT1.ordinal() + 1;
                    if (e.isControlDown() && e.isShiftDown()) {
                        UserAction.addViewerToCompare(app.getSelectedObjects().get(0).getUuid(), groupNumber);
                        break;
                    }
                    if (e.isControlDown()) {
                        UserAction.showCompareViewer(groupNumber);
                        break;
                    }
                    isConsumed = false;
                    break;
                }
                default: {
                    isConsumed = false;
                }
            }
            if (isConsumed) {
                e.consume();
            }
        });
    }
}

