/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.application;

import com.siams.cv.monitor.application.App;
import com.siams.cv.monitor.application.BasePooling;
import com.siams.cv.monitor.message.StareMonitorClosing;
import com.siams.cv.monitor.message.StareProjectLoaded;
import com.siams.cv.monitor.message.StareServerTimeout;
import com.siams.cv.monitor.message.StatisticResultReady;
import com.siams.cv.monitor.model.statistic.Statistic;
import com.siams.stare.api.ResourceFilter;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.apache.log4j.Logger;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;

public class StatisticPooling
extends BasePooling {
    private final Logger logger = Logger.getLogger(StatisticPooling.class);
    private static StatisticPooling instance;
    private long lastModified = 0L;

    public static StatisticPooling getInstance() {
        if (instance == null) {
            instance = new StatisticPooling();
        }
        return instance;
    }

    private StatisticPooling() {
        this.subscribe();
    }

    private void subscribe() {
        EventBus.getDefault().register((Object)this);
    }

    @Subscribe
    public void onStareProjectLoaded(StareProjectLoaded event) {
        this.startPooling();
    }

    @Subscribe
    public void onStareMonitorClosing(StareMonitorClosing event) {
        this.release();
    }

    @Subscribe
    public void onStareServerTimeout(StareServerTimeout event) {
        this.stopPooling();
    }

    @Override
    public void stopPooling() {
        super.stopPooling();
        this.lastModified = 0L;
    }

    @Override
    protected CompletableFuture<Void> timerTask() {
        CompletionStage<Void> deferred = new CompletableFuture<Void>();
        try {
            boolean hasProjectUrl;
            App app = App.getInstance();
            boolean bl = hasProjectUrl = !app.getProject().getUrl().isEmpty();
            if (!hasProjectUrl) {
                deferred.complete(null);
                return deferred;
            }
            ResourceFilter filter = new ResourceFilter();
            filter.setModifiedAfter(this.lastModified);
            long t0 = System.currentTimeMillis();
            deferred = ((CompletableFuture)app.rqGetStatistics(filter).thenAccept(statistics -> {
                for (Statistic statistic : statistics) {
                    this.lastModified = Math.max(this.lastModified, statistic.getModified());
                    EventBus.getDefault().post((Object)new StatisticResultReady(statistic));
                }
            })).whenComplete((v, t) -> {
                if (t != null) {
                    this.logger.error((Object)"Failed get statistics", t);
                }
            });
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return deferred;
    }

    @Override
    public void release() {
        super.release();
        if (EventBus.getDefault().isRegistered((Object)this)) {
            EventBus.getDefault().unregister((Object)this);
        }
    }

    @Override
    public void startPooling() {
        super.startPooling("Statistic pooling");
    }
}

