/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.model.app;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.siams.collection.CollectionsUtils;
import com.siams.cv.monitor.model.Model;
import com.siams.cv.monitor.model.app.PropertiesModel;
import com.siams.cv.monitor.model.app.Root;
import com.siams.cv.monitor.model.legacy.ProjectNode;
import com.siams.cv.monitor.model.node.UIBlockModel;
import com.siams.cv.monitor.plugin.PluginModel;
import com.siams.cv.monitor.ui.factory.Deletable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class StareProject
implements Deletable {
    @JsonIgnore
    private String caption = "[untitled]";
    @JsonIgnore
    private boolean virginProject = true;
    @JsonProperty(value="app")
    private String app = "SciChains";
    @JsonProperty(value="version")
    private String version = "1.0.0";
    @JsonProperty(value="root")
    private Root root = new Root();
    @JsonProperty(value="nodes")
    private List<Model> nodes = new ArrayList<Model>();
    @Deprecated
    @JsonProperty(value="blocks")
    private List<ProjectNode> blocks = new ArrayList<ProjectNode>();
    @JsonProperty(value="plugins")
    private List<PluginModel> plugins = new ArrayList<PluginModel>();
    @JsonProperty(value="properties")
    private PropertiesModel properties = new PropertiesModel();
    @JsonProperty(value="poke_and_look_project")
    private String pokeAndLookProject = "";

    @JsonGetter(value="poke_and_look_project")
    public String getPokeAndLookProject() {
        return this.pokeAndLookProject;
    }

    @JsonSetter(value="poke_and_look_project")
    public void setPokeAndLookProject(String pokeAndLookProject) {
        this.pokeAndLookProject = pokeAndLookProject;
    }

    @JsonCreator
    public StareProject() {
    }

    public static StareProject valueOf(String json) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        return (StareProject)mapper.readValue(json, StareProject.class);
    }

    public static StareProject valueOf(File file) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        return (StareProject)mapper.readValue(file, StareProject.class);
    }

    public String getCaption() {
        return this.caption != null ? this.caption : "[untitled]";
    }

    public void setCaption(String caption) {
        this.caption = caption != null ? caption : "[untitled]";
    }

    public boolean isVirginProject() {
        return this.virginProject;
    }

    public void setVirginProject(boolean virginProject) {
        this.virginProject = virginProject;
    }

    @JsonGetter(value="app")
    public String getApp() {
        return this.app;
    }

    @JsonGetter(value="version")
    public String getVersion() {
        return this.version;
    }

    @JsonGetter(value="root")
    public Root getRoot() {
        return this.root;
    }

    @JsonGetter(value="nodes")
    public List<Model> getModels() {
        return this.nodes;
    }

    @JsonSetter(value="nodes")
    public void setModels(List<Model> nodes) {
        this.nodes = nodes;
    }

    @Deprecated
    @JsonGetter(value="blocks")
    public List<ProjectNode> getBlocks() {
        return this.blocks;
    }

    @Deprecated
    @JsonSetter(value="blocks")
    public void setBlocks(List<ProjectNode> blocks) {
        this.blocks = blocks;
    }

    @JsonGetter(value="plugins")
    public List<PluginModel> getPlugins() {
        return this.plugins;
    }

    @JsonSetter(value="plugins")
    public void setPlugins(List<PluginModel> plugins) {
        this.plugins = plugins;
    }

    @JsonGetter(value="properties")
    public PropertiesModel getProperties() {
        return this.properties;
    }

    @JsonSetter(value="properties")
    public void setProperties(PropertiesModel properties) {
        this.properties = properties;
    }

    public void addModel(Model model) {
        this.nodes.add(model);
    }

    public Optional<Model> removeModel(UUID uuid) {
        return CollectionsUtils.removeFirst(this.nodes, model -> model.getUuid().equals(uuid));
    }

    public Optional<Model> removeModel(Model model) {
        return CollectionsUtils.removeFirst(this.nodes, m -> m == model);
    }

    public Optional<Model> removeModel(Predicate<Model> predicate) {
        return CollectionsUtils.removeFirst(this.nodes, predicate);
    }

    public <V extends Model> Optional<V> removeModel(Class<V> clazz, Predicate<V> predicate) {
        return CollectionsUtils.removeFirst(this.nodes, predicate, clazz);
    }

    public Optional<Model> findModel(UUID uuid) {
        return this.nodes.stream().filter(node -> node.getUuid().equals(uuid)).findFirst();
    }

    public Optional<Model> findModel(Predicate<Model> predicate) {
        return CollectionsUtils.findFirst(this.nodes, predicate, Model.class);
    }

    public <V extends Model> Optional<V> findModel(Class<V> clazz, Predicate<V> predicate) {
        return CollectionsUtils.findFirst(this.nodes, predicate, clazz);
    }

    public <V extends Model> Optional<V> findModel(UUID uuid, Class<V> clazz) {
        return CollectionsUtils.findFirst(this.nodes, node -> node.getUuid().equals(uuid), clazz);
    }

    public <V extends Model> List<V> findModels(Class<V> clazz) {
        return CollectionsUtils.find(this.nodes, null, clazz);
    }

    public <V extends Model> List<V> findModels(Class<V> clazz, Predicate<V> predicate) {
        return CollectionsUtils.find(this.nodes, predicate, clazz);
    }

    public <T extends PluginModel> Optional<T> findPlugin(String id, Class<T> clazz) {
        return this.plugins.stream().filter(plugin -> plugin.getId().equals(id)).findFirst();
    }

    public boolean hasPlugin(String id) {
        return this.plugins.stream().anyMatch(plugin -> plugin.getId().equals(id));
    }

    public void addPlugin(PluginModel plugin) {
        this.plugins.add(plugin);
    }

    public void setApp(String app) {
        this.app = app;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public void release() {
        this.nodes.forEach(Model::release);
    }

    public <V extends Model> List<V> removeModels(Class<V> clazz, Predicate<V> predicate) {
        return CollectionsUtils.remove(this.nodes, predicate, clazz);
    }

    public List<Model> removeModels(Predicate<Model> predicate) {
        return CollectionsUtils.remove(this.nodes, predicate);
    }

    public List<UIBlockModel> removeInvalidBlocks() {
        return this.removeModels(UIBlockModel.class, uiBlockModel -> {
            UUID id = uiBlockModel.getUuid();
            if (id == null) {
                return true;
            }
            if (id.getLeastSignificantBits() == 0L && id.getMostSignificantBits() == 0L) {
                return true;
            }
            UUID modelId = uiBlockModel.getWorkerType();
            if (modelId == null) {
                return true;
            }
            if (modelId.getLeastSignificantBits() == 0L && modelId.getMostSignificantBits() == 0L) {
                return true;
            }
            uiBlockModel.filterInvalidPorts();
            return false;
        });
    }

    public String toJson() throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        return mapper.writeValueAsString((Object)this);
    }

    public void clear() {
        this.nodes.clear();
        this.blocks.clear();
        this.caption = "[untitled]";
    }
}

