/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.model.storage;

import com.siams.cv.monitor.model.storage.BaseStorage;
import com.siams.cv.monitor.model.viewer.BlockViewerModel;
import com.siams.cv.monitor.model.viewer.ViewerModel;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;

public class ViewerModelStorage
extends BaseStorage<ViewerModel> {
    private static ViewerModelStorage instance = null;

    public static ViewerModelStorage getInstance() {
        if (instance == null) {
            instance = new ViewerModelStorage();
        }
        return instance;
    }

    public static Optional<ViewerModel> findById(UUID uuid) {
        return ViewerModelStorage.getInstance().findFirst(viewerModel -> viewerModel.getUuid().equals(uuid));
    }

    public static Optional<ViewerModel> findByBlockId(UUID blockUuid) {
        return ViewerModelStorage.getInstance().findFirst(viewerModel -> {
            if (BlockViewerModel.class.isAssignableFrom(viewerModel.getClass())) {
                return ((BlockViewerModel)viewerModel).getBlockUuid().equals(blockUuid);
            }
            return false;
        });
    }

    public static Optional<ViewerModel> findByPredicate(Predicate<ViewerModel> predicate) {
        return ViewerModelStorage.getInstance().findFirst(predicate);
    }

    public static Optional<ViewerModel> removeById(UUID uuid) {
        return ViewerModelStorage.getInstance().removeFirst(viewerModel -> viewerModel.getUuid().equals(uuid));
    }

    public static Optional<ViewerModel> removeByBlockId(UUID blockUuid) {
        return ViewerModelStorage.getInstance().removeFirst(viewerModel -> {
            if (BlockViewerModel.class.isAssignableFrom(viewerModel.getClass())) {
                return ((BlockViewerModel)viewerModel).getBlockUuid().equals(blockUuid);
            }
            return false;
        });
    }
}

