/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.transport.grpc;

import com.siams.cv.monitor.application.App;
import com.siams.cv.monitor.message.StareProjectLoaded;
import com.siams.cv.monitor.message.StareProjectLoading;
import com.siams.cv.monitor.message.StareServerConnected;
import com.siams.cv.monitor.message.StareServerTimeout;
import com.siams.cv.monitor.model.app.Project;
import com.siams.cv.monitor.transport.grpc.GRPCSchedule;
import com.siams.cv.monitor.transport.grpc.GrpcV1;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;

public class ChainStatusSchedule
extends GRPCSchedule {
    private final App app = App.getInstance();
    private Logger logger = Logger.getLogger(ChainStatusSchedule.class);

    ChainStatusSchedule(GrpcV1 grpcV1, int interval, TimeUnit timeUnit) {
        super(grpcV1, interval, timeUnit);
        this.subscribe();
    }

    private void subscribe() {
        EventBus.getDefault().register((Object)this);
    }

    @Subscribe
    public void onStareServerConnected(StareServerConnected event) {
        this.releaseTimer();
        this.updateSchedule(this.interval, this.timeUnit, new RequestChainStatus());
    }

    @Subscribe
    public void onStareServerTimeout(StareServerTimeout event) {
        this.releaseTimer();
    }

    @Subscribe
    public void onStareProjectLoading(StareProjectLoading event) {
        this.releaseTimer();
    }

    @Subscribe
    public void onStareProjectLoaded(StareProjectLoaded event) {
        this.releaseTimer();
        this.updateSchedule(this.interval, this.timeUnit, new RequestChainStatus());
    }

    @Override
    public void release() {
        super.release();
        if (EventBus.getDefault().isRegistered((Object)this)) {
            EventBus.getDefault().unregister((Object)this);
        }
    }

    class RequestChainStatus
    extends TimerTask {
        RequestChainStatus() {
        }

        @Override
        public void run() {
            try {
                Project project = ChainStatusSchedule.this.app.getProject();
                if (project != null) {
                    throw new RuntimeException("Unimplemented");
                }
            }
            catch (Exception e) {
                ChainStatusSchedule.this.logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }
}

