/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.transport.grpc;

import com.siams.cv.monitor.message.StareMonitorClosing;
import com.siams.cv.monitor.transport.grpc.ChainStatusSchedule;
import com.siams.cv.monitor.transport.grpc.Grpc;
import com.siams.cv.monitor.transport.grpc.GrpcTransport;
import com.siams.cv.monitor.ui.content.windows.ConnectionWindow;
import com.siams.stare.grpc.StareServiceGrpc;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import java.util.concurrent.TimeUnit;
import java.util.prefs.Preferences;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;

public class GrpcV1
implements Grpc {
    private static GrpcV1 instance = null;
    private ManagedChannel channel = null;
    private StareServiceGrpc.StareServiceStub stub = null;
    private StareServiceGrpc.StareServiceBlockingStub blockingStub = null;
    private ChainStatusSchedule chainStatusSchedule = new ChainStatusSchedule(this, 2500, TimeUnit.MILLISECONDS);

    public static GrpcV1 getInstance() {
        if (instance == null) {
            instance = new GrpcV1();
        }
        return instance;
    }

    GrpcV1() {
        EventBus.getDefault().register((Object)this);
    }

    public StareServiceGrpc.StareServiceStub getStub() {
        return this.stub;
    }

    @Override
    public void setChannel(ManagedChannel channel) {
        this.channel = channel;
        this.blockingStub = StareServiceGrpc.newBlockingStub((Channel)channel);
        this.stub = StareServiceGrpc.newStub((Channel)channel);
    }

    @Override
    public ManagedChannel getChannel() {
        return this.channel;
    }

    public StareServiceGrpc.StareServiceBlockingStub getBlockingStub() {
        return this.blockingStub;
    }

    @Subscribe
    public void onStareMonitorClosing(StareMonitorClosing event) {
        if (EventBus.getDefault().isRegistered((Object)this)) {
            if (this.chainStatusSchedule != null) {
                this.chainStatusSchedule.release();
            }
            EventBus.getDefault().unregister((Object)this);
        }
    }

    public void start() {
        Preferences preferences = Preferences.userNodeForPackage(ConnectionWindow.class);
        String host = preferences.get("host", GrpcTransport.DEFAULT_CONNECTION_HOST);
        int port = preferences.getInt("port", GrpcTransport.DEFAULT_CONNECTION_PORT);
        ManagedChannelBuilder builder = ManagedChannelBuilder.forAddress((String)host, (int)port);
        builder.idleTimeout(5L, TimeUnit.SECONDS);
        this.setChannel(builder.build());
    }
}

