/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.ui;

import com.siams.cv.monitor.entity.StareNode;
import com.siams.cv.monitor.ui.NodeActionHandler;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;

public class NodeClickHandler
extends NodeActionHandler {
    private static final int DELAY = 250;
    private ScheduledThreadPoolExecutor executor;
    private boolean isDoubleClicked = false;

    public NodeClickHandler(Node eventConsumer, StareNode eventTarget) {
        super(eventConsumer, eventTarget);
        this.initialize();
    }

    public NodeClickHandler(Node eventConsumer, StareNode eventTarget, NodeActionHandler.EventConsumptionMode consumptionMode) {
        super(eventConsumer, eventTarget, consumptionMode);
        this.initialize();
    }

    private void initialize() {
        this.executor = new ScheduledThreadPoolExecutor(1);
        this.executor.setRemoveOnCancelPolicy(true);
        this.initializeClickHandler();
    }

    private void initializeClickHandler() {
        switch (this.eventConsumptionMode) {
            case DEFAULT: {
                this.eventConsumer.setOnMouseClicked(this::onClickedHandle);
                break;
            }
            case CAPTURING: {
                this.eventConsumer.addEventFilter(MouseEvent.MOUSE_CLICKED, this::onClickedHandle);
                break;
            }
            case BUBBLING: {
                this.eventConsumer.addEventHandler(MouseEvent.MOUSE_CLICKED, this::onClickedHandle);
            }
        }
    }

    protected void onClick(MouseEvent event) {
    }

    protected void onControlClick(MouseEvent event) {
    }

    protected void onDoubleClick(MouseEvent event) {
    }

    protected void onControlDoubleClick(MouseEvent event) {
    }

    private void onClickedHandle(MouseEvent event) {
        if (event.getButton() != MouseButton.PRIMARY || !event.isStillSincePress()) {
            return;
        }
        this.executor.schedule(() -> {
            if (this.isDoubleClicked) {
                return;
            }
            Platform.runLater(() -> {
                if (event.isControlDown()) {
                    this.onControlClick(event);
                } else {
                    this.onClick(event);
                }
            });
        }, 250L, TimeUnit.MILLISECONDS);
        if (event.getClickCount() == 2) {
            this.isDoubleClicked = true;
            Platform.runLater(() -> {
                if (event.isControlDown()) {
                    this.onControlDoubleClick(event);
                } else {
                    this.onDoubleClick(event);
                }
            });
            this.executor.schedule(() -> {
                this.isDoubleClicked = false;
            }, 500L, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public void release() {
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
    }
}

