/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.ui.content.container;

import com.siams.cv.monitor.entity.type.IDataType;
import com.siams.cv.monitor.message.DataTypesLoaded;
import com.siams.cv.monitor.message.StareMonitorClosing;
import com.siams.cv.monitor.ui.UISync;
import com.siams.cv.monitor.ui.factory.Deletable;
import com.siams.fxml.loader.CustomFXMLLoader;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.ListView;
import javafx.scene.control.TextField;
import javafx.scene.layout.AnchorPane;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;

@Deprecated(since="25.02.2022")
public class RegisteredDataTypes
extends AnchorPane
implements Deletable {
    private static RegisteredDataTypes instance;
    private UISync uiSync = UISync.getInstance();
    private ObservableList<String> data = FXCollections.observableArrayList();
    private FilteredList<String> filteredList = new FilteredList(this.data, s -> true);
    @FXML
    private ListView<String> listViewDataTypes;
    @FXML
    private Button buttonClear;
    @FXML
    private TextField textFieldFilter;

    public static RegisteredDataTypes getInstance() {
        if (instance == null) {
            instance = new RegisteredDataTypes();
        }
        return instance;
    }

    private RegisteredDataTypes() {
        try {
            URL url = this.getClass().getResource("/com/siams/cv/monitor/ui/content/container/RegisteredDataTypes.fxml");
            CustomFXMLLoader.loadElement((Object)this, (URL)url);
            this.initializeListViewDataTypes();
            this.initializeButtonClear();
            this.initializeTextFieldFilter();
            this.subscribe();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void initializeListViewDataTypes() {
        this.listViewDataTypes.setItems(this.filteredList);
    }

    private void initializeButtonClear() {
        this.buttonClear.setOnAction(a -> this.textFieldFilter.clear());
    }

    private void initializeTextFieldFilter() {
        this.textFieldFilter.textProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.isEmpty()) {
                this.filteredList.setPredicate(s -> true);
            } else {
                this.filteredList.setPredicate(s -> s.contains((CharSequence)newValue));
            }
        });
    }

    private void subscribe() {
        EventBus.getDefault().register((Object)this);
    }

    @Subscribe
    public void onDataTypesLoaded(DataTypesLoaded event) {
        this.onUpdateDataTypes(event.getTypes());
    }

    @Subscribe
    public void onStareMonitorClosing(StareMonitorClosing event) {
        this.release();
    }

    private void onUpdateDataTypes(List<IDataType> dataTypes) {
        Platform.runLater(() -> this.update(dataTypes));
    }

    private void update(List<IDataType> dataTypes) {
        this.data.clear();
        for (IDataType dataType : dataTypes) {
            this.data.addAll((Object[])new String[]{dataType.getName()});
        }
    }

    @Override
    public void release() {
        if (EventBus.getDefault().isRegistered((Object)this)) {
            EventBus.getDefault().unregister((Object)this);
        }
    }
}

