/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.ui.content.container;

import com.siams.cv.monitor.application.App;
import com.siams.cv.monitor.application.AppPreference;
import com.siams.cv.monitor.application.UserAction;
import com.siams.cv.monitor.message.ChainStatusChanged;
import com.siams.cv.monitor.message.ProjectExecutionStatusChanged;
import com.siams.cv.monitor.message.StareMonitorClosing;
import com.siams.cv.monitor.message.StareMonitorStarted;
import com.siams.cv.monitor.message.StareServerConnected;
import com.siams.cv.monitor.message.StareServerTimeout;
import com.siams.cv.monitor.ui.content.container.Desktop;
import com.siams.cv.monitor.ui.content.container.FunctionsList;
import com.siams.cv.monitor.ui.content.container.ObjectIntrospection;
import com.siams.cv.monitor.ui.content.container.RunningProcess;
import com.siams.cv.monitor.ui.content.container.UILibraryFunctions;
import com.siams.cv.monitor.ui.factory.Deletable;
import com.siams.cv.monitor.ui.menu.StareMainMenu;
import com.siams.cv.monitor.ui.utils.RxHelper;
import com.siams.fx.components.indicator.FxRunIndicator;
import com.siams.fx.components.tooltip.StareTooltip;
import com.siams.fxml.loader.CustomFXMLLoader;
import com.siams.javafx.PaneHelper;
import com.siams.javafx.utils.FxPlatform;
import com.siams.notifications.StareNotification;
import com.siams.preferences.UIPreference;
import com.siams.stare.api.data.worker.ExecutionStatus;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.concurrent.TimeUnit;
import java.util.prefs.Preferences;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.property.Property;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.SplitPane;
import javafx.scene.control.TabPane;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.util.Duration;
import org.apache.log4j.Logger;
import org.controlsfx.control.StatusBar;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;

public class RootPane
extends BorderPane
implements Deletable,
Initializable,
UIPreference {
    private final App app = App.getInstance();
    private final Logger logger = Logger.getLogger(RootPane.class);
    private final FunctionsList functionsList = FunctionsList.getInstance();
    private final UILibraryFunctions uiLibraryFunctions = UILibraryFunctions.getInstance();
    private final ObjectIntrospection objectIntrospection = ObjectIntrospection.getInstance();
    private final Desktop desktop = Desktop.getInstance();
    private final StareMainMenu stareMainMenu = StareMainMenu.getInstance();
    @FXML
    AnchorPane anchorRunIndicator;
    private FxRunIndicator runIndicator;
    @FXML
    private AnchorPane anchorPaneStareMainMenu;
    @FXML
    private Circle connectionStatus;
    @FXML
    private AnchorPane blocksPane;
    @FXML
    private Button btnRun;
    @FXML
    private Button btnInterrupt;
    @FXML
    private AnchorPane anchorPaneDesktop;
    @FXML
    private AnchorPane anchorPaneRegistered;
    @FXML
    private AnchorPane anchorPaneFunctionsList;
    @FXML
    private AnchorPane anchorPaneObjectIntrospection;
    @FXML
    private AnchorPane anchorPaneControlsAdjustment;
    @FXML
    private AnchorPane anchorPaneRegisteredComponents;
    @FXML
    private SplitPane splitPaneVerticalMainLogs;
    @FXML
    private SplitPane splitPaneHorizontalLeft;
    @FXML
    private SplitPane splitPaneHorizontalRight;
    @FXML
    private TabPane tabPaneObjectIntrospection;
    @FXML
    private StatusBar statusBar;
    private static RootPane instance;

    public static RootPane getInstance() {
        if (instance == null) {
            instance = new RootPane();
        }
        return instance;
    }

    private RootPane() {
        try {
            URL url = this.getClass().getResource("/com/siams/cv/monitor/ui/content/container/RootPane.fxml");
            CustomFXMLLoader.loadElement((Object)this, (URL)url);
            this.initializeRunProgressIndicator();
            this.initializeStareMainMenu();
            this.initializeFunctionsList();
            this.initializeNodeStorageLog();
            this.initializeIIDStorageLog();
            this.initializeObjectIntrospection();
            this.initializeRegisteredComponents();
            this.initializeDesktop();
            this.initializeRunButton();
            this.initializeInterruptButton();
            this.initializeStatusBar();
            this.restorePreference();
            this.subscribe();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void initializeInterruptButton() {
        this.btnInterrupt.setOnAction(evt -> UserAction.interruptChain(true));
        this.btnInterrupt.setTooltip((Tooltip)new StareTooltip("Interrupt current worker (CTRL+F2)"));
    }

    private void initializeStareMainMenu() {
        this.anchorPaneStareMainMenu.getChildren().clear();
        this.anchorPaneStareMainMenu.getChildren().add((Object)this.stareMainMenu);
        PaneHelper.setAnchorZero((Node)this.stareMainMenu);
        PaneHelper.setUsedComputerSize((Pane)this.anchorPaneStareMainMenu);
    }

    private void initializeFunctionsList() {
        this.anchorPaneFunctionsList.getChildren().add((Object)this.functionsList);
        PaneHelper.setAnchorZero((Node)this.functionsList);
    }

    private void initializeNodeStorageLog() {
    }

    private void initializeIIDStorageLog() {
    }

    private void initializeObjectIntrospection() {
        this.anchorPaneObjectIntrospection.getChildren().add((Object)this.objectIntrospection);
        PaneHelper.setAnchorZero((Node)this.objectIntrospection);
    }

    private void initializeRegisteredComponents() {
        this.anchorPaneRegisteredComponents.getChildren().add((Object)this.uiLibraryFunctions);
        PaneHelper.setAnchorZero((Node)this.uiLibraryFunctions);
    }

    private void initializeDesktop() {
        this.desktop.setRunIndicator(this.runIndicator);
        this.anchorPaneDesktop.getChildren().add((Object)this.desktop);
        PaneHelper.setAnchorZero((Node)this.desktop);
    }

    private void initializeRunButton() {
        StareTooltip tooltip = new StareTooltip("Execute chain (F5)");
        this.btnRun.setTooltip((Tooltip)tooltip);
        this.btnRun.setOnAction(event -> UserAction.executeChain());
    }

    private void initializeRunProgressIndicator() {
        this.runIndicator = new FxRunIndicator();
        this.anchorRunIndicator.getChildren().add((Object)this.runIndicator);
    }

    public void restorePreference() {
        try {
            Preferences preferences = Preferences.userNodeForPackage(RootPane.class);
            this.logger.debug((Object)String.format("restore horizontal splitter right: %f", preferences.getDouble("splitPaneHorizontalRight.dividerPositions[0]", 0.0)));
            Timeline timeLine1 = new Timeline(new KeyFrame[]{new KeyFrame(Duration.ONE, e -> {
                this.splitPaneVerticalMainLogs.setDividerPositions(new double[]{preferences.getDouble("splitPaneVerticalMainLogs.dividerPositions[0]", 0.8)});
                this.splitPaneHorizontalLeft.setDividerPositions(new double[]{preferences.getDouble("splitPaneHorizontalLeft.dividerPositions[0]", 0.25)});
            }, new KeyValue[0])});
            Platform.runLater(() -> ((Timeline)timeLine1).play());
            Timeline timeLine2 = new Timeline(new KeyFrame[]{new KeyFrame(Duration.ONE, e -> this.splitPaneHorizontalRight.setDividerPositions(new double[]{preferences.getDouble("splitPaneHorizontalRight.dividerPositions[0]", 0.5)}), new KeyValue[0])});
            timeLine2.setDelay(Duration.millis((double)250.0));
            Platform.runLater(() -> ((Timeline)timeLine2).play());
        }
        catch (SecurityException e2) {
            e2.printStackTrace();
        }
        this.uiLibraryFunctions.restorePreference();
    }

    public void savePreference() {
        try {
            Preferences preferences = Preferences.userNodeForPackage(RootPane.class);
            preferences.putDouble("splitPaneVerticalMainLogs.dividerPositions[0]", this.splitPaneVerticalMainLogs.getDividerPositions()[0]);
            preferences.putDouble("splitPaneHorizontalLeft.dividerPositions[0]", this.splitPaneHorizontalLeft.getDividerPositions()[0]);
            preferences.putDouble("splitPaneHorizontalRight.dividerPositions[0]", this.splitPaneHorizontalRight.getDividerPositions()[0]);
            this.logger.debug((Object)String.format("saved horizontal splitter right: %f", preferences.getDouble("splitPaneHorizontalRight.dividerPositions[0]", 0.0)));
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
    }

    public void subscribe() {
        EventBus.getDefault().register((Object)this);
    }

    @Subscribe
    public void onStareServerConnected(StareServerConnected event) {
        Platform.runLater(() -> {
            this.connectionStatus.setFill((Paint)Color.YELLOW);
            this.btnRun.setDisable(false);
        });
    }

    @Subscribe
    public void onChainStatusChanged(ChainStatusChanged event) {
        FxPlatform.RunFxThread(() -> {
            String progressBarStatus = "Chain executing...";
            String projectNotFoundStatus = "Project not found";
            switch (event.getStatus()) {
                case STARTED: 
                case EXECUTING: {
                    this.runIndicator.finishRunningProcess("Project not found");
                    this.runIndicator.startRunningProcess("Chain executing...");
                    this.btnRun.setDisable(true);
                    break;
                }
                case PAUSED: 
                case STOPPED: {
                    this.runIndicator.finishRunningProcess("Project not found");
                    this.runIndicator.finishRunningProcess("Chain executing...");
                    this.btnRun.setDisable(false);
                    break;
                }
                case UNDEFINED: {
                    this.runIndicator.startRunningProcess("Project not found");
                    this.btnRun.setDisable(true);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)event.getStatus()));
                }
            }
        });
    }

    @Subscribe
    public void onStareServerTimeout(StareServerTimeout event) {
        FxPlatform.RunFxThread(() -> {
            this.connectionStatus.setFill((Paint)Color.RED);
            this.btnRun.setDisable(true);
            this.runIndicator.finishRunningAllProcess();
        });
    }

    @Subscribe
    public void onStareMonitorClosing(StareMonitorClosing event) {
        this.release();
    }

    @Subscribe
    public void onStareMonitorStarted(StareMonitorStarted event) {
        KeyFrame frame2 = new KeyFrame(Duration.ONE, e -> {
            RxHelper.getPropertyObservable((Property)((SplitPane.Divider)this.splitPaneVerticalMainLogs.getDividers().get(0)).positionProperty()).debounce(250L, TimeUnit.MILLISECONDS).subscribe(val -> this.savePreference());
            RxHelper.getPropertyObservable((Property)((SplitPane.Divider)this.splitPaneHorizontalRight.getDividers().get(0)).positionProperty()).debounce(250L, TimeUnit.MILLISECONDS).subscribe(val -> this.savePreference());
            RxHelper.getPropertyObservable((Property)((SplitPane.Divider)this.splitPaneHorizontalLeft.getDividers().get(0)).positionProperty()).debounce(250L, TimeUnit.MILLISECONDS).subscribe(val -> this.savePreference());
        }, new KeyValue[0]);
        Timeline timeLine1 = new Timeline(new KeyFrame[]{frame2});
        double delayAfterStartStareMonitor = 1500.0;
        timeLine1.setDelay(Duration.millis((double)delayAfterStartStareMonitor));
        Platform.runLater(() -> ((Timeline)timeLine1).play());
    }

    private void initializeStatusBar() {
        this.statusBar.setText("Execution status: No-op");
        this.statusBar.getRightItems().add((Object)new Label("comment: No-op"));
    }

    @Subscribe
    public void onProjectExecutionStatusChanged(ProjectExecutionStatusChanged event) {
        ExecutionStatus status = event.getExecutionStatus();
        String information = status.information.isEmpty() ? "" : status.information;
        String messages = status.messages;
        String comments = status.comments.isEmpty() ? "" : status.comments;
        boolean showInformation = AppPreference.getInstance().statusBar.isShowInformation();
        FxPlatform.RunFxThread(() -> {
            Label label = (Label)this.statusBar.getRightItems().get(0);
            this.statusBar.setText(showInformation ? information : messages);
            label.setText(String.format("%s", comments));
        });
    }

    @Deprecated
    public static void showProcessIsRunning(RunningProcess process, String title) {
        FxPlatform.RunFxThread(() -> RootPane.getInstance().awaitBackgroundProcess(process, title));
    }

    @Deprecated
    public static void hideProcessIsRunning(RunningProcess process) {
        FxPlatform.RunFxThread(() -> RootPane.getInstance().endBackgroundProcess(process));
    }

    public static void showProcessIsRunning(String title) {
        FxPlatform.RunFxThread(() -> RootPane.getInstance().awaitBackgroundProcess(title));
    }

    public static void hideProcessIsRunning(String title) {
        FxPlatform.RunFxThread(() -> RootPane.getInstance().endBackgroundProcess(title));
    }

    @Deprecated
    private void awaitBackgroundProcess(RunningProcess process, String title) {
        this.runIndicator.startRunningProcess(title);
    }

    @Deprecated
    private void endBackgroundProcess(RunningProcess process) {
        String stubResolvingName = switch (process) {
            case RunningProcess.SAVING -> "Saving...";
            case RunningProcess.LOADING -> "Loading...";
            case RunningProcess.EXECUTING -> "Execute...";
            case RunningProcess.CONNECTING -> "Connect...";
            case RunningProcess.COPYING -> "Copy..";
            case RunningProcess.PASTING -> "Paste...";
            case RunningProcess.GETTING_CACHE -> "Get cache...";
            default -> "Unknown";
        };
        StareNotification.showWarn((String)("Resolved process name: " + stubResolvingName));
        this.runIndicator.finishRunningProcess(stubResolvingName);
    }

    private void awaitBackgroundProcess(String title) {
        this.runIndicator.startRunningProcess(title);
    }

    private void endBackgroundProcess(String title) {
        this.runIndicator.finishRunningProcess(title);
    }

    @Override
    public void release() {
        this.savePreference();
        if (EventBus.getDefault().isRegistered((Object)this)) {
            EventBus.getDefault().unregister((Object)this);
        }
    }

    public static FxRunIndicator getRunIndicator() {
        return RootPane.getInstance().runIndicator;
    }

    public void initialize(URL url, ResourceBundle resourceBundle) {
        this.restorePreference();
    }
}

