/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.ui.content.container;

import com.siams.cv.monitor.application.UserAction;
import com.siams.cv.monitor.entity.StareNode;
import com.siams.cv.monitor.model.Model;
import com.siams.cv.monitor.model.node.UIBlockModel;
import com.siams.cv.monitor.ui.BoundingBox;
import com.siams.cv.monitor.ui.DefaultNodeDragHandler;
import com.siams.cv.monitor.ui.NodeActionHandler;
import com.siams.cv.monitor.ui.NodeClickHandler;
import com.siams.cv.monitor.ui.NodeDragHandler;
import com.siams.cv.monitor.ui.event.DragInfo;
import com.siams.cv.monitor.ui.factory.Deletable;
import com.siams.cv.monitor.ui.factory.UIBlock;
import com.siams.cv.monitor.ui.factory.UIGroup;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import javafx.geometry.Bounds;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.shape.Rectangle;

public class UIDesktopSelectionGroup
extends UIGroup<StareNode>
implements Deletable,
StareNode {
    public static UUID uuid = UUID.fromString("626d74ef-9dfa-4173-8d70-33c27de4392e");
    private Group parent = null;
    private Rectangle bounding = new Rectangle();
    BoundingBox boundingBox = new BoundingBox();
    private Rectangle background;
    private DragHandler dragHandler;
    private NodeClickHandler clickHandler;

    public UIDesktopSelectionGroup() {
        this.initialize();
    }

    private void initialize() {
        this.initializeBoundingRectangle();
        this.initializeClickHandler();
        this.initializeDragHandler();
    }

    private void initializeBoundingRectangle() {
        this.bounding.setId("f82ac34d-4082-41d3-84a0-6329e383d53c");
        this.bounding.getStyleClass().add((Object)"selection-bounding-rectangle");
    }

    private void initializeClickHandler() {
        this.clickHandler = new ClickHandler();
    }

    private void initializeDragHandler() {
        this.dragHandler = new DragHandler();
    }

    public void setRootGroup(Group parent) {
        this.parent = parent;
        if (parent != null) {
            parent.getChildren().add((Object)this.bounding);
        }
    }

    public void setBackground(Rectangle background) {
        this.background = background;
    }

    public void setObjects(List<StareNode> selected) {
        this.clear();
        if (selected.size() == 1) {
            return;
        }
        this.addObjects(selected);
        this.adjustBoundingRectangle();
    }

    @Override
    public void release() {
        if (this.parent != null) {
            this.parent.getChildren().remove((Object)this.bounding);
        }
        this.dragHandler.release();
        if (this.clickHandler != null) {
            this.clickHandler.release();
        }
    }

    @Override
    public void clear() {
        super.clear();
        this.setVisible(false);
    }

    public UUID getUuid() {
        return uuid;
    }

    @Override
    public Node getNode() {
        return this.parent;
    }

    @Override
    public Model getNodeModel() {
        return null;
    }

    private void adjustBoundingRectangle() {
        double maxY;
        double minY;
        double maxX;
        double minX;
        Bounds backgroundBounds;
        Bounds sceneBounds;
        Node node;
        StareNode stareNode;
        boolean hasObjects;
        boolean bl = hasObjects = this.objects.size() > 0;
        if (!hasObjects) {
            this.setVisible(false);
            return;
        }
        Iterator iterator = this.objects.iterator();
        if (iterator.hasNext()) {
            stareNode = (StareNode)iterator.next();
            node = stareNode.getNode();
            sceneBounds = node.localToScene(node.getBoundsInLocal());
            backgroundBounds = this.background.sceneToLocal(sceneBounds);
            minX = backgroundBounds.getMinX();
            maxX = backgroundBounds.getMaxX();
            minY = backgroundBounds.getMinY();
            maxY = backgroundBounds.getMaxY();
            this.boundingBox.setBox(minX, minY, maxX, maxY);
        }
        while (iterator.hasNext()) {
            stareNode = (StareNode)iterator.next();
            node = stareNode.getNode();
            sceneBounds = node.localToScene(node.getBoundsInLocal());
            backgroundBounds = this.background.sceneToLocal(sceneBounds);
            minX = backgroundBounds.getMinX();
            maxX = backgroundBounds.getMaxX();
            minY = backgroundBounds.getMinY();
            maxY = backgroundBounds.getMaxY();
            this.boundingBox.extendBox(minX, minY, maxX, maxY);
        }
        double size = 10.0;
        this.boundingBox.extend(size);
        this.bounding.setLayoutX(0.0);
        this.bounding.setLayoutY(0.0);
        this.bounding.setTranslateX(0.0);
        this.bounding.setTranslateY(0.0);
        this.bounding.setX(this.boundingBox.x1);
        this.bounding.setY(this.boundingBox.y1);
        this.bounding.setWidth(this.boundingBox.getWidth());
        this.bounding.setHeight(this.boundingBox.getHeight());
        this.setVisible(true);
    }

    private void setVisible(boolean isVisible) {
        this.bounding.setVisible(isVisible);
        this.bounding.setManaged(isVisible);
        this.bounding.toFront();
    }

    private class ClickHandler
    extends NodeClickHandler {
        ClickHandler() {
            super((Node)UIDesktopSelectionGroup.this.bounding, UIDesktopSelectionGroup.this, NodeActionHandler.EventConsumptionMode.DEFAULT);
        }

        @Override
        protected void onClick(MouseEvent event) {
            UserAction.unselectedNodes();
            UIDesktopSelectionGroup.this.clear();
        }

        @Override
        protected void onControlClick(MouseEvent event) {
            super.onControlClick(event);
        }
    }

    private class DragHandler
    extends DefaultNodeDragHandler {
        DragHandler() {
            super((Node)UIDesktopSelectionGroup.this.bounding, UIDesktopSelectionGroup.this, NodeActionHandler.EventConsumptionMode.DEFAULT);
            this.setDragMode(NodeDragHandler.DragMode.LAYOUT);
        }

        @Override
        protected void onDrag(MouseEvent event) {
            super.onDrag(event);
            DragInfo dragInfo = this.getDragInfoLocal();
            UIDesktopSelectionGroup.this.objects.forEach(iid -> {
                Node node = iid.getNode();
                if (UIBlock.class.isAssignableFrom(iid.getClass())) {
                    node.setTranslateX(dragInfo.distanceX);
                    node.setTranslateY(dragInfo.distanceY);
                }
            });
        }

        @Override
        protected void onRelease(MouseEvent event) {
            super.onRelease(event);
            UIDesktopSelectionGroup.this.objects.forEach(stareNode -> {
                if (UIBlock.class.isAssignableFrom(stareNode.getClass())) {
                    Node node = stareNode.getNode();
                    double layoutX = node.getLayoutX() + node.getTranslateX();
                    double layoutY = node.getLayoutY() + node.getTranslateY();
                    UIBlock uiBlock = (UIBlock)stareNode;
                    UIBlockModel uiBlockModel = uiBlock.getNodeModel();
                    uiBlockModel.setLayoutX(layoutX);
                    uiBlockModel.setLayoutY(layoutY);
                    node.setTranslateX(0.0);
                    node.setTranslateY(0.0);
                    node.setLayoutX(layoutX);
                    node.setLayoutY(layoutY);
                }
            });
        }
    }
}

