/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.ui.content.container;

import com.siams.cv.monitor.application.UserAction;
import com.siams.cv.monitor.help.HelpExecutor;
import com.siams.cv.monitor.message.DataProcessModelsLoaded;
import com.siams.cv.monitor.message.StareMonitorClosing;
import com.siams.cv.monitor.model.worker.WorkerStructure;
import com.siams.cv.monitor.model.worker.WorkerType;
import com.siams.cv.monitor.model.worker.WorkerTypeCategory;
import com.siams.cv.monitor.ui.content.container.UILibraryFilter;
import com.siams.cv.monitor.ui.factory.Deletable;
import com.siams.dialogs.DialogManager;
import com.siams.fxml.loader.CustomFXMLLoader;
import com.siams.javafx.PaneHelper;
import com.siams.javafx.utils.FxPlatform;
import com.siams.preferences.UIPreference;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.fxml.FXML;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.web.WebView;
import org.apache.log4j.Logger;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.controlsfx.control.HiddenSidesPane;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;

public final class UILibraryFunctions
extends AnchorPane
implements Deletable,
UIPreference,
UILibraryFilter.FilterChangeListener {
    private static UILibraryFunctions instance;
    private final Logger logger = Logger.getLogger(UILibraryFunctions.class);
    private UILibraryFilter uiLibraryFilter;
    @FXML
    private AnchorPane apLibraryFilterHolder;
    @FXML
    private TreeView<Object> tvLibraryFunctions;
    @FXML
    private WebView wvQuickHelp;
    @FXML
    private HiddenSidesPane spDivider;
    private ObservableList<WorkerType> models = FXCollections.observableArrayList();
    private FilteredList<WorkerType> filteredModels = new FilteredList(this.models);

    public static UILibraryFunctions getInstance() {
        if (instance == null) {
            instance = new UILibraryFunctions();
        }
        return instance;
    }

    private UILibraryFunctions() {
        this.initialize();
    }

    private void initialize() {
        this.initializeRoot();
        this.initializeControls();
        this.subscribe();
    }

    private void initializeRoot() {
        try {
            CustomFXMLLoader.loadElement((Object)this);
            this.wvQuickHelp.setOnMouseClicked(event -> {
                if (event.getClickCount() == 1) {
                    if (this.spDivider.getPinnedSide() == null) {
                        this.spDivider.setPinnedSide(Side.BOTTOM);
                    } else {
                        this.spDivider.setPinnedSide(null);
                    }
                }
            });
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private void initializeControls() {
        this.initializeLibraryFilter();
        this.initializeTreeViewLibraryFunctions();
    }

    private void initializeLibraryFilter() {
        this.uiLibraryFilter = new UILibraryFilter();
        this.uiLibraryFilter.setModelSelectedListener(UILibraryFunctions::scrollToModel);
        this.uiLibraryFilter.setFilterChangeListener(this);
        this.apLibraryFilterHolder.getChildren().add((Object)this.uiLibraryFilter);
        PaneHelper.setAnchorZero((Node)this.uiLibraryFilter);
    }

    private void initializeTreeViewLibraryFunctions() {
        this.tvLibraryFunctions.setShowRoot(false);
        this.tvLibraryFunctions.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
        this.tvLibraryFunctions.setCellFactory(p -> new TreeCellFactory());
        this.tvLibraryFunctions.setOnMouseClicked(event -> {
            WorkerType model;
            TreeItem selected = (TreeItem)this.tvLibraryFunctions.getSelectionModel().getSelectedItem();
            if (selected == null) {
                return;
            }
            try {
                model = (WorkerType)selected.getValue();
            }
            catch (ClassCastException e) {
                model = null;
            }
            if (model != null) {
                if (event.getClickCount() == 1) {
                    this.displayWebViewHelp(model);
                } else if (event.getClickCount() == 2) {
                    UserAction.addWorker(model);
                }
            }
        });
        this.tvLibraryFunctions.addEventHandler(KeyEvent.KEY_RELEASED, e -> {
            boolean isConsumed = true;
            switch (e.getCode()) {
                case Q: {
                    if (!e.isControlDown()) break;
                    TreeItem selected = (TreeItem)this.tvLibraryFunctions.getSelectionModel().getSelectedItem();
                    if (selected == null) {
                        return;
                    }
                    WorkerType model = (WorkerType)selected.getValue();
                    UserAction.showHelpForObject(model);
                    break;
                }
                default: {
                    isConsumed = false;
                }
            }
            if (isConsumed) {
                e.consume();
            }
        });
        this.tvLibraryFunctions.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue != null && newValue.getValue() instanceof WorkerType) {
                this.displayWebViewHelp((WorkerType)newValue.getValue());
            }
        });
    }

    private void subscribe() {
        EventBus.getDefault().register((Object)this);
    }

    public static int scrollToModel(WorkerType model) {
        TreeView<Object> tvLibraryFunctions = UILibraryFunctions.getInstance().tvLibraryFunctions;
        int found = -1;
        MultipleSelectionModel selectionModel = tvLibraryFunctions.getSelectionModel();
        selectionModel.setSelectionMode(SelectionMode.SINGLE);
        UILibraryFunctions.expand(UILibraryFunctions.findTreeItem(tvLibraryFunctions.getRoot(), model.getCategoryPackage()));
        for (int i = 0; i < tvLibraryFunctions.getExpandedItemCount(); ++i) {
            WorkerType itemModel;
            TreeItem item = tvLibraryFunctions.getTreeItem(i);
            if (!(item.getValue() instanceof WorkerType) || !(itemModel = (WorkerType)item.getValue()).getType().equals(model.getType())) continue;
            found = i;
            selectionModel.select(i);
            tvLibraryFunctions.scrollTo(i);
            instance.displayWebViewHelp(itemModel);
            break;
        }
        return found;
    }

    public void resolveTagMismatch(WorkerType model) {
        switch (this.uiLibraryFilter.getSearchMode()) {
            case ANY_OF: {
                LinkedList mismatchedTags = new LinkedList(model.getStructure().getTags());
                String tags = mismatchedTags.toString();
                String template = "These tags did not satisfied tag filter:\n%s\n\nChoose tags to extend the filter:";
                String message = String.format(template, tags.substring(1, tags.length() - 1));
                DialogManager.showMultiplySelector((String)message, (String)"Tag mismatch", mismatchedTags).ifPresent(extraTags -> {
                    this.uiLibraryFilter.addTags((List<String>)extraTags);
                    if (UILibraryFunctions.scrollToModel(model) < 0) {
                        this.logger.error((Object)"resolveTagMismatch() was called, but DataProcessModel still not found.");
                    }
                });
                break;
            }
            case ALL_OF: {
                List mismatchedTags = this.uiLibraryFilter.getSelectedTagNames().stream().filter(tag -> !model.getStructure().getTags().contains(tag)).collect(Collectors.toList());
                String tags = mismatchedTags.toString();
                String template = "Model was not found, because filter contains following tags:\n%s\n\nRemove them from filter?";
                String message = String.format(template, tags.substring(1, tags.length() - 1));
                DialogManager.showQuery((String)message, (String)"Tag mismatch").ifPresent(buttonType -> {
                    this.uiLibraryFilter.clearTags(mismatchedTags);
                    if (UILibraryFunctions.scrollToModel(model) < 0) {
                        this.logger.error((Object)"resolveTagMismatch() was called, but DataProcessModel still not found.");
                    }
                });
                break;
            }
        }
    }

    public void clearTagFilter() {
        this.uiLibraryFilter.clearSearchMode();
    }

    @Subscribe
    public void onDataProcessModelsLoaded(DataProcessModelsLoaded event) {
        long t0 = System.currentTimeMillis();
        List<WorkerType> models = event.getModels();
        this.models.clear();
        this.models.addAll(models);
        this.updateTree(new LinkedList<WorkerType>(models));
        long t1 = System.currentTimeMillis();
        Platform.runLater(() -> {
            long t2 = System.currentTimeMillis();
            this.uiLibraryFilter.setDataProcessModels(models);
            long t3 = System.currentTimeMillis();
            this.logger.info((Object)String.format("[Profiler] UILibraryFunctions.onDataProcessModelsLoaded waiting run later %d ms", t2 - t1));
            this.logger.info((Object)String.format("[Profiler] UILibraryFunctions.onDataProcessModelsLoaded setDataProcess %d ms", t3 - t2));
            this.logger.info((Object)String.format("[Profiler] UILibraryFunctions.onDataProcessModelsLoaded %d ms", System.currentTimeMillis() - t0));
        });
    }

    @Subscribe
    public void onStareMonitorClosing(StareMonitorClosing event) {
        this.release();
    }

    public void setFocus(UserAction.Focus focus) {
        switch (focus) {
            case REGISTERED_COMPONENT_FILTER: {
                this.uiLibraryFilter.setFocus(focus);
            }
        }
    }

    @Override
    public void onFilterChange(UILibraryFilter.SearchMode searchMode, List<String> selectedTagNames) {
        this.filteredModels.setPredicate(model -> {
            if (!selectedTagNames.isEmpty()) {
                Set modelTags = model.getStructure().getTags();
                if (searchMode == UILibraryFilter.SearchMode.ANY_OF) {
                    boolean noneMatch = selectedTagNames.stream().noneMatch(modelTags::contains);
                    if (noneMatch) {
                        return false;
                    }
                } else if (searchMode == UILibraryFilter.SearchMode.ALL_OF && !modelTags.containsAll(selectedTagNames)) {
                    return false;
                }
            }
            return true;
        });
        this.updateTree((List<WorkerType>)this.filteredModels);
    }

    public void savePreference() {
        this.uiLibraryFilter.savePreference();
    }

    public void restorePreference() {
        Platform.runLater(() -> {});
        this.uiLibraryFilter.restorePreference();
    }

    @Override
    public void release() {
        this.savePreference();
        if (EventBus.getDefault().isRegistered((Object)this)) {
            EventBus.getDefault().unregister((Object)this);
        }
    }

    private void buildTree(List<WorkerType> models, TreeItem<Object> root) {
        this.tvLibraryFunctions.setRoot(root);
        models.forEach(model -> this.findTreeItem(this.tvLibraryFunctions, model.getCategoryPackage()).ifPresent(treeItem -> treeItem.getChildren().add((Object)new TreeItem(model))));
    }

    private Optional<TreeItem> findTreeItem(TreeView treeView, String categoryCanonicalName) {
        return Optional.ofNullable(UILibraryFunctions.findTreeItem(treeView.getRoot(), categoryCanonicalName));
    }

    private static TreeItem findTreeItem(TreeItem parent, String categoryCanonicalName) {
        ObservableList list = parent.getChildren();
        TreeItem found = null;
        for (TreeItem item : list) {
            WorkerTypeCategory category;
            Object itemObject = item.getValue();
            if (WorkerTypeCategory.class.isAssignableFrom(itemObject.getClass()) && (category = (WorkerTypeCategory)itemObject).getCanonicalName().equals(categoryCanonicalName)) {
                found = item;
                break;
            }
            if (found != null) continue;
            found = UILibraryFunctions.findTreeItem(item, categoryCanonicalName);
        }
        return found;
    }

    private void updateTree(List<WorkerType> models) {
        long t0 = System.currentTimeMillis();
        TreeItem root = new TreeItem();
        root.setExpanded(false);
        ArrayList<WorkerType> sortedModels = new ArrayList<WorkerType>(models);
        sortedModels.sort(Comparator.comparing(o -> o.getStructure().getName()));
        sortedModels.sort((c1, c2) -> {
            String s1 = c1.getStructure().getCategoryPackage("\u0000");
            String s2 = c2.getStructure().getCategoryPackage("\u0000");
            int dynamicCategoryCompare = Boolean.compare(!UILibraryFunctions.isDynamicCatetory(s1), !UILibraryFunctions.isDynamicCatetory(s2));
            return dynamicCategoryCompare != 0 ? dynamicCategoryCompare : s1.compareTo(s2);
        });
        for (WorkerType model : sortedModels) {
            TreeItem parent = root;
            for (WorkerTypeCategory category : model.getStructure().getCategories()) {
                TreeItem item;
                Optional<TreeItem> found = parent.getChildren().stream().filter(node -> node.getValue().equals(category)).findFirst();
                if (found.isEmpty()) {
                    item = new TreeItem((Object)category);
                    parent.getChildren().add((Object)item);
                } else {
                    item = found.get();
                }
                parent = item;
            }
        }
        long t1 = System.currentTimeMillis();
        FxPlatform.RunFxThread(() -> {
            long t2 = System.currentTimeMillis();
            this.buildTree(sortedModels, (TreeItem<Object>)root);
            long t3 = System.currentTimeMillis();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)String.format("[Profiler] UILibraryFunctions.updateTree create root %d ms", t1 - t0));
                this.logger.debug((Object)String.format("[Profiler] UILibraryFunctions.updateTree waiting run later %d ms", t2 - t1));
                this.logger.debug((Object)String.format("[Profiler] UILibraryFunctions.updateTree buildTree %d ms", t3 - t2));
                this.logger.debug((Object)String.format("[Profiler] UILibraryFunctions.updateTree %d ms", System.currentTimeMillis() - t0));
            }
        });
    }

    private static boolean isDynamicCatetory(String catetory) {
        return catetory.startsWith("$") && !catetory.startsWith("$$");
    }

    private static void expand(TreeItem item) {
        if (item != null) {
            item.setExpanded(true);
            UILibraryFunctions.expand(item.getParent());
        }
    }

    private void displayWebViewHelp(WorkerType model) {
        HelpExecutor helpExecutor = new HelpExecutor();
        helpExecutor.setDataProcessModel(model);
        VelocityContext context = new VelocityContext();
        context.put("executor", (Object)helpExecutor);
        Template template = Velocity.getTemplate((String)"com/siams/cv/monitor/ui/content/block/block-description.html");
        StringWriter stringWriter = new StringWriter();
        template.merge((Context)context, (Writer)stringWriter);
        String html = stringWriter.toString();
        this.wvQuickHelp.getEngine().loadContent(html);
    }

    private final class TreeCellFactory
    extends TreeCell<Object> {
        private ContextMenu menu = new ContextMenu();

        TreeCellFactory() {
            MenuItem menuItemQuickHelp = new MenuItem("Quick help (CTRL + Q)");
            menuItemQuickHelp.setOnAction(event -> {
                WorkerType model = (WorkerType)((TreeItem)UILibraryFunctions.this.tvLibraryFunctions.getSelectionModel().getSelectedItem()).getValue();
                UserAction.showHelpForObject(model);
            });
            MenuItem menuItemAddDataProcess = new MenuItem("Add");
            menuItemAddDataProcess.setOnAction(event -> {
                WorkerType model = (WorkerType)((TreeItem)UILibraryFunctions.this.tvLibraryFunctions.getSelectionModel().getSelectedItem()).getValue();
                UserAction.addWorker(model);
            });
            MenuItem menuItemFindUsages = new MenuItem("Find examples");
            menuItemFindUsages.setOnAction(event -> {
                WorkerType model = (WorkerType)((TreeItem)UILibraryFunctions.this.tvLibraryFunctions.getSelectionModel().getSelectedItem()).getValue();
                UserAction.findUsages(model);
            });
            MenuItem menuItemShowSpecification = new MenuItem("Show JSON specification");
            menuItemShowSpecification.setOnAction(event -> {
                WorkerType model = (WorkerType)((TreeItem)UILibraryFunctions.this.tvLibraryFunctions.getSelectionModel().getSelectedItem()).getValue();
                UserAction.showSpecification(model);
            });
            this.menu.getItems().addAll((Object[])new MenuItem[]{menuItemQuickHelp, menuItemAddDataProcess, menuItemFindUsages, menuItemShowSpecification});
        }

        protected void updateItem(Object item, boolean empty) {
            String text;
            super.updateItem(item, empty);
            if (empty) {
                text = null;
            } else if (item instanceof WorkerTypeCategory) {
                text = ((WorkerTypeCategory)item).getName();
            } else if (item instanceof WorkerType) {
                WorkerType model = (WorkerType)item;
                text = model.getStructure().getName();
                this.setContextMenu(this.menu);
            } else {
                text = "Unknown";
            }
            this.setText(WorkerStructure.replaceFunctionName(text));
        }
    }
}

