/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.ui.content.windows.project.settings;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Objects;
import org.apache.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class ProjectSettings {
    private Logger logger = Logger.getLogger(ProjectSettings.class);
    private ExecutionStrategy executionStrategy = ExecutionStrategy.FORWARD;
    private int gridSize = 20;
    private boolean gridAdjust = true;
    private boolean instanceMode = true;
    private boolean cache = false;
    private boolean preview = false;
    private String executorText = "";
    private Executor executor = new Executor();

    public String getId() {
        return this.executor.id;
    }

    public void setId(String uuid) {
        this.executor.id = uuid;
        this.updateExecutorText();
    }

    public String getName() {
        return this.executor.name;
    }

    public void setName(String name) {
        this.executor.name = name;
        this.updateExecutorText();
    }

    public String getCategory() {
        return this.executor.category;
    }

    public void setCategory(String category) {
        this.executor.category = category;
        this.updateExecutorText();
    }

    public boolean isMultiThreading() {
        return this.executor.options.execution.multithreading;
    }

    public void setMultiThreading(boolean multiThreading) {
        this.executor.options.execution.multithreading = multiThreading;
        this.updateExecutorText();
    }

    public boolean isAlwaysExecuteAll() {
        return this.executor.options.execution.all;
    }

    public void setAlwaysExecuteAll(boolean alwaysExecuteAll) {
        this.executor.options.execution.all = alwaysExecuteAll;
        this.updateExecutorText();
    }

    public boolean isIgnoreExceptions() {
        return this.executor.options.execution.ignoreExceptions;
    }

    public void setIgnoreExceptions(boolean ignoreExceptions) {
        this.executor.options.execution.ignoreExceptions = ignoreExceptions;
        this.updateExecutorText();
    }

    public String getDescription() {
        return this.executor.description;
    }

    public void setDescription(String description) {
        this.executor.description = description;
        this.updateExecutorText();
    }

    private void removeIsBlank(JSONObject jsonObject, String key, String value) throws JSONException {
        if (jsonObject.has(key)) {
            jsonObject.remove(key);
        }
        if (!value.isBlank()) {
            jsonObject.put(key, (Object)value);
        }
    }

    private void updateExecutorText() {
        try {
            JSONObject jsonObject = new JSONObject(this.executorText);
            jsonObject.put("id", (Object)this.getId());
            this.removeIsBlank(jsonObject, "name", this.getName());
            this.removeIsBlank(jsonObject, "category", this.getCategory());
            this.removeIsBlank(jsonObject, "description", this.getDescription());
            jsonObject.put("options", (Object)new JSONObject());
            jsonObject.getJSONObject("options").put("execution", (Object)new JSONObject());
            JSONObject execution = jsonObject.getJSONObject("options").getJSONObject("execution");
            execution.put("all", this.isAlwaysExecuteAll());
            execution.put("multithreading", this.isMultiThreading());
            execution.put("ignore_exceptions", this.isIgnoreExceptions());
            this.executorText = jsonObject.toString(4);
        }
        catch (Throwable t) {
            this.logger.error((Object)"Failed update executor text", t);
        }
    }

    public String getExecutorText() {
        return this.executorText;
    }

    public void setExecutorText(String executorText) {
        this.executorText = executorText;
    }

    public ExecutionStrategy getExecutionStrategy() {
        return this.executionStrategy;
    }

    public void setExecutionStrategy(ExecutionStrategy executionStrategy) {
        this.executionStrategy = executionStrategy;
    }

    public int getGridSize() {
        return this.gridSize;
    }

    public void setGridSize(int gridSize) {
        this.gridSize = gridSize;
    }

    public boolean getGridAdjust() {
        return this.gridAdjust;
    }

    public void setGridAdjust(boolean gridAdjust) {
        this.gridAdjust = gridAdjust;
    }

    public boolean getInstanceMode() {
        return this.instanceMode;
    }

    public void setInstanceMode(boolean instanceMode) {
        this.instanceMode = instanceMode;
    }

    public boolean getCache() {
        return this.cache;
    }

    public void setCache(boolean cache) {
        this.cache = cache;
    }

    public boolean getPreview() {
        return this.preview;
    }

    public void setPreview(boolean preview) {
        this.preview = preview;
    }

    public static ProjectSettings from(String json) throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        Executor executor = (Executor)mapper.readValue(json, Executor.class);
        ProjectSettings projectSettings = new ProjectSettings();
        projectSettings.executor = executor;
        projectSettings.setExecutorText(json);
        return projectSettings;
    }

    public static enum ExecutionStrategy {
        FORWARD("graph", "Forward"),
        REVERSE("rgraph", "Reverse"),
        OUTPUT_BROADCAST("output_broadcast", "Output Broadcast");

        final String id;
        final String caption;

        private ExecutionStrategy(String id, String caption) {
            this.id = id;
            this.caption = caption;
        }

        public static ExecutionStrategy from(String value) {
            Objects.requireNonNull(value, "value required");
            for (ExecutionStrategy strategy : ExecutionStrategy.values()) {
                if (!strategy.id.equalsIgnoreCase(value)) continue;
                return strategy;
            }
            throw new IllegalArgumentException(String.format("Unsupported execution strategy value: %s", value));
        }

        public String GetId() {
            return this.id;
        }

        public String GetCaption() {
            return this.caption;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    private static class Executor {
        public String id = "";
        public Options options = new Options();
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        public String name = "";
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        public String category = "";
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        public String description = "";

        @JsonCreator
        Executor() {
        }

        String toJson() throws IOException {
            return new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)this);
        }

        static Executor fromJson(String text) throws JsonProcessingException {
            ObjectMapper mapper = new ObjectMapper();
            return (Executor)mapper.readValue(text, Executor.class);
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    private static class Options {
        public Execution execution = new Execution();

        private Options() {
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    private static class Execution {
        public boolean all = false;
        public boolean multithreading = false;
        @JsonProperty(value="ignore_exceptions")
        public boolean ignoreExceptions = false;

        private Execution() {
        }
    }
}

