/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.ui.content.windows.project.settings;

import com.siams.cv.monitor.application.App;
import com.siams.cv.monitor.ui.content.windows.project.settings.ProjectSettings;
import com.siams.cv.monitor.ui.factory.Deletable;
import com.siams.fx.components.jsoneditor.JsonEditor;
import com.siams.fxml.loader.CustomFXMLLoader;
import com.siams.javafx.utils.property.PathProperty;
import com.siams.javafx.utils.property.converter.Converter;
import com.siams.javafx.utils.property.converter.IntegerToString;
import com.siams.notifications.StareNotification;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.UUID;
import java.util.function.Consumer;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.layout.AnchorPane;
import javafx.util.StringConverter;
import org.apache.log4j.Logger;

public class UIProjectSettings
implements Deletable {
    final Logger logger = Logger.getLogger(UIProjectSettings.class);
    Consumer<ButtonBar.ButtonData> onCloseHandler = null;
    Controller contentRoot = new Controller(this);
    ProjectSettings data;
    PathProperty<String, String> ptyUuid;
    PathProperty<String, String> ptyName;
    PathProperty<String, String> ptyCategory;
    PathProperty<Boolean, Boolean> ptyMultiThreading;
    PathProperty<Boolean, Boolean> ptyAlwaysExecuteAll;
    PathProperty<Boolean, Boolean> ptyIgnoreExceptions;
    PathProperty<String, String> ptyDescription;
    PathProperty<ProjectSettings.ExecutionStrategy, ProjectSettings.ExecutionStrategy> ptyExecutionStrategy;
    PathProperty<Integer, String> ptyGridSize;
    PathProperty<Boolean, Boolean> ptyGridAdjust;
    PathProperty<String, String> ptyOptions;

    public UIProjectSettings(ProjectSettings projectSettings) {
        this.data = projectSettings;
        this.initialize();
    }

    private void initializeDefaultRoot() {
        try {
            this.contentRoot = this.createRootNode();
            CustomFXMLLoader.loadElement((Object)((Object)this.contentRoot), this.getClass());
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    protected void initialize() {
        this.initializeDefaultRoot();
        this.initializeControls();
        this.contentRoot.labelExecutionStrategy.setVisible(App.EXPERIMENTAL_FEATURES);
        this.contentRoot.cbExecutionStrategy.setVisible(App.EXPERIMENTAL_FEATURES);
    }

    private void initializeControls() {
        this.ptyUuid = new PathProperty((Object)this.data, "id", String.class);
        this.contentRoot.tfUuid.textProperty().bindBidirectional(this.ptyUuid);
        this.ptyName = new PathProperty((Object)this.data, "name", String.class);
        this.contentRoot.tfName.textProperty().bindBidirectional(this.ptyName);
        this.ptyCategory = new PathProperty((Object)this.data, "category", String.class);
        this.contentRoot.tfCategory.textProperty().bindBidirectional(this.ptyCategory);
        this.ptyMultiThreading = new PathProperty((Object)this.data, "multiThreading", Boolean.class);
        this.contentRoot.cbMultiThreading.selectedProperty().bindBidirectional(this.ptyMultiThreading);
        this.ptyAlwaysExecuteAll = new PathProperty((Object)this.data, "alwaysExecuteAll", Boolean.class);
        this.contentRoot.cbAlwaysExecuteAll.selectedProperty().bindBidirectional(this.ptyAlwaysExecuteAll);
        this.ptyIgnoreExceptions = new PathProperty((Object)this.data, "ignoreExceptions", Boolean.class);
        this.contentRoot.cbIgnoreExceptions.selectedProperty().bindBidirectional(this.ptyIgnoreExceptions);
        this.ptyDescription = new PathProperty((Object)this.data, "description", String.class);
        this.contentRoot.taDescription.textProperty().bindBidirectional(this.ptyDescription);
        this.contentRoot.btnGenerateUuid.setOnAction(e -> this.contentRoot.tfUuid.setText(UUID.randomUUID().toString()));
        this.ptyExecutionStrategy = new PathProperty((Object)this.data, "executionStrategy", ProjectSettings.ExecutionStrategy.class);
        this.contentRoot.cbExecutionStrategy.valueProperty().bindBidirectional(this.ptyExecutionStrategy);
        this.contentRoot.cbExecutionStrategy.setConverter((StringConverter)new StringConverter<ProjectSettings.ExecutionStrategy>(this){

            public String toString(ProjectSettings.ExecutionStrategy object) {
                return object.GetCaption();
            }

            public ProjectSettings.ExecutionStrategy fromString(String string) {
                return ProjectSettings.ExecutionStrategy.from(string);
            }
        });
        this.contentRoot.cbExecutionStrategy.getItems().addAll((Object[])ProjectSettings.ExecutionStrategy.values());
        this.ptyGridSize = new PathProperty((Object)this.data, "gridSize", (Converter)new IntegerToString());
        this.contentRoot.tfGridSize.textProperty().bindBidirectional(this.ptyGridSize);
        this.ptyGridAdjust = new PathProperty((Object)this.data, "gridAdjust", Boolean.class);
        this.contentRoot.cbGridAdjust.selectedProperty().bindBidirectional(this.ptyGridAdjust);
        this.contentRoot.btnDetailedOptions.setOnAction(event -> {
            try {
                this.showAndWaitDetailedOptions();
            }
            catch (Throwable t) {
                this.logger.error((Object)"Failed edit detailed options", t);
            }
        });
    }

    private boolean isRequiredFieldsFilled() {
        boolean allowEmptyName = true;
        boolean allowEmptyCategory = true;
        if (this.contentRoot.tfUuid.getText().isEmpty()) {
            StareNotification.showWarn((String)"ID field required");
            return false;
        }
        if (!this.contentRoot.tfCategory.getText().isEmpty() && this.contentRoot.tfCategory.getText().strip().isEmpty()) {
            StareNotification.showWarn((String)"Category contains only space symbols not allowed");
            return false;
        }
        if (!this.contentRoot.tfName.getText().isEmpty() && this.contentRoot.tfName.getText().strip().isEmpty()) {
            StareNotification.showWarn((String)"Name contains only space symbols not allowed");
            return false;
        }
        return true;
    }

    private Controller createRootNode() {
        return new Controller(this);
    }

    @Override
    public void release() {
    }

    private void showAndWaitDetailedOptions() throws IOException, URISyntaxException {
        JsonEditor.showAsDialog((String)this.data.getExecutorText(), (int)640, (int)480, (String)"Detailed options").ifPresent(text -> {
            try {
                ProjectSettings newProjectSettings = ProjectSettings.from(text);
                this.data.setId(newProjectSettings.getId());
                this.data.setAlwaysExecuteAll(newProjectSettings.isAlwaysExecuteAll());
                this.data.setIgnoreExceptions(newProjectSettings.isIgnoreExceptions());
                this.data.setMultiThreading(newProjectSettings.isMultiThreading());
                this.data.setName(newProjectSettings.getName());
                this.data.setCategory(newProjectSettings.getCategory());
                this.data.setDescription(newProjectSettings.getDescription());
                this.data.setExecutorText((String)text);
                this.initializeControls();
            }
            catch (Throwable t) {
                this.logger.error((Object)"Failed update detailed options", t);
                StareNotification.showWarn((String)"Failed update detailed options");
            }
        });
    }

    public void showAndWait() {
        DialogPane pane = new DialogPane();
        pane.setContent((Node)this.contentRoot);
        pane.getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        pane.setMinSize(800.0, 600.0);
        Dialog dialog = new Dialog();
        dialog.setTitle("Customize chain");
        dialog.setDialogPane(pane);
        dialog.setResultConverter(pressed -> {
            ButtonBar.ButtonData button;
            ButtonBar.ButtonData buttonData = button = pressed == null ? null : pressed.getButtonData();
            if (this.onCloseHandler != null) {
                this.onCloseHandler.accept(button);
            }
            return null;
        });
        dialog.resizableProperty().setValue(Boolean.valueOf(true));
        dialog.showAndWait();
    }

    public void setCloseHandler(Consumer<ButtonBar.ButtonData> onCloseHandler) {
        this.onCloseHandler = onCloseHandler;
    }

    class Controller
    extends AnchorPane {
        @FXML
        TextField tfUuid;
        @FXML
        TextField tfName;
        @FXML
        TextField tfCategory;
        @FXML
        CheckBox cbMultiThreading;
        @FXML
        CheckBox cbAlwaysExecuteAll;
        @FXML
        CheckBox cbIgnoreExceptions;
        @FXML
        Button btnGenerateUuid;
        @FXML
        TextArea taDescription;
        @FXML
        Label labelExecutionStrategy;
        @FXML
        ComboBox<ProjectSettings.ExecutionStrategy> cbExecutionStrategy;
        @FXML
        TextField tfGridSize;
        @FXML
        CheckBox cbGridAdjust;
        @FXML
        Button btnDetailedOptions;

        Controller(UIProjectSettings this$0) {
        }
    }
}

