/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.ui.factory;

import com.siams.cv.monitor.application.App;
import com.siams.cv.monitor.ui.factory.Deletable;
import com.siams.cv.monitor.ui.factory.UIPort;
import java.util.List;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;

public class AlternativePort
implements Deletable {
    private Node node;
    private List<UIPort> ports;
    private ChangeListener<Boolean> portVisibilityListener = new ChangeListener<Boolean>(){

        public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
            AlternativePort.this.ports.stream().map(uiPort -> {
                int n;
                if (!uiPort.isVisible()) {
                    App.getInstance();
                    if (App.findConnections(uiPort).size() > 0) {
                        n = 1;
                        return n;
                    }
                }
                n = 0;
                return n;
            }).reduce(Integer::sum).ifPresent(count -> {
                boolean isVisible = count != 0;
                AlternativePort.this.node.setVisible(isVisible);
                AlternativePort.this.node.setManaged(isVisible);
            });
        }
    };

    public AlternativePort(Node node, List<UIPort> ports) {
        this.node = node;
        this.ports = ports;
        this.ports.forEach(port -> port.visibleProperty().addListener(this.portVisibilityListener));
    }

    @Override
    public void release() {
        this.ports.forEach(port -> port.visibleProperty().removeListener(this.portVisibilityListener));
    }
}

