/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.ui.factory;

import com.siams.cv.monitor.entity.StareNode;
import com.siams.cv.monitor.model.PortType;
import com.siams.cv.monitor.ui.content.container.Desktop;
import com.siams.cv.monitor.ui.factory.UIPort;
import com.siams.javafx.utils.FxPlatform;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.shape.CubicCurve;

public abstract class Connection
extends CubicCurve
implements StareNode {
    protected StareNode srcAnchor;
    protected StareNode destAnchor;
    protected boolean isDetached = false;

    Connection() {
    }

    protected void initialize() {
        this.initializeStyle();
        this.initializeAnchors();
    }

    protected void initializeStyle() {
        this.getStyleClass().add((Object)"ui-link");
        this.setDetached(false);
    }

    protected abstract void initializeAnchors();

    public StareNode getSrcAnchor() {
        return this.srcAnchor;
    }

    public Node getAnchorNode(PortType portType) {
        switch (portType) {
            case INPUT: 
            case INPUT_CONTROL: {
                return this.getSrcAnchor().getNode();
            }
            case OUTPUT: 
            case OUTPUT_CONTROL: {
                return this.getDestAnchor().getNode();
            }
        }
        throw new RuntimeException("Unsupported port type");
    }

    public void setSrcAnchor(StareNode srcAnchor) {
        if (srcAnchor != null) {
            this.srcAnchor = srcAnchor;
        }
    }

    public StareNode getDestAnchor() {
        return this.destAnchor;
    }

    public void setDestAnchor(StareNode destAnchor) {
        this.destAnchor = destAnchor;
    }

    public boolean isDetached() {
        return this.isDetached;
    }

    public void setDetached(boolean detached) {
        this.isDetached = detached;
        FxPlatform.RunFxThread(() -> {
            this.getStyleClass().removeAll((Object[])new String[]{"detached"});
            if (detached) {
                this.getStyleClass().add((Object)"detached");
            }
        });
    }

    public void render() {
        FxPlatform.RunFxThread(() -> {
            StareNode srcAnchor = this.getSrcAnchor();
            StareNode destAnchor = this.getDestAnchor();
            if (srcAnchor != null && destAnchor != null) {
                Node destNode;
                Node srcNode = srcAnchor instanceof UIPort ? ((UIPort)srcAnchor).getConnectionAnchor() : srcAnchor.getNode();
                Node node = destNode = destAnchor instanceof UIPort ? ((UIPort)destAnchor).getConnectionAnchor() : destAnchor.getNode();
                if (srcNode != null && destNode != null) {
                    Desktop desktop = Desktop.getInstance();
                    Point2D p1 = desktop.nodeToGroup(srcNode, Desktop.ConvertStrategy.RIGHT);
                    Point2D p2 = desktop.nodeToGroup(destNode, Desktop.ConvertStrategy.LEFT);
                    Connection.setUpLink(this, p1, p2);
                }
            }
        });
    }

    public static void setUpLink(CubicCurve link, Point2D startPoint, Point2D endPoint) {
        link.setStartX(startPoint.getX());
        link.setStartY(startPoint.getY());
        double distance = Math.max(0.2 * startPoint.distance(endPoint), 50.0);
        link.setControlX1(startPoint.getX() + distance);
        link.setControlY1(startPoint.getY());
        link.setControlX2(endPoint.getX() - distance);
        link.setControlY2(endPoint.getY());
        link.setEndX(endPoint.getX());
        link.setEndY(endPoint.getY());
    }
}

