/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.ui.factory;

import com.siams.cv.monitor.ui.factory.Deletable;
import com.siams.javafx.utils.FxPlatform;
import io.reactivex.disposables.Disposable;
import io.reactivex.subjects.PublishSubject;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javafx.beans.value.ChangeListener;
import javafx.geometry.Bounds;
import javafx.scene.Node;

public class NodeChangePositionListener
implements Deletable {
    protected Runnable callback;
    protected Node node;
    protected PublishSubject<Class<Void>> listenerSubject = PublishSubject.create();
    private final Disposable rxDisposer;
    private final ChangeListener<Bounds> layoutBoundsListener = (ob, o, n) -> this.callback.run();
    private final ChangeListener<Number> layoutXListener = (ob, o, n) -> this.callback.run();
    private final ChangeListener<Number> layoutYListener = (ob, o, n) -> this.callback.run();
    private final ChangeListener<Number> translateXListener = (ob, o, n) -> this.callback.run();
    private final ChangeListener<Number> translateYListener = (ob, o, n) -> this.callback.run();

    NodeChangePositionListener(Node node, Runnable callback) {
        Objects.requireNonNull(node, "Node required");
        this.callback = callback;
        this.node = node;
        this.rxDisposer = this.listenerSubject.debounce(250L, TimeUnit.MILLISECONDS).subscribe(v -> FxPlatform.RunFxThread((Runnable)callback));
        node.layoutBoundsProperty().addListener(this.layoutBoundsListener);
        node.layoutXProperty().addListener(this.layoutXListener);
        node.layoutYProperty().addListener(this.layoutYListener);
        node.translateXProperty().addListener(this.translateXListener);
        node.translateYProperty().addListener(this.translateYListener);
    }

    @Override
    public void release() {
        this.node.layoutBoundsProperty().removeListener(this.layoutBoundsListener);
        this.node.layoutXProperty().removeListener(this.layoutXListener);
        this.node.layoutYProperty().removeListener(this.layoutYListener);
        this.node.translateXProperty().removeListener(this.translateXListener);
        this.node.translateYProperty().removeListener(this.translateYListener);
        this.rxDisposer.dispose();
    }
}

