/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.ui.factory;

import com.siams.cv.monitor.application.App;
import com.siams.cv.monitor.application.UserAction;
import com.siams.cv.monitor.entity.StareNode;
import com.siams.cv.monitor.model.node.SmartLinkModel;
import com.siams.cv.monitor.model.storage.NodeStorage;
import com.siams.cv.monitor.ui.DefaultNodeClickHandler;
import com.siams.cv.monitor.ui.factory.Connection;
import com.siams.cv.monitor.ui.factory.Deletable;
import com.siams.cv.monitor.ui.factory.UIPort;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import javafx.event.Event;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import org.greenrobot.eventbus.EventBus;

public class SmartLink
extends Connection
implements Deletable {
    private SmartLinkModel model;

    SmartLink(SmartLinkModel model) {
        Objects.requireNonNull(model, "Valid model required");
        this.model = model;
        this.initialize();
    }

    @Override
    protected void initialize() {
        this.initializeStyle();
        this.initializeAnchors();
        this.initializeMouseEvents();
        this.subscribe();
    }

    @Override
    protected void initializeStyle() {
        super.initializeStyle();
        this.getStyleClass().add((Object)"smart");
    }

    @Override
    protected void initializeAnchors() {
    }

    private void initializeMouseEvents() {
        this.setOnMouseDragged(Event::consume);
    }

    private void subscribe() {
        EventBus.getDefault().register((Object)this);
    }

    public UUID getUuid() {
        return this.model.getUuid();
    }

    @Override
    public Node getNode() {
        return this;
    }

    public SmartLinkModel getNodeModel() {
        return this.model;
    }

    public List<UUID> getConnectedLinks() {
        return this.model.getConnectedLinksUuids();
    }

    public CompletableFuture<SmartLink> connect(UIPort leftSrcPort, UIPort rightDestPort) {
        CompletableFuture<SmartLink> futureResult = new CompletableFuture<SmartLink>();
        futureResult.completeExceptionally(new Throwable("Not implemented yet"));
        return futureResult;
    }

    @Override
    public void release() {
        if (EventBus.getDefault().isRegistered((Object)this)) {
            EventBus.getDefault().unregister((Object)this);
        }
    }

    @Override
    public StareNode getSrcAnchor() {
        if (this.srcAnchor == null) {
            this.srcAnchor = (StareNode)NodeStorage.getInstance().findFirst(this.model.getSrcPortUuid()).orElseThrow(() -> new IllegalArgumentException("Src port not found."));
        }
        return this.srcAnchor;
    }

    @Override
    public StareNode getDestAnchor() {
        if (this.destAnchor == null) {
            this.destAnchor = (StareNode)NodeStorage.getInstance().findFirst(this.model.getDestPortUuid()).orElseThrow(() -> new IllegalArgumentException("Dest port not found."));
        }
        return this.destAnchor;
    }

    private class SmartLinkClickHandler
    extends DefaultNodeClickHandler {
        SmartLinkClickHandler(Node eventConsumer, StareNode eventTarget) {
            super(eventConsumer, eventTarget);
        }

        @Override
        protected void onClick(MouseEvent event) {
            super.onClick(event);
            if (!event.isControlDown()) {
                UserAction.introspectObject(SmartLink.this);
            }
            App.getInstance().selectOneNode(SmartLink.this);
        }
    }
}

