/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.ui.factory;

import com.siams.cv.monitor.application.App;
import com.siams.cv.monitor.application.UserAction;
import com.siams.cv.monitor.entity.StareNode;
import com.siams.cv.monitor.message.BlockPreviewReceived;
import com.siams.cv.monitor.message.ChainStatusChanged;
import com.siams.cv.monitor.message.NodeModelChanged;
import com.siams.cv.monitor.message.NodeSelected;
import com.siams.cv.monitor.message.ObjectPropertySet;
import com.siams.cv.monitor.message.ObjectStatusChanged;
import com.siams.cv.monitor.message.StareChainConfigLoaded;
import com.siams.cv.monitor.message.StareMonitorClosing;
import com.siams.cv.monitor.message.StatisticResultReady;
import com.siams.cv.monitor.model.IIdentifiable;
import com.siams.cv.monitor.model.Model;
import com.siams.cv.monitor.model.node.UIBlockModel;
import com.siams.cv.monitor.model.node.UIPortModel;
import com.siams.cv.monitor.model.statistic.Statistic;
import com.siams.cv.monitor.model.storage.NodeStorage;
import com.siams.cv.monitor.model.storage.ViewerModelStorage;
import com.siams.cv.monitor.model.viewer.BlockViewerModel;
import com.siams.cv.monitor.model.viewer.ChartViewerModel;
import com.siams.cv.monitor.model.viewer.ImageBorderViewerModel;
import com.siams.cv.monitor.model.viewer.ImageMaskViewerModel;
import com.siams.cv.monitor.model.viewer.ImageViewerModel;
import com.siams.cv.monitor.model.viewer.PlainTextViewerModel;
import com.siams.cv.monitor.model.viewer.SphViewerModel;
import com.siams.cv.monitor.model.viewer.TableViewerModel;
import com.siams.cv.monitor.model.viewer.TriangulationViewerModel;
import com.siams.cv.monitor.model.viewer.ViewerKind;
import com.siams.cv.monitor.model.viewer.ViewerModel;
import com.siams.cv.monitor.model.viewer.VoxelViewerModel;
import com.siams.cv.monitor.transport.BlockBasedDataSource;
import com.siams.cv.monitor.transport.grpc.observer.stream.SImage;
import com.siams.cv.monitor.ui.DefaultNodeClickHandler;
import com.siams.cv.monitor.ui.DefaultNodeDragHandler;
import com.siams.cv.monitor.ui.NodeClickHandler;
import com.siams.cv.monitor.ui.NodeDragHandler;
import com.siams.cv.monitor.ui.content.container.ViewerContainer;
import com.siams.cv.monitor.ui.factory.Block;
import com.siams.cv.monitor.ui.factory.DataTooltip;
import com.siams.cv.monitor.ui.factory.Deletable;
import com.siams.cv.monitor.ui.factory.UIBlockContent;
import com.siams.cv.monitor.ui.factory.UIBlockContextMenu;
import com.siams.cv.monitor.ui.factory.UIPort;
import com.siams.cv.monitor.ui.factory.UIVisibleResult;
import com.siams.cv.monitor.viewers.ui.content.BaseVoxelViewer;
import com.siams.cv.monitor.viewers.ui.content.ChartViewer;
import com.siams.cv.monitor.viewers.ui.content.ImageBorderViewer;
import com.siams.cv.monitor.viewers.ui.content.ImageViewer;
import com.siams.cv.monitor.viewers.ui.content.MaskViewer;
import com.siams.cv.monitor.viewers.ui.content.PlainTextViewer;
import com.siams.cv.monitor.viewers.ui.content.TableViewer;
import com.siams.cv.monitor.viewers.ui.content.TextViewer;
import com.siams.cv.monitor.viewers.ui.content.TriangulationViewer;
import com.siams.cv.monitor.viewers.ui.content.Viewer;
import com.siams.cv.monitor.viewers.ui.content.ViewerData;
import com.siams.cv.monitor.viewers.ui.content.ViewerDataSource;
import com.siams.cv.monitor.viewers.ui.content.ViewerFactory;
import com.siams.cv.monitor.viewers.ui.content.VisibleResultMetaData;
import com.siams.cv.monitor.viewers.ui.content.VisibleResultPort;
import com.siams.cv.monitor.viewers.ui.content.sph.SphViewer;
import com.siams.fx.components.tooltip.StareTooltip;
import com.siams.javafx.utils.FxPlatform;
import com.siams.notifications.StareNotification;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import javafx.scene.Node;
import javafx.scene.control.Tooltip;
import javafx.scene.input.MouseEvent;
import net.algart.executors.api.data.SNumbers;
import net.algart.executors.api.data.SScalar;
import org.apache.log4j.Logger;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;

public class UIBlock
extends Block<UIBlockContent>
implements IIdentifiable,
Deletable {
    private static final Logger logger = Logger.getLogger(UIBlock.class);
    private static final Map<ViewerKind, Class<? extends Viewer>> viewerClasses = new HashMap<ViewerKind, Class<? extends Viewer>>();
    private static final Map<Class<? extends Viewer>, Class<? extends BlockViewerModel>> viewerModelsClasses = new HashMap<Class<? extends Viewer>, Class<? extends BlockViewerModel>>();
    private final App app = App.getInstance();
    private UIBlockModel blockModel;
    private UIVisibleResult uiVisibleResult;
    private NodeClickHandler clickHandler;
    private NodeClickHandler visibleResultClickHandler;
    private NodeDragHandler dragHandler;
    private UIBlockContextMenu contextMenu;

    private Class<? extends Viewer> getViewerClass(ViewerKind viewerKind) {
        if (!viewerClasses.containsKey(viewerKind)) {
            throw new IllegalArgumentException(String.format("Unknown viewer kind: %s", viewerKind));
        }
        return viewerClasses.get(viewerKind);
    }

    private <T extends BlockViewerModel> T createViewerModelIfNecessary(ViewerKind viewerKind, UUID blockId, Consumer<T> onCreated) {
        return this.createViewerModelIfNecessary(this.getViewerClass(viewerKind), blockId, onCreated);
    }

    private <T extends BlockViewerModel> T createViewerModelIfNecessary(Class<? extends Viewer> viewerClass, UUID blockId, Consumer<T> onCreated) {
        if (!viewerModelsClasses.containsKey(viewerClass)) {
            throw new IllegalArgumentException(String.format("Failed create viewer model, unknown viewer class: %s", viewerClass));
        }
        Class<? extends BlockViewerModel> modelClass = viewerModelsClasses.get(viewerClass);
        Optional<ViewerModel> opt = ViewerModelStorage.findByBlockId(blockId);
        if (opt.isPresent() && modelClass.isAssignableFrom(opt.get().getClass())) {
            return (T)((BlockViewerModel)opt.get());
        }
        try {
            opt.ifPresent(model -> ViewerModelStorage.getInstance().removeFirst(m -> m.getUuid().equals(model.getUuid())));
            BlockViewerModel model2 = modelClass.getConstructor(UUID.class).newInstance(blockId);
            ViewerModelStorage.getInstance().addObject(model2);
            if (onCreated != null) {
                onCreated.accept(model2);
            }
            return (T)model2;
        }
        catch (Throwable t) {
            throw new IllegalArgumentException("Failed create viewer model via reflection", t);
        }
    }

    public UIBlock(UIBlockModel blockModel) {
        Objects.requireNonNull(blockModel, "Valid model required");
        this.blockModel = blockModel;
        this.initialize();
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.initializeResizeTriangle((Node)((UIBlockContent)this.root).getResizeTriangle());
        this.initializeUiVisibleResult();
        this.initializeContextMenu();
        this.initializeEnabled();
        this.initializeMoveAndResizeActions();
        this.subscribe();
    }

    @Override
    protected void initializeFxml() {
        this.root = new UIBlockContent(this, true);
    }

    @Override
    protected void initializeEvents() {
        super.initializeEvents();
        this.clickHandler = new ClickHandler();
        this.dragHandler = new BlockDragHandler(this);
    }

    private void initializeUiVisibleResult() {
        this.uiVisibleResult = new UIVisibleResult(((UIBlockContent)this.root).getVisibleResultImage(), ((UIBlockContent)this.root).getVisibleResultText());
        this.uiVisibleResult.show();
        this.visibleResultClickHandler = new ClickHandler((Node)((UIBlockContent)this.root).getVisibleResultText(), this);
    }

    private void initializeContextMenu() {
        this.contextMenu = new UIBlockContextMenu(this);
        ((UIBlockContent)this.root).setOnContextMenuRequested(event -> {
            if (this.app.isDesktopDragging()) {
                return;
            }
            event.consume();
            this.contextMenu.show((Node)this.root, event.getScreenX(), event.getScreenY());
        });
    }

    private void initializeEnabled() {
        this.app.rqIsEnabled(this.blockModel).thenAccept(this::setEnabled);
    }

    private void initializeMoveAndResizeActions() {
        ((UIBlockContent)this.root).layoutXProperty().addListener((ob, o, n) -> {
            double changePropertyThreshold = 2.0;
            if (o.doubleValue() > 0.0 && Math.abs((double)this.blockModel.getLayoutX() - n.doubleValue()) > 2.0) {
                this.blockModel.setLayoutX(n.doubleValue());
                EventBus.getDefault().post((Object)new NodeModelChanged((Model)this.blockModel));
            }
        });
        ((UIBlockContent)this.root).layoutYProperty().addListener((ob, o, n) -> {
            double changePropertyThreshold = 2.0;
            if (o.doubleValue() > 0.0 && Math.abs((double)this.blockModel.getLayoutX() - n.doubleValue()) > 2.0) {
                this.blockModel.setLayoutY(n.doubleValue());
                EventBus.getDefault().post((Object)new NodeModelChanged((Model)this.blockModel));
            }
        });
        ((UIBlockContent)this.root).layoutBoundsProperty().addListener((ob, o, n) -> {
            if (o.getWidth() > 0.0 && o.getHeight() > 0.0) {
                this.blockModel.setLayoutWidth(n.getWidth());
                this.blockModel.setLayoutHeight(n.getHeight());
                EventBus.getDefault().post((Object)new NodeModelChanged((Model)this.blockModel));
            }
        });
    }

    private void subscribe() {
        EventBus.getDefault().register((Object)this);
    }

    @Subscribe
    public void onProjectNodeChanged(NodeModelChanged event) {
        UIBlockModel uiBlockModel = (UIBlockModel)event.getNodeModel();
        if (uiBlockModel.getUuid().equals(this.getUuid())) {
            this.updateNodeModel(uiBlockModel);
        }
    }

    @Subscribe
    public void onStareMonitorClosing(StareMonitorClosing event) {
        this.release();
    }

    @Subscribe
    public void onNodeSelected(NodeSelected event) {
        FxPlatform.RunFxThread(() -> {
            UUID uuid = this.getUuid();
            this.setSelection(event.getSelected().stream().anyMatch(node -> node.getUuid().equals(uuid)));
        });
    }

    @Subscribe
    public void onObjectPropertySet(ObjectPropertySet event) {
    }

    @Subscribe
    public void onBlockPreviewReceived(BlockPreviewReceived event) {
        if (!this.getUuid().equals(event.getObjectUid())) {
            return;
        }
        FxPlatform.RunFxThread(() -> {
            Object data = event.getData();
            if (data instanceof SImage) {
                SImage sImage = (SImage)((Object)((Object)data));
                this.uiVisibleResult.showImage(sImage);
            } else if (data instanceof SScalar) {
                SScalar sScalar = (SScalar)data;
                this.uiVisibleResult.showText(sScalar.getValue());
            } else if (data instanceof String) {
                this.uiVisibleResult.showText((String)data);
            } else if (data instanceof SNumbers) {
                SNumbers sNumbers = (SNumbers)data;
                this.uiVisibleResult.showText(String.format("%s\n%s", sNumbers.toString(false), sNumbers.toString(true)));
            } else {
                this.uiVisibleResult.showDefaultEmptyImage();
            }
        });
    }

    @Subscribe
    public void onStatisticResultReady(StatisticResultReady event) {
        Statistic statistic = event.getStatistic();
        if (!this.getUuid().equals(statistic.getObjectUuid())) {
            return;
        }
        if (statistic.hasError()) {
            Object s = statistic.getErrorMessage();
            String className = statistic.getErrorClassName();
            if (className != null && !className.isEmpty()) {
                int p = className.lastIndexOf(".");
                s = className.substring(p + 1) + ":\n" + (String)s;
            }
            this.uiVisibleResult.showError((String)s);
        } else {
            StareTooltip tooltip = new StareTooltip(DataTooltip.createTooltip(statistic, this.getUuid().toString()));
            this.uiVisibleResult.setTooltip((Tooltip)tooltip);
            this.blockModel.getPorts().forEach(uiPortModel -> NodeStorage.getInstance().findFirst(uiPortModel.getUuid(), UIPort.class).ifPresent(port -> port.updatePortDataTooltip(statistic)));
        }
    }

    @Subscribe
    public void onObjectStatusChanged(ObjectStatusChanged event) {
        if (!this.getUuid().equals(UUID.fromString(event.getId()))) {
            return;
        }
        switch (event.getStatus()) {
            case QUEUE: 
            case EXECUTING: {
                FxPlatform.RunFxThread(() -> ((UIBlockContent)this.root).getStyleClass().add((Object)"executing"));
                break;
            }
            case UNDEFINED: 
            case READY: {
                FxPlatform.RunFxThread(() -> ((UIBlockContent)this.root).getStyleClass().removeAll((Object[])new String[]{"executing"}));
                break;
            }
            default: {
                logger.warn((Object)"Unsupported block status");
            }
        }
    }

    @Subscribe
    public void onChainStatusChanged(ChainStatusChanged event) {
    }

    @Subscribe
    public void onStareChainConfigLoaded(StareChainConfigLoaded event) {
        this.initializeEnabled();
    }

    public UUID getUuid() {
        return this.blockModel.getUuid();
    }

    public String getRelUrl() {
        return String.format("/worker:%s", this.getUuid());
    }

    public boolean equals(Object obj) {
        return false;
    }

    public String toString() {
        return "UIBlock{blockModel=" + String.valueOf(this.blockModel) + "}";
    }

    @Override
    public Node getNode() {
        return this.root;
    }

    public UIBlockModel getNodeModel() {
        return this.blockModel;
    }

    void updatePortVisibility(UIPortModel portModel) {
        NodeStorage.getInstance().findFirst(portModel.getUuid()).map(StareNode::getNode).ifPresent(node -> {
            node.setVisible(portModel.isVisible());
            node.setManaged(portModel.isVisible());
        });
    }

    public void setEnabled(Boolean enabled) {
        FxPlatform.RunFxThread(() -> {
            ((UIBlockContent)this.root).getStyleClass().removeAll((Object[])new String[]{"disable"});
            if (!enabled.booleanValue()) {
                ((UIBlockContent)this.root).getStyleClass().add((Object)"disable");
            }
        });
    }

    public void callViewer() {
        this.callViewerImpl();
    }

    @Override
    public void release() {
        if (EventBus.getDefault().isRegistered((Object)this)) {
            EventBus.getDefault().unregister((Object)this);
        }
        if (this.clickHandler != null) {
            this.clickHandler.release();
        }
        if (this.dragHandler != null) {
            this.dragHandler.release();
        }
        if (this.visibleResultClickHandler != null) {
            this.visibleResultClickHandler.release();
        }
        ((UIBlockContent)this.root).release();
        this.getNodeModel().getPorts().forEach(uiPortModel -> App.removeFromStorage(uiPortModel.getUuid()));
    }

    private void updateNodeModel(UIBlockModel uiBlockModel) {
        this.blockModel = uiBlockModel;
        FxPlatform.RunFxThread(() -> ((UIBlockContent)this.root).initializeTitleAndComment(uiBlockModel));
    }

    private void setSelection(boolean isSelected) {
        ((UIBlockContent)this.root).getStyleClass().removeAll((Object[])new String[]{"selected"});
        if (isSelected) {
            ((UIBlockContent)this.root).requestFocus();
            ((UIBlockContent)this.root).getStyleClass().add((Object)"selected");
        }
    }

    private void callViewerImpl() {
        ((CompletableFuture)((CompletableFuture)this.app.rqFindStatistic(this.blockModel).thenCompose(opt -> {
            opt.ifPresent(statistic -> {
                if (statistic.hasError()) {
                    throw new RuntimeException(statistic.getStackTrace());
                }
            });
            return this.app.rqViewerData(this.blockModel);
        })).thenAccept(viewerData -> FxPlatform.RunFxThread(() -> this.displayViewer((ViewerData)viewerData)))).exceptionally(t -> {
            String errMsg = t.getMessage();
            String ignore = "java.lang.RuntimeException: ";
            String message = errMsg.startsWith("java.lang.RuntimeException: ") ? errMsg.substring("java.lang.RuntimeException: ".length()) : errMsg;
            FxPlatform.RunFxThread(() -> this.displayError(message));
            return null;
        });
    }

    private void displayError(String error) {
        UUID blockId = this.getUuid();
        PlainTextViewerModel model = new PlainTextViewerModel();
        model.setBlockUuid(blockId);
        Viewer viewer = ViewerFactory.create((ViewerKind)ViewerKind.PLAIN_TEXT, (ViewerModel)model);
        if (viewer != null) {
            if (TextViewer.class.isAssignableFrom(viewer.getClass())) {
                VisibleResultPort port = new VisibleResultPort();
                port.setName("input");
                port.setType("input");
                VisibleResultMetaData meta = new VisibleResultMetaData();
                meta.setPorts(Collections.singletonList(port));
                HashMap<String, SScalar> dataMap = new HashMap<String, SScalar>();
                dataMap.put("input", new SScalar(error));
                ViewerData data = new ViewerData(dataMap, meta);
                BlockBasedDataSource dataSource = new BlockBasedDataSource(this.getUuid());
                dataSource.setData(data);
                viewer.setViewerDataSource((ViewerDataSource)dataSource);
                ViewerContainer.createAndShow(viewer);
            } else {
                logger.error((Object)"Unsupported text viewer");
            }
        }
    }

    private void displayViewer(ViewerData viewerData) {
        VisibleResultMetaData meta = viewerData.getMeta();
        Map requiredData = viewerData.getData();
        ViewerKind viewerKind = ViewerKind.from((String)meta.getModel(), (Map)requiredData);
        if (viewerKind == ViewerKind.UNKNOWN) {
            String error = "No data to display";
            logger.warn((Object)"No data to display");
            StareNotification.showWarn((String)"No data to display");
            return;
        }
        if (viewerKind == ViewerKind.POKE) {
            this.displayPokeViewer(viewerData);
            return;
        }
        if (viewerKind == ViewerKind.MASK || viewerKind == ViewerKind.BOUNDARIES) {
            viewerKind = ViewerKind.IMAGE;
        }
        logger.debug((Object)String.format("Display viewer: %s", viewerKind.toString()));
        UUID blockId = this.getUuid();
        try {
            Viewer viewer;
            Object viewerModel = this.createViewerModelIfNecessary(viewerKind, blockId, null);
            if (viewerModel.isShowing()) {
                viewerModel.toFront();
                return;
            }
            viewerModel.setTitle(this.blockModel.getCaption());
            if (viewerModel instanceof ImageViewerModel) {
                ((CompletableFuture)this.app.rqGetAutoContrastVisibleResult(this.blockModel).whenComplete((enabled, t) -> {
                    enabled = t == null ? enabled : false;
                    ((ImageViewerModel)viewerModel).setAutoContrastEnabled(enabled);
                })).get();
            }
            if ((viewer = ViewerFactory.create((ViewerKind)viewerKind, viewerModel)) != null) {
                BlockBasedDataSource dataSource = new BlockBasedDataSource(this.getUuid());
                dataSource.setData(viewerData);
                viewer.setViewerDataSource((ViewerDataSource)dataSource);
                ViewerContainer.createAndShow(viewer);
            }
        }
        catch (NullPointerException npe) {
            logger.warn((Object)"Attempt to create viewer with empty data.");
            StareNotification.showWarn((String)"No data to display");
        }
        catch (Throwable t2) {
            logger.error((Object)"Failed create viewer model/viewer", t2);
        }
    }

    private void displayPokeViewer(ViewerData viewerData) {
        throw new UnsupportedOperationException("Integration with Poke Viewer is not supported");
    }

    static {
        viewerClasses.put(ViewerKind.IMAGE, ImageViewer.class);
        viewerClasses.put(ViewerKind.MASK, MaskViewer.class);
        viewerClasses.put(ViewerKind.BOUNDARIES, ImageBorderViewer.class);
        viewerClasses.put(ViewerKind.PLAIN_TEXT, PlainTextViewer.class);
        viewerClasses.put(ViewerKind.TABLE, TableViewer.class);
        viewerClasses.put(ViewerKind.VOXEL, BaseVoxelViewer.class);
        viewerClasses.put(ViewerKind.SPHEREPOLYHEDRA, SphViewer.class);
        viewerClasses.put(ViewerKind.CHART, ChartViewer.class);
        viewerClasses.put(ViewerKind.TRIANGULATION, TriangulationViewer.class);
        viewerModelsClasses.put(ImageViewer.class, ImageViewerModel.class);
        viewerModelsClasses.put(MaskViewer.class, ImageMaskViewerModel.class);
        viewerModelsClasses.put(ImageBorderViewer.class, ImageBorderViewerModel.class);
        viewerModelsClasses.put(PlainTextViewer.class, PlainTextViewerModel.class);
        viewerModelsClasses.put(TableViewer.class, TableViewerModel.class);
        viewerModelsClasses.put(BaseVoxelViewer.class, VoxelViewerModel.class);
        viewerModelsClasses.put(SphViewer.class, SphViewerModel.class);
        viewerModelsClasses.put(ChartViewer.class, ChartViewerModel.class);
        viewerModelsClasses.put(TriangulationViewer.class, TriangulationViewerModel.class);
    }

    private class ClickHandler
    extends DefaultNodeClickHandler {
        private ClickHandler() {
            super((Node)UIBlock.this.root, UIBlock.this);
        }

        private ClickHandler(Node eventConsumer, StareNode eventTarget) {
            super(eventConsumer, eventTarget);
        }

        @Override
        protected void onDoubleClick(MouseEvent event) {
            UIBlock.this.callViewerImpl();
        }

        @Override
        protected void onControlDoubleClick(MouseEvent event) {
            if (UIBlock.this.uiVisibleResult.getViewerKind() != ViewerKind.IMAGE) {
                return;
            }
            UserAction.addViewerToCompare(UIBlock.this.getUuid(), 1);
        }

        @Override
        protected void onClick(MouseEvent event) {
            super.onClick(event);
            if (!event.isControlDown()) {
                UserAction.introspectObject(UIBlock.this);
            }
        }
    }

    private class BlockDragHandler
    extends DefaultNodeDragHandler {
        private BlockDragHandler(UIBlock uIBlock) {
            super((Node)uIBlock.root, uIBlock);
        }

        @Override
        protected void onPress(MouseEvent event) {
            super.onPress(event);
        }

        @Override
        protected void onDrag(MouseEvent event) {
            super.onDrag(event);
        }
    }
}

