/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.ui.factory;

import com.siams.cv.monitor.application.App;
import com.siams.cv.monitor.entity.StareNode;
import com.siams.cv.monitor.model.PortType;
import com.siams.cv.monitor.model.app.Root;
import com.siams.cv.monitor.model.node.NodeModel;
import com.siams.cv.monitor.model.node.UIBlockModel;
import com.siams.cv.monitor.model.node.UIPortModel;
import com.siams.cv.monitor.ui.factory.AlternativePort;
import com.siams.cv.monitor.ui.factory.Deletable;
import com.siams.cv.monitor.ui.factory.NodeFactory;
import com.siams.cv.monitor.ui.factory.UIBlock;
import com.siams.cv.monitor.ui.factory.UIPort;
import com.siams.cv.monitor.ui.factory.UIPortInput;
import com.siams.cv.monitor.ui.factory.UIPortInputControl;
import com.siams.cv.monitor.ui.factory.UIPortOutput;
import com.siams.cv.monitor.ui.factory.UIPortOutputControl;
import com.siams.fxml.loader.CustomFXMLLoader;
import com.siams.javafx.PaneHelper;
import com.siams.javafx.utils.FxPlatform;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Bounds;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.image.ImageView;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.shape.Arc;
import javafx.scene.shape.Polygon;
import org.apache.log4j.Logger;

public class UIBlockContent
extends AnchorPane
implements Initializable,
Deletable {
    private final Logger logger = Logger.getLogger(UIBlockContent.class);
    private BlockBoundsListener blockBoundsListener;
    private UIBlock uiBlock;
    private AlternativePort altInputPort;
    private AlternativePort altOutputPort;
    @FXML
    private Node inputAltPort;
    @FXML
    private VBox mainVBox;
    @FXML
    private Node outputAltPort;
    @FXML
    private VBox vBoxLeft;
    @FXML
    private VBox vBoxCenter;
    @FXML
    private VBox vBoxRight;
    @FXML
    private Label labelBlockComment;
    @FXML
    private Button buttonSettings;
    @FXML
    private TextArea visibleResultText;
    @FXML
    private ImageView visibleResultImage;
    @FXML
    protected VBox leftPane;
    @FXML
    protected VBox rightPane;
    @FXML
    protected Label titleLabel;
    @FXML
    private VBox paneInputControlPorts;
    @FXML
    private VBox paneOutputControlPorts;
    @FXML
    private Polygon resizeTriangle;

    @Override
    public void release() {
        if (this.blockBoundsListener != null) {
            this.layoutBoundsProperty().removeListener((ChangeListener)this.blockBoundsListener);
        }
        if (this.altInputPort != null) {
            this.altInputPort.release();
        }
        if (this.altOutputPort != null) {
            this.altOutputPort.release();
        }
    }

    public UIBlockContent(UIBlock uiBlock, boolean useFxml) {
        this.uiBlock = uiBlock;
        if (useFxml) {
            try {
                CustomFXMLLoader.loadElement((Object)this);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            this.initializeManualLayouts();
        }
    }

    private void initializeManualLayouts() {
        this.inputAltPort = new Arc();
        this.titleLabel = new Label();
        this.outputAltPort = new Arc();
        GridPane gridPaneTop = new GridPane();
        gridPaneTop.getColumnConstraints().add((Object)new ColumnConstraints());
        gridPaneTop.getColumnConstraints().add((Object)new ColumnConstraints(Double.NEGATIVE_INFINITY, 100.0, Double.NEGATIVE_INFINITY, Priority.SOMETIMES, HPos.CENTER, true));
        gridPaneTop.getColumnConstraints().add((Object)new ColumnConstraints());
        gridPaneTop.getChildren().add((Object)this.inputAltPort);
        gridPaneTop.getChildren().add((Object)this.titleLabel);
        gridPaneTop.getChildren().add((Object)this.outputAltPort);
        VBox.setMargin((Node)gridPaneTop, (Insets)new Insets(5.0, 0.0, 5.0, 0.0));
        this.leftPane = new VBox(5.0);
        this.paneInputControlPorts = new VBox(5.0);
        this.vBoxLeft = new VBox(new Node[]{this.leftPane, this.paneInputControlPorts});
        VBox center = new VBox();
        center.setAlignment(Pos.CENTER);
        center.maxHeight(Double.MAX_VALUE);
        center.maxWidth(Double.MAX_VALUE);
        center.minHeight(0.0);
        center.minWidth(0.0);
        this.rightPane = new VBox(5.0);
        this.paneOutputControlPorts = new VBox(5.0);
        this.vBoxRight = new VBox(new Node[]{this.rightPane, this.paneOutputControlPorts});
        HBox hBox = new HBox(5.0);
        hBox.getChildren().add((Object)this.vBoxLeft);
        hBox.getChildren().add((Object)center);
        hBox.getChildren().add((Object)this.vBoxRight);
        HBox.setHgrow((Node)center, (Priority)Priority.ALWAYS);
        VBox mainVBox = new VBox(5.0);
        mainVBox.getChildren().add((Object)gridPaneTop);
        mainVBox.getChildren().add((Object)hBox);
        this.resizeTriangle = new Polygon(new double[]{-15.0, 0.0, 0.0, 0.0, 0.0, -15.0});
        this.resizeTriangle.setCursor(Cursor.SE_RESIZE);
        this.getChildren().add((Object)mainVBox);
        this.getChildren().add((Object)this.resizeTriangle);
        PaneHelper.setAnchorZero((Node)mainVBox);
        AnchorPane.setBottomAnchor((Node)this.resizeTriangle, (Double)0.0);
        AnchorPane.setRightAnchor((Node)this.resizeTriangle, (Double)0.0);
        throw new RuntimeException("unimplemented");
    }

    public void initialize(URL location, ResourceBundle resources) {
        long t0 = System.currentTimeMillis();
        FxPlatform.RunFxThread(() -> {
            long t1 = System.currentTimeMillis();
            UIBlockModel uiBlockModel = this.uiBlock.getNodeModel();
            this.initializePorts(uiBlockModel);
            this.initializeTitleAndComment(uiBlockModel);
            this.initializePositionAndSize(uiBlockModel);
            this.labelBlockComment.layoutBoundsProperty().addListener((ob, o, n) -> {
                double padding = 10.0;
                AnchorPane.setBottomAnchor((Node)this.labelBlockComment, (Double)(-n.getHeight() - 10.0));
                this.labelBlockComment.layout();
            });
            this.labelBlockComment.textProperty().addListener((ob, o, n) -> {
                double padding = 10.0;
                AnchorPane.setBottomAnchor((Node)this.labelBlockComment, (Double)(-this.labelBlockComment.getHeight() - 10.0));
                this.labelBlockComment.layout();
            });
            this.vBoxCenter.layoutBoundsProperty().addListener((ob, o, n) -> {
                double padding = 10.0;
                double minWidth = 50.0;
                double minHeight = 50.0;
                if (this.visibleResultImage.getImage() != null) {
                    boolean displayImage = n.getWidth() > 50.0 && n.getHeight() > 50.0;
                    this.visibleResultImage.setManaged(displayImage);
                    this.visibleResultImage.setVisible(displayImage);
                    if (displayImage) {
                        this.visibleResultImage.setFitWidth(n.getWidth());
                        this.visibleResultImage.setFitHeight(n.getHeight() - 10.0);
                    }
                }
                this.visibleResultText.setPrefWidth(n.getWidth());
                this.visibleResultText.setMaxWidth(n.getWidth());
                this.visibleResultText.setPrefHeight(n.getHeight() - 10.0);
                this.visibleResultText.setMaxHeight(n.getHeight() - 10.0);
            });
            this.visibleResultText.textProperty().addListener((ob, o, n) -> {
                boolean displayTextResult = n != null && !n.isEmpty();
                this.visibleResultText.setVisible(displayTextResult);
                this.visibleResultText.setManaged(displayTextResult);
            });
            this.visibleResultImage.imageProperty().addListener((ob, o, n) -> {
                double minWidth = 50.0;
                double minHeight = 50.0;
                Bounds bounds = this.vBoxCenter.getLayoutBounds();
                boolean displayImage = n != null && bounds.getWidth() > 50.0 && bounds.getHeight() > 50.0;
                this.visibleResultImage.setManaged(displayImage);
                this.visibleResultImage.setVisible(displayImage);
            });
            this.visibleResultText.setVisible(false);
            this.visibleResultText.setManaged(false);
            this.visibleResultImage.setVisible(true);
            this.visibleResultImage.setManaged(true);
            this.uiBlock.fxmlInitialized.complete(null);
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)String.format("[Profiler] UIBlockContent.initialize waiting run later %d ms", t1 - t0));
                this.logger.trace((Object)String.format("[Profiler] UIBlockContent.initialize %d ms", System.currentTimeMillis() - t0));
            }
        });
    }

    public Node getInputAltPort() {
        return this.inputAltPort;
    }

    public Node getOutputAltPort() {
        return this.outputAltPort;
    }

    public VBox getvBoxLeft() {
        return this.vBoxLeft;
    }

    public VBox getvBoxRight() {
        return this.vBoxRight;
    }

    public Label getLabelBlockComment() {
        return this.labelBlockComment;
    }

    public Button getButtonSettings() {
        return this.buttonSettings;
    }

    public TextArea getVisibleResultText() {
        return this.visibleResultText;
    }

    public ImageView getVisibleResultImage() {
        return this.visibleResultImage;
    }

    public VBox getLeftPane() {
        return this.leftPane;
    }

    public VBox getRightPane() {
        return this.rightPane;
    }

    public Label getTitleLabel() {
        return this.titleLabel;
    }

    public VBox getPaneInputControlPorts() {
        return this.paneInputControlPorts;
    }

    public VBox getPaneOutputControlPorts() {
        return this.paneOutputControlPorts;
    }

    public Polygon getResizeTriangle() {
        return this.resizeTriangle;
    }

    void initializeTitleAndComment(UIBlockModel blockModel) {
        boolean isCustomCommentExist = !blockModel.getComment().isEmpty();
        this.labelBlockComment.setText(blockModel.getComment());
        this.titleLabel.setText(blockModel.getCaption());
    }

    void initializePositionAndSize(UIBlockModel blockModel) {
        boolean layoutRequired = false;
        Root root = App.getInstance().getProject().getRoot();
        boolean gridAdjust = root.getGridAdjust();
        int gridSize = root.getGridSize();
        if (blockModel.getLayoutX() != 0 && blockModel.getLayoutY() != 0) {
            int x = gridAdjust ? blockModel.getLayoutX() / gridSize * gridSize : blockModel.getLayoutX();
            this.setLayoutX(x);
            int y = gridAdjust ? blockModel.getLayoutY() / gridSize * gridSize : blockModel.getLayoutY();
            this.setLayoutY(y);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)String.format("block layout x: %.0f, y: %.0f", this.getLayoutX(), this.getLayoutY()));
            }
            layoutRequired = true;
        }
        if (blockModel.getLayoutWidth() != 0 && blockModel.getLayoutHeight() != 0) {
            int width = gridAdjust ? blockModel.getLayoutWidth() / gridSize * gridSize : blockModel.getLayoutWidth();
            int height = gridAdjust ? blockModel.getLayoutHeight() / gridSize * gridSize : blockModel.getLayoutHeight();
            this.setPrefSize(width, height);
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)String.format("block pref size: %.0f x %.0f", this.getPrefWidth(), this.getPrefHeight()));
            }
            layoutRequired = true;
        }
        if (layoutRequired) {
            this.layout();
        }
    }

    private void initializePorts(UIBlockModel blockModel) {
        LinkedList<UIPort> inPorts = new LinkedList<UIPort>();
        inPorts.addAll(this.createPorts(blockModel.getPorts(PortType.INPUT), UIPortInput.class, this.inputAltPort));
        inPorts.addAll(this.createPorts(blockModel.getPorts(PortType.INPUT_CONTROL), UIPortInputControl.class, this.inputAltPort));
        this.leftPane.getChildren().addAll(inPorts);
        LinkedList<UIPort> outPorts = new LinkedList<UIPort>();
        outPorts.addAll(this.createPorts(blockModel.getPorts(PortType.OUTPUT), UIPortOutput.class, this.outputAltPort));
        outPorts.addAll(this.createPorts(blockModel.getPorts(PortType.OUTPUT_CONTROL), UIPortOutputControl.class, this.outputAltPort));
        this.rightPane.getChildren().addAll(outPorts);
        ArrayList<UIPort> allPorts = new ArrayList<UIPort>();
        allPorts.addAll(inPorts);
        allPorts.addAll(outPorts);
        this.blockBoundsListener = new BlockBoundsListener(allPorts);
        this.altInputPort = new AlternativePort(this.inputAltPort, inPorts);
        this.altOutputPort = new AlternativePort(this.outputAltPort, outPorts);
    }

    private <T extends StareNode> List<UIPort> createPorts(List<UIPortModel> ports, Class<T> uiPortClass, Node alternativeAnchor) {
        return ports.stream().map(portModel -> {
            UIPort uiPort = (UIPort)NodeFactory.createNode((NodeModel)portModel, uiPortClass);
            uiPort.initialize();
            uiPort.setUIBlock(this.uiBlock);
            uiPort.setAlternativeAnchor(alternativeAnchor);
            boolean isVisible = portModel.isVisible();
            uiPort.setVisible(isVisible);
            uiPort.setManaged(isVisible);
            return uiPort;
        }).collect(Collectors.toList());
    }

    private class BlockBoundsListener
    implements ChangeListener {
        private List<UIPort> ports;

        BlockBoundsListener(List<UIPort> ports) {
            UIBlockContent.this.layoutBoundsProperty().addListener((ChangeListener)this);
            this.ports = ports;
        }

        public void changed(ObservableValue observable, Object o, Object n) {
            this.ports.forEach(port -> {
                if (port.getNodeModel().isVisible()) {
                    Bounds portBounds = UIBlockContent.this.sceneToLocal(port.localToScene(port.getBoundsInLocal()));
                    Bounds blockBounds = UIBlockContent.this.getLayoutBounds();
                    boolean isContains = blockBounds.getMaxY() - 10.0 - portBounds.getMaxY() > 0.0;
                    port.setVisible(isContains);
                    port.setManaged(isContains);
                }
            });
        }
    }
}

