/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.ui.factory;

import com.siams.cv.monitor.model.node.UICommentModel;
import com.siams.cv.monitor.ui.factory.UIComment;
import com.siams.fxml.loader.CustomFXMLLoader;
import java.io.IOException;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.control.Label;
import javafx.scene.layout.AnchorPane;
import javafx.scene.shape.Polygon;
import javafx.scene.text.TextAlignment;

public class UICommentContent
extends AnchorPane
implements Initializable {
    private UIComment uiComment;
    @FXML
    private Label labelComment;
    @FXML
    private Polygon resizeTriangle;

    public Label getLabelComment() {
        return this.labelComment;
    }

    UICommentContent(UIComment uiComment) {
        this.uiComment = uiComment;
        try {
            CustomFXMLLoader.loadElement((Object)((Object)this));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void initialize(URL location, ResourceBundle resources) {
        Platform.runLater(() -> {
            UICommentModel model = (UICommentModel)this.uiComment.getNodeModel();
            this.initializeModel(model);
            this.uiComment.fxmlInitialized.complete(null);
        });
    }

    private void initializeModel(UICommentModel model) {
        this.setLayoutX(model.getLayoutX());
        this.setLayoutY(model.getLayoutY());
        if (model.getLayoutWidth() > 0.0) {
            this.setPrefWidth(model.getLayoutWidth());
        }
        if (model.getLayoutHeight() > 0.0) {
            this.setPrefHeight(model.getLayoutHeight());
        }
        this.labelComment.setAlignment(Pos.CENTER_LEFT);
        this.labelComment.setTextAlignment(TextAlignment.LEFT);
        this.labelComment.setPadding(new Insets(10.0, 20.0, 10.0, 20.0));
        String text = model.getComment().isEmpty() ? "Write comment here..." : model.getComment();
        this.labelComment.setText(text);
    }

    public Polygon getResizeTriangle() {
        return this.resizeTriangle;
    }
}

