/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.ui.factory;

import com.siams.cv.monitor.model.node.PortDataType;
import com.siams.cv.monitor.model.node.UIPortModel;
import com.siams.cv.monitor.ui.factory.UIPort;
import com.siams.javafx.PaneHelper;
import java.util.Map;
import javafx.geometry.HPos;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.RowConstraints;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Arc;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeLineJoin;
import javafx.scene.shape.StrokeType;

public class UIPortInput
extends UIPort {
    private static final Map<String, String> STANDARD_CAPTIONS = UIPortInput.makeDictionary("input", "img:/com/siams/cv/monitor/ui/content/block/icons/port_input.png", "external input", "img:/com/siams/cv/monitor/ui/content/block/icons/port_external_input.png", "external parameter", "img:/com/siams/cv/monitor/ui/content/block/icons/port_external_parameter.png");
    private static final Map<String, String> STANDARD_MAT_CAPTIONS = UIPortInput.makeDictionary("input", "img:/com/siams/cv/monitor/ui/content/block/icons/port_mat_input.png", "external input", "img:/com/siams/cv/monitor/ui/content/block/icons/port_mat_external_input.png", "labels", "img:/com/siams/cv/monitor/ui/content/block/icons/labels.png", "mask", "img:/com/siams/cv/monitor/ui/content/block/icons/mask.png");
    private static final Map<String, String> STANDARD_NUMBERS_CAPTIONS = UIPortInput.makeDictionary("input", "img:/com/siams/cv/monitor/ui/content/block/icons/port_input.png", "external input", "img:/com/siams/cv/monitor/ui/content/block/icons/port_external_input.png", "external parameter", "img:/com/siams/cv/monitor/ui/content/block/icons/port_external_parameter.png");
    private static final Map<String, String> STANDARD_SCALAR_CAPTIONS = UIPortInput.makeDictionary("input", "img:/com/siams/cv/monitor/ui/content/block/icons/port_input.png", "external input", "img:/com/siams/cv/monitor/ui/content/block/icons/port_external_input.png", "external parameter", "img:/com/siams/cv/monitor/ui/content/block/icons/port_external_parameter.png", "settings", "img:/com/siams/cv/monitor/ui/content/block/icons/settings.png", "mapping", "img:/com/siams/cv/monitor/ui/content/block/icons/mapping.png");
    protected Color portColor = Color.DODGERBLUE;

    public UIPortInput(UIPortModel model) {
        super(model);
    }

    @Override
    protected void initializeFxml() {
        boolean useFxml = false;
        this.initializeManualLayouts();
    }

    protected void initializeManualLayouts() {
        Arc arc = new Arc();
        arc.setFill((Paint)this.portColor);
        arc.setLength(180.0);
        arc.setRadiusX(8.0);
        arc.setRadiusY(8.0);
        arc.setStartAngle(270.0);
        arc.setStroke((Paint)Color.BLACK);
        arc.setStrokeLineCap(StrokeLineCap.ROUND);
        arc.setStrokeLineJoin(StrokeLineJoin.ROUND);
        arc.setStrokeMiterLimit(0.0);
        arc.setStrokeType(StrokeType.INSIDE);
        arc.setVisible(true);
        arc.setManaged(true);
        this.anchor = arc;
        Label lblCaption = new Label();
        lblCaption.setAlignment(Pos.TOP_LEFT);
        lblCaption.setContentDisplay(ContentDisplay.TOP);
        lblCaption.setWrapText(false);
        this.portCaption = lblCaption;
        ColumnConstraints c1 = new ColumnConstraints();
        c1.setFillWidth(false);
        c1.setHgrow(Priority.NEVER);
        c1.setMinWidth(14.0);
        ColumnConstraints c2 = new ColumnConstraints();
        c2.setHgrow(Priority.ALWAYS);
        c2.setHalignment(HPos.LEFT);
        c2.setMinWidth(10.0);
        RowConstraints r1 = new RowConstraints();
        r1.setVgrow(Priority.SOMETIMES);
        GridPane grid = new GridPane();
        grid.getColumnConstraints().add((Object)c1);
        grid.getColumnConstraints().add((Object)c2);
        grid.getRowConstraints().add((Object)r1);
        grid.getChildren().add((Object)arc);
        grid.getChildren().add((Object)lblCaption);
        GridPane.setColumnIndex((Node)arc, (Integer)0);
        GridPane.setColumnIndex((Node)lblCaption, (Integer)1);
        GridPane.setHalignment((Node)arc, (HPos)HPos.LEFT);
        this.getChildren().add((Object)grid);
        PaneHelper.setAnchorZero((Node)grid);
    }

    @Override
    Map<String, String> standardCaptions(PortDataType portDataType) {
        String typeName = portDataType.getName();
        if (typeName != null) {
            switch (typeName) {
                case "mat": {
                    return STANDARD_MAT_CAPTIONS;
                }
                case "numbers": {
                    return STANDARD_NUMBERS_CAPTIONS;
                }
                case "scalar": {
                    return STANDARD_SCALAR_CAPTIONS;
                }
            }
        }
        return STANDARD_CAPTIONS;
    }
}

