/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.ui.factory;

import com.siams.cv.monitor.application.UserAction;
import com.siams.cv.monitor.model.node.PortDataType;
import com.siams.cv.monitor.model.node.UIPortModel;
import com.siams.cv.monitor.ui.factory.UIPort;
import com.siams.javafx.PaneHelper;
import java.util.Map;
import javafx.geometry.HPos;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.input.ContextMenuEvent;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.RowConstraints;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Arc;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeLineJoin;
import javafx.scene.shape.StrokeType;

public class UIPortOutput
extends UIPort {
    private static final Map<String, String> STANDARD_CAPTIONS = UIPortOutput.makeDictionary("output", "img:/com/siams/cv/monitor/ui/content/block/icons/port_output.png", "external output", "img:/com/siams/cv/monitor/ui/content/block/icons/port_external_output.png");
    private static final Map<String, String> STANDARD_MAT_CAPTIONS = UIPortOutput.makeDictionary("output", "img:/com/siams/cv/monitor/ui/content/block/icons/port_mat_output.png", "external output", "img:/com/siams/cv/monitor/ui/content/block/icons/port_mat_external_output.png", "labels", "img:/com/siams/cv/monitor/ui/content/block/icons/labels.png", "mask", "img:/com/siams/cv/monitor/ui/content/block/icons/mask.png");
    private static final Map<String, String> STANDARD_NUMBERS_CAPTIONS = UIPortOutput.makeDictionary("output", "img:/com/siams/cv/monitor/ui/content/block/icons/port_output.png", "external output", "img:/com/siams/cv/monitor/ui/content/block/icons/port_external_output.png");
    private static final Map<String, String> STANDARD_SCALAR_CAPTIONS = UIPortOutput.makeDictionary("output", "img:/com/siams/cv/monitor/ui/content/block/icons/port_output.png", "external output", "img:/com/siams/cv/monitor/ui/content/block/icons/port_external_output.png", "settings", "img:/com/siams/cv/monitor/ui/content/block/icons/settings.png", "mapping", "img:/com/siams/cv/monitor/ui/content/block/icons/mapping.png");
    protected Color portColor = Color.DODGERBLUE;
    private ContextMenu contextMenu;

    public UIPortOutput(UIPortModel model) {
        super(model);
    }

    @Override
    protected void initializeMouseEvents() {
        super.initializeMouseEvents();
        this.initializeContextMenu();
    }

    private void initializeContextMenu() {
        MenuItem menuItemMarkAsStopPort = new MenuItem("Set as stop loop port");
        menuItemMarkAsStopPort.setOnAction(event -> UserAction.setStopLoopPort(this));
        this.contextMenu = new ContextMenu(new MenuItem[]{menuItemMarkAsStopPort});
        this.setOnContextMenuRequested(this::onRequestContextMenu);
        this.portCaption.setOnContextMenuRequested(this::onRequestContextMenu);
    }

    private void onRequestContextMenu(ContextMenuEvent event) {
        event.consume();
        this.contextMenu.setAutoHide(true);
        this.contextMenu.show((Node)this, event.getScreenX(), event.getScreenY());
    }

    @Override
    protected void initializeFxml() {
        boolean useFxml = false;
        this.initializeManualLayouts();
    }

    protected void initializeManualLayouts() {
        Arc arc = new Arc();
        arc.setFill((Paint)this.portColor);
        arc.setLength(180.0);
        arc.setRadiusX(8.0);
        arc.setRadiusY(8.0);
        arc.setStartAngle(90.0);
        arc.setStroke((Paint)Color.BLACK);
        arc.setStrokeLineCap(StrokeLineCap.ROUND);
        arc.setStrokeLineJoin(StrokeLineJoin.ROUND);
        arc.setStrokeMiterLimit(0.0);
        arc.setStrokeType(StrokeType.INSIDE);
        arc.setVisible(true);
        arc.setManaged(true);
        this.anchor = arc;
        Label lblCaption = new Label();
        lblCaption.setAlignment(Pos.TOP_LEFT);
        lblCaption.setContentDisplay(ContentDisplay.TOP);
        lblCaption.setWrapText(false);
        this.portCaption = lblCaption;
        ColumnConstraints c1 = new ColumnConstraints();
        c1.setFillWidth(false);
        c1.setHgrow(Priority.NEVER);
        c1.setMinWidth(14.0);
        ColumnConstraints c2 = new ColumnConstraints();
        c2.setHgrow(Priority.ALWAYS);
        c2.setHalignment(HPos.LEFT);
        c2.setMinWidth(10.0);
        RowConstraints r1 = new RowConstraints();
        r1.setVgrow(Priority.SOMETIMES);
        GridPane grid = new GridPane();
        grid.getColumnConstraints().add((Object)c1);
        grid.getColumnConstraints().add((Object)c2);
        grid.getRowConstraints().add((Object)r1);
        grid.getChildren().add((Object)lblCaption);
        grid.getChildren().add((Object)arc);
        GridPane.setColumnIndex((Node)lblCaption, (Integer)0);
        GridPane.setColumnIndex((Node)arc, (Integer)1);
        GridPane.setHalignment((Node)arc, (HPos)HPos.RIGHT);
        this.getChildren().add((Object)grid);
        PaneHelper.setAnchorZero((Node)grid);
    }

    @Override
    Map<String, String> standardCaptions(PortDataType portDataType) {
        String typeName = portDataType.getName();
        if (typeName != null) {
            switch (typeName) {
                case "mat": {
                    return STANDARD_MAT_CAPTIONS;
                }
                case "numbers": {
                    return STANDARD_NUMBERS_CAPTIONS;
                }
                case "scalar": {
                    return STANDARD_SCALAR_CAPTIONS;
                }
            }
        }
        return STANDARD_CAPTIONS;
    }
}

