/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.ui.menu;

import com.siams.cv.monitor.application.App;
import com.siams.cv.monitor.application.AppPreference;
import com.siams.cv.monitor.application.BlockChain;
import com.siams.cv.monitor.application.UserAction;
import com.siams.cv.monitor.export.ExportFile;
import com.siams.cv.monitor.export.ExportFunctionsListLogsCsv;
import com.siams.cv.monitor.export.ExportFunctionsListLogsHtml;
import com.siams.cv.monitor.message.StareMonitorClosing;
import com.siams.cv.monitor.message.StareMonitorStarted;
import com.siams.cv.monitor.message.StareProjectLoaded;
import com.siams.cv.monitor.message.StareProjectPrepareToSave;
import com.siams.cv.monitor.message.StareProjectSaved;
import com.siams.cv.monitor.model.app.ProjectManager;
import com.siams.cv.monitor.model.storage.ViewerModelStorage;
import com.siams.cv.monitor.model.viewer.CompareViewerModel;
import com.siams.cv.monitor.model.viewer.ViewerModel;
import com.siams.cv.monitor.model.worker.DefaultWorkerType;
import com.siams.cv.monitor.model.worker.WorkerType;
import com.siams.cv.monitor.ui.content.container.FunctionStatistic;
import com.siams.cv.monitor.ui.content.container.FunctionsList;
import com.siams.cv.monitor.ui.content.windows.ConnectionWindow;
import com.siams.cv.monitor.ui.content.windows.project.settings.ProjectSettings;
import com.siams.cv.monitor.ui.content.windows.project.settings.UIProjectSettings;
import com.siams.cv.monitor.ui.factory.Deletable;
import com.siams.cv.monitor.ui.factory.UIBlock;
import com.siams.cv.monitor.ui.menu.ServerPanel;
import com.siams.dialogs.DialogManager;
import com.siams.fx.components.menu.recent.MenuRecentFiles;
import com.siams.fxml.loader.CustomFXMLLoader;
import com.siams.javafx.utils.FxPlatform;
import com.siams.notifications.StareNotification;
import com.siams.preferences.UIPreference;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.RadioMenuItem;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.AnchorPane;
import javafx.stage.FileChooser;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;

public class StareMainMenu
extends AnchorPane
implements Initializable,
UIPreference,
Deletable {
    private final App app = App.getInstance();
    private static StareMainMenu instance;
    private final Logger logger = Logger.getLogger(StareMainMenu.class);
    private MenuRecentFiles menuRecentFiles;
    private final int MAX_RECENT_FILES = 20;
    private final String PREFERENCE_FILE_NAME = "recentFileName%d";
    @FXML
    private MenuItem miExportFunctionsListLogs;
    @FXML
    private Menu menuItemRecentFiles;
    @FXML
    private Menu menuCompareViewers;
    @FXML
    private MenuItem menuItemJsonEditor;
    @FXML
    private MenuItem miRun;
    @FXML
    private MenuItem miReload;
    @FXML
    private Menu menuRun;
    @FXML
    private Menu menuTools;
    @FXML
    private MenuItem miInterrupt;
    @FXML
    private MenuItem miShowInExplorer;
    @FXML
    private MenuItem miStep;
    @FXML
    private MenuItem miReset;
    @FXML
    private Menu menuDebugMode;
    @FXML
    private RadioMenuItem rmiDebugModeIO;
    @FXML
    private RadioMenuItem rmiDebugModePreview;
    @FXML
    private RadioMenuItem rmiDebugModeAll;
    @FXML
    private MenuItem miServerCache;
    @FXML
    private MenuItem miInstanceMode;
    @FXML
    private MenuItem miServerStatistic;
    @FXML
    private MenuItem miFindUsages;
    @FXML
    private MenuItem miDashboard;
    @FXML
    private MenuItem miServerPanel;
    @FXML
    private MenuItem menuItemConnectionSettings;
    @FXML
    private MenuItem miImportChainConfig;
    @FXML
    private MenuItem miExportChainConfig;
    @FXML
    private MenuItem miImportChainConfigAs;
    @FXML
    private MenuItem miOpenExample;
    @FXML
    private RadioMenuItem miInformation;
    @FXML
    private RadioMenuItem miMessages;
    private final ToggleGroup informationOrMessages = new ToggleGroup();

    @FXML
    void onMainMenuNewChainClick(ActionEvent event) {
        UserAction.createNewProject();
    }

    @FXML
    void onMainMenuNewWindowClick(ActionEvent event) {
        UserAction.openNewWindow();
    }

    @FXML
    void onMainMenuOpenChainClick(ActionEvent event) {
        ProjectManager.showOpenStareProjectDialog().ifPresent(file -> UserAction.loadingStareProject(file).exceptionally(t -> {
            StareNotification.showWarn((String)"Failed to load chain", (Throwable)t);
            return null;
        }));
    }

    @FXML
    void onMainMenuOpenDemoChainClick(ActionEvent event) {
        ProjectManager.showOpenDemoChainDialog().ifPresent(file -> UserAction.loadingStareProject(file).exceptionally(t -> {
            StareNotification.showWarn((String)"Failed to load demo chain", (Throwable)t);
            return null;
        }));
    }

    @FXML
    void onMainMenuCloseApplicationClick(ActionEvent event) {
        DialogManager.showQuery((String)"Close application?", (String)"Confirmation").ifPresent(buttonType -> {
            this.app.close();
            Platform.exit();
        });
    }

    @FXML
    void onMenuItemConnection(ActionEvent event) {
        new ConnectionWindow().show();
    }

    @FXML
    void onMainMenuChainSaveAsClick(ActionEvent event) {
        UserAction.saveAsStareProject();
    }

    @FXML
    void onMainMenuChainSaveClick(ActionEvent event) {
        EventBus.getDefault().post((Object)new StareProjectPrepareToSave());
        UserAction.saveStareProject();
    }

    @FXML
    void onMenuItemToggleServerCache(ActionEvent event) {
        this.app.setEnableServerCache(!this.app.isEnableServerCache());
        this.app.rqSetObjectProperty(this.app.getProject(), "__tmp.enable.cache", this.app.isEnableServerCache()).thenAccept(v -> this.updateMenuItemServerCacheCaption());
    }

    @FXML
    void onMenuItemToggleServerStatistic(ActionEvent event) {
        this.app.setEnableServerStatistic(!this.app.isEnableServerStatistic());
        this.app.rqSetObjectProperty(this.app.getProject(), "__tmp.create_statistic", this.app.isEnableServerStatistic()).thenAccept(v -> this.updateMenuItemServerStatisticCaption());
    }

    @FXML
    void onMenuItemToggleInstanceMode(ActionEvent event) {
        this.app.setInstanceMode(!this.app.isInstanceMode());
        this.updateMenuItemInstanceModeCaption();
    }

    @FXML
    void onMenuItemFindUsages(ActionEvent event) {
        if (this.app.getSelectedObjects().isEmpty()) {
            StareNotification.showWarn((String)"At least one block should be selected for search");
            return;
        }
        List<WorkerType> workersToFind = this.app.getSelectedObjects().stream().filter(stareNode -> stareNode instanceof UIBlock).map(stareNode -> new DefaultWorkerType(((UIBlock)stareNode).getNodeModel().getWorkerType())).collect(Collectors.toList());
        UserAction.findUsages(workersToFind);
    }

    @FXML
    void onMenuItemDashboard(ActionEvent event) {
        UserAction.openDashboard();
    }

    private void displayServerPanel() {
        try {
            ServerPanel panel = new ServerPanel();
            panel.showAndWait().ifPresent(projectUrl -> {
                ButtonType newWindow = new ButtonType("New window");
                ButtonType thisWindow = new ButtonType("This window");
                DialogManager.showQuery((String)"Open project in a new window?", (String)"How to open project", (ButtonType[])new ButtonType[]{newWindow, thisWindow, ButtonType.CANCEL}).ifPresent(buttonType -> {
                    if (buttonType.equals(newWindow)) {
                        BlockChain.openProject(projectUrl);
                    }
                    if (buttonType.equals(thisWindow)) {
                        this.app.initializeAppAfterConnection((String)projectUrl);
                    }
                });
            });
        }
        catch (Exception e) {
            this.logger.error((Object)"Failed display panel", (Throwable)e);
        }
    }

    @FXML
    void onMainMenuReloadClick(ActionEvent event) {
        UserAction.reloadCurrentChain().exceptionally(t -> {
            StareNotification.showWarn((String)"Failed to reload current chain", (Throwable)t);
            return null;
        });
    }

    @FXML
    void onMenuItemProjectSettings(ActionEvent event) {
        if (this.app.getProject() == null || this.app.getProject().getProjectFile() == null || !this.app.getProject().isLoadedFromFile()) {
            StareNotification.showWarn((String)"Unable to open chain settings: the current chain has not been loaded from file");
            return;
        }
        ((CompletableFuture)this.app.rqGetProjectSettings().thenAccept(projectSettings -> FxPlatform.RunFxThread(() -> {
            UIProjectSettings uiProjectSettings = new UIProjectSettings((ProjectSettings)projectSettings);
            uiProjectSettings.setCloseHandler(buttonId -> {
                switch (buttonId) {
                    case OK_DONE: {
                        this.app.getProject().getRoot().setGridSize(projectSettings.getGridSize());
                        this.app.getProject().getRoot().setGridAdjust(projectSettings.getGridAdjust());
                        this.app.rqSetProjectSettings((ProjectSettings)projectSettings).exceptionally(t -> {
                            StareNotification.showWarn((String)"Failed save chain settings", (Throwable)t);
                            return null;
                        });
                    }
                }
            });
            uiProjectSettings.showAndWait();
        }))).exceptionally(t -> {
            this.logger.log((Priority)Level.ERROR, (Object)"Failed get chain settings", t);
            StareNotification.showWarn((String)String.format("Cannot get chain settings: %s", t.getMessage()));
            return null;
        });
    }

    @FXML
    void onDebugModeIOSelected(ActionEvent event) {
        StareNotification.showWarn((String)"Not implemented");
    }

    @FXML
    void onDebugModePreviewSelected(ActionEvent event) {
        boolean previewNecessaryValueForPreviewMode = true;
        boolean allOutputsNecessaryValueForPreviewMode = false;
        this.changeDebugMode(true, false);
    }

    @FXML
    void onDebugModeAllSelected(ActionEvent event) {
        boolean previewNecessaryValueForAllMode = true;
        boolean allOutputsNecessaryValueForAllMode = true;
        this.changeDebugMode(true, true);
    }

    private void updateMenuItemDisableStatistic() {
    }

    private void updateMenuItemServerCacheCaption() {
        FxPlatform.RunFxThread(() -> {
            if (this.app.isEnableServerCache()) {
                this.miServerCache.setText("Disable server cache");
            } else {
                this.miServerCache.setText("Enable server cache");
            }
        });
    }

    private void updateMenuItemServerStatisticCaption() {
        FxPlatform.RunFxThread(() -> {
            if (this.app.isEnableServerStatistic()) {
                this.miServerStatistic.setText("Disable server statistic");
            } else {
                this.miServerStatistic.setText("Enable server statistic");
            }
        });
    }

    private void updateMenuItemInstanceModeCaption() {
        FxPlatform.RunFxThread(() -> {
            if (this.app.isInstanceMode()) {
                this.miInstanceMode.setText("Disable instance mode");
            } else {
                this.miInstanceMode.setText("Enable instance mode");
            }
        });
    }

    public static StareMainMenu getInstance() {
        if (instance == null) {
            instance = new StareMainMenu();
        }
        return instance;
    }

    private StareMainMenu() {
        try {
            URL url = this.getClass().getResource("/com/siams/cv/monitor/ui/menu/StareMainMenu.fxml");
            CustomFXMLLoader.loadElement((Object)this, (URL)url);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        this.subscribe();
    }

    private void initializeMenuStatusBarSettings() {
        this.informationOrMessages.getToggles().add((Object)this.miInformation);
        this.informationOrMessages.getToggles().add((Object)this.miMessages);
        AppPreference appPreference = AppPreference.getInstance();
        this.informationOrMessages.selectedToggleProperty().addListener(toggle -> appPreference.statusBar.setShowInformation(this.miInformation.equals(this.informationOrMessages.getSelectedToggle())));
        this.informationOrMessages.selectToggle((Toggle)(appPreference.statusBar.isShowInformation() ? this.miInformation : this.miMessages));
    }

    private void initializeMenuImport() {
        this.miImportChainConfig.setOnAction(action -> UserAction.importProjectConfiguration());
    }

    private void initializeMenuExport() {
        this.miExportChainConfig.setOnAction(action -> UserAction.exportProjectConfiguration());
        this.miImportChainConfigAs.setOnAction(action -> UserAction.exportProjectConfigurationAs());
    }

    private void initializeMenuItemShowInExplorer() {
        this.miShowInExplorer.setOnAction(e -> {
            File projectFile = App.getInstance().getProject().getProjectFile();
            App.resolveAbsolutePath(projectFile).ifPresent(file -> {
                try {
                    Desktop.getDesktop().open(file.getParentFile());
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            });
        });
    }

    private void initializeMenuTools() {
        this.menuTools.setOnShowing(event -> {
            this.menuCompareViewers.getItems().clear();
            this.menuCompareViewers.setDisable(true);
            ViewerModelStorage.getInstance().find(ViewerModel::getCreatedByUser, CompareViewerModel.class).forEach(compareViewerModel -> {
                MenuItem itemShow = new MenuItem(String.format("Show (Ctrl+%d)", compareViewerModel.getOrder()));
                itemShow.setOnAction(e -> UserAction.showCompareViewer(compareViewerModel.getOrder()));
                MenuItem itemRemove = new MenuItem("Remove");
                itemRemove.setOnAction(e -> UserAction.removeCompareViewer(compareViewerModel.getUuid()));
                Menu menuCompareViewer = new Menu(compareViewerModel.getTitle());
                menuCompareViewer.getItems().addAll((Object[])new MenuItem[]{itemShow, itemRemove});
                this.menuCompareViewers.getItems().add((Object)menuCompareViewer);
                this.menuCompareViewers.setDisable(false);
            });
        });
        ToggleGroup debugModeGroup = new ToggleGroup();
        this.rmiDebugModeIO.setToggleGroup(debugModeGroup);
        this.rmiDebugModePreview.setToggleGroup(debugModeGroup);
        this.rmiDebugModeAll.setToggleGroup(debugModeGroup);
        boolean enableServerPreview = this.app.isEnableServerPreview();
        boolean allOutputsNecessary = this.app.isAllOutputsNecessary();
        if (allOutputsNecessary) {
            debugModeGroup.selectToggle((Toggle)this.rmiDebugModeAll);
        } else if (enableServerPreview) {
            debugModeGroup.selectToggle((Toggle)this.rmiDebugModePreview);
        } else {
            debugModeGroup.selectToggle((Toggle)this.rmiDebugModeIO);
        }
        this.miServerPanel.setOnAction(action -> this.displayServerPanel());
    }

    private void initializeMenuRun() {
        this.miInterrupt.setOnAction(event -> UserAction.interruptChain(true));
        this.miStep.setOnAction(event -> UserAction.executeChainStep());
        this.miReset.setOnAction(event -> UserAction.resetChainStepIteration());
        this.miRun.setOnAction(event -> UserAction.executeChain());
    }

    private void initializeMenuItemExportFunctionsListLogs() {
        this.miExportFunctionsListLogs.setOnAction(event -> {
            File saveToFile;
            Path path;
            FileChooser fileChooser = new FileChooser();
            fileChooser.setInitialFileName("functions_list_logs.csv");
            FileChooser.ExtensionFilter extFilterCommaSeparator = new FileChooser.ExtensionFilter("Comma (,) separator file (.CSV)", new String[]{"*.csv"});
            FileChooser.ExtensionFilter extFilterTabSeparator = new FileChooser.ExtensionFilter("Tab (\\t) separator file (.CSV)", new String[]{"*.csv"});
            FileChooser.ExtensionFilter extFilterSemicolonSeparator = new FileChooser.ExtensionFilter("Semicolon (;) separator file (.CSV)", new String[]{"*.csv"});
            FileChooser.ExtensionFilter extFilterHtml = new FileChooser.ExtensionFilter("HTML table (.HTML)", new String[]{"*.html"});
            fileChooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{extFilterCommaSeparator, extFilterTabSeparator, extFilterSemicolonSeparator, extFilterHtml});
            String initialDirectory = this.getPreferredString("stare.exportFunctionsListLogs.initDir", "");
            if (!initialDirectory.isEmpty() && Files.exists(path = new File(initialDirectory).toPath(), new LinkOption[0])) {
                fileChooser.setInitialDirectory(path.toFile());
            }
            if ((saveToFile = fileChooser.showSaveDialog(null)) == null) {
                return;
            }
            this.putPreferredString("stare.exportFunctionsListLogs.initDir", saveToFile.getParentFile().getAbsolutePath());
            try {
                ObservableList<FunctionStatistic> statistics = FunctionsList.getInstance().getData();
                ExportFile export = null;
                FileChooser.ExtensionFilter selectedFilter = fileChooser.getSelectedExtensionFilter();
                if (selectedFilter == extFilterCommaSeparator || selectedFilter == extFilterTabSeparator || selectedFilter == extFilterSemicolonSeparator) {
                    ExportFunctionsListLogsCsv exportCsv;
                    export = exportCsv = new ExportFunctionsListLogsCsv((List<FunctionStatistic>)statistics);
                    if (selectedFilter == extFilterCommaSeparator) {
                        exportCsv.setDelimiter(",");
                    } else if (selectedFilter == extFilterSemicolonSeparator) {
                        exportCsv.setDelimiter(";");
                    } else {
                        exportCsv.setDelimiter("\t");
                    }
                } else if (selectedFilter == extFilterHtml) {
                    ExportFunctionsListLogsHtml exportHtml = new ExportFunctionsListLogsHtml((List<FunctionStatistic>)statistics);
                    export = exportHtml;
                    exportHtml.setHtmlTemplatePath("/com/siams/cv/monitor/export/ExportTemplateFunctionsListLog.html");
                }
                if (export != null) {
                    if (export.export(saveToFile)) {
                        StareNotification.showInfo((String)"Export successful");
                    } else {
                        String error = "Export failed";
                        this.logger.error((Object)"Export failed");
                        StareNotification.showWarn((String)"Export failed");
                    }
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        });
    }

    private void subscribe() {
        EventBus.getDefault().register((Object)this);
    }

    @Subscribe
    public void onStareMonitorStarted(StareMonitorStarted event) {
        this.updateMenuItemInstanceModeCaption();
        this.updateMenuItemServerCacheCaption();
        this.updateMenuItemDisableStatistic();
    }

    @Subscribe
    public void onStareMonitorClosing(StareMonitorClosing event) {
        this.savePreference();
        this.release();
    }

    @Subscribe
    public void onStareProjectSaved(StareProjectSaved event) {
        File stareProjectFile = event.getProject().getProjectFile();
        if (stareProjectFile != null) {
            Platform.runLater(() -> {
                this.addRecentFile(stareProjectFile);
                this.savePreference();
            });
        }
    }

    @Subscribe
    public void onStareProjectLoaded(StareProjectLoaded event) {
        File stareProjectFile = event.getProject().getProjectFile();
        if (stareProjectFile != null) {
            Platform.runLater(() -> {
                this.addRecentFile(stareProjectFile);
                this.savePreference();
            });
        }
    }

    private void initializeRecentFiles() {
        this.menuRecentFiles = new MenuRecentFiles(this.menuItemRecentFiles, 20, action -> {
            MenuItem item = (MenuItem)action.getSource();
            Path path = (Path)item.getUserData();
            if (!Files.exists(path, new LinkOption[0])) {
                StareNotification.showWarn((String)"File not found", (String)path.toAbsolutePath().toString());
            } else {
                UserAction.loadingStareProject(path.toFile()).exceptionally(t -> {
                    StareNotification.showWarn((String)"Failed to load recent chain", (Throwable)t);
                    return null;
                });
            }
        });
    }

    public void restorePreference() {
        try {
            for (int i = 19; i >= 0; --i) {
                String path = this.getPreferredString(String.format("recentFileName%d", i), "");
                if (path.trim().isEmpty()) continue;
                try {
                    this.menuRecentFiles.add((Object)Path.of(path, new String[0]));
                    continue;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            this.menuRecentFiles.buildMenuItems();
            AppPreference appPreference = AppPreference.getInstance();
            appPreference.statusBar.setShowInformation(this.miInformation.equals(this.informationOrMessages.getSelectedToggle()));
            ((Toggle)this.informationOrMessages.getToggles().get(0)).setSelected(appPreference.statusBar.isShowInformation());
        }
        catch (Throwable t) {
            this.logger.error((Object)"Restore preference error", t);
        }
    }

    public void savePreference() {
        int idx = 0;
        for (Path path : this.menuRecentFiles.getAll()) {
            if (!Files.exists(path, new LinkOption[0])) continue;
            this.putPreferredString(String.format("recentFileName%d", idx), path.toAbsolutePath().toString());
            this.logger.debug((Object)String.format("[%d] %s", idx, path.toString()));
            ++idx;
        }
    }

    private void changeDebugMode(boolean previewNecessary, boolean allOutputsNecessary) {
        this.app.setEnableServerPreview(previewNecessary);
        this.app.rqSetObjectProperty(this.app.getProject(), "__tmp.create_visible_result", previewNecessary);
        this.app.setAllOutputsNecessary(allOutputsNecessary);
        this.app.rqSetObjectProperty(this.app.getProject(), "__tmp.all_outputs_necessary", allOutputsNecessary);
    }

    private void addRecentFile(File recentFile) {
        this.menuRecentFiles.add((Object)recentFile.toPath());
        this.updateRecentFiles();
    }

    private void updateRecentFiles() {
        this.menuRecentFiles.buildMenuItems();
    }

    public Path getLeastRecentProject() {
        ObservableList items = this.menuItemRecentFiles.getItems();
        return items.isEmpty() ? Path.of("", new String[0]) : (Path)((MenuItem)items.get(0)).getUserData();
    }

    @Override
    public void release() {
        if (EventBus.getDefault().isRegistered((Object)this)) {
            EventBus.getDefault().unregister((Object)this);
        }
    }

    public void initialize(URL url, ResourceBundle resourceBundle) {
        this.menuCompareViewers.setDisable(true);
        this.menuDebugMode.setVisible(App.EXPERIMENTAL_FEATURES);
        this.miServerCache.setVisible(App.EXPERIMENTAL_FEATURES);
        this.miInstanceMode.setVisible(App.EXPERIMENTAL_FEATURES);
        this.miServerStatistic.setVisible(App.EXPERIMENTAL_FEATURES);
        this.miServerPanel.setVisible(App.EXPERIMENTAL_FEATURES);
        this.menuItemConnectionSettings.setVisible(App.EXPERIMENTAL_FEATURES);
        this.initializeRecentFiles();
        this.initializeMenuRun();
        this.initializeMenuItemExportFunctionsListLogs();
        this.initializeMenuTools();
        this.initializeMenuItemShowInExplorer();
        this.initializeMenuImport();
        this.initializeMenuExport();
        this.initializeMenuStatusBarSettings();
        this.restorePreference();
        this.updateRecentFiles();
    }
}

