/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.util;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.scijava.Context;

public final class Types {
    private Types() {
    }

    public static Class<?> load(String name) {
        return Types.load(name, null, true);
    }

    public static Class<?> load(String name, ClassLoader classLoader) {
        return Types.load(name, classLoader, true);
    }

    public static Class<?> load(String className, boolean quietly) {
        return Types.load(className, null, quietly);
    }

    public static Class<?> load(String name, ClassLoader classLoader, boolean quietly) {
        if (name.equals("Z") || name.equals("boolean")) {
            return Boolean.TYPE;
        }
        if (name.equals("B") || name.equals("byte")) {
            return Byte.TYPE;
        }
        if (name.equals("C") || name.equals("char")) {
            return Character.TYPE;
        }
        if (name.equals("D") || name.equals("double")) {
            return Double.TYPE;
        }
        if (name.equals("F") || name.equals("float")) {
            return Float.TYPE;
        }
        if (name.equals("I") || name.equals("int")) {
            return Integer.TYPE;
        }
        if (name.equals("J") || name.equals("long")) {
            return Long.TYPE;
        }
        if (name.equals("S") || name.equals("short")) {
            return Short.TYPE;
        }
        if (name.equals("V") || name.equals("void")) {
            return Void.TYPE;
        }
        String className = name.equals("string") ? "java.lang.String" : name;
        if (name.endsWith("[]")) {
            String elementClassName = name.substring(0, name.length() - 2);
            return Types.arrayOrNull(Types.load(elementClassName, classLoader));
        }
        if (name.startsWith("[L") && name.endsWith(";")) {
            String elementClassName = name.substring(2, name.length() - 1);
            return Types.arrayOrNull(Types.load(elementClassName, classLoader));
        }
        if (name.startsWith("[")) {
            String elementClassName = name.substring(1);
            return Types.arrayOrNull(Types.load(elementClassName, classLoader));
        }
        try {
            ClassLoader cl = classLoader != null ? classLoader : Context.getClassLoader();
            return cl.loadClass(className);
        }
        catch (Throwable t) {
            if (quietly) {
                return null;
            }
            throw Types.iae(t, "Cannot load class: " + className);
        }
    }

    public static URL location(Class<?> c) {
        return Types.location(c, true);
    }

    public static URL location(Class<?> c, boolean quietly) {
        String suffix;
        SecurityException cause = null;
        String why = null;
        try {
            CodeSource codeSource = c.getProtectionDomain().getCodeSource();
            if (codeSource != null) {
                URL location = codeSource.getLocation();
                if (location != null) {
                    return location;
                }
                why = "null code source location";
            } else {
                why = "null code source";
            }
        }
        catch (SecurityException exc) {
            cause = exc;
            why = "cannot access protection domain";
        }
        URL classResource = c.getResource(c.getSimpleName() + ".class");
        if (classResource == null) {
            if (quietly) {
                return null;
            }
            throw Types.iae(cause, "No class resource for class: " + Types.name(c), why);
        }
        String url = classResource.toString();
        if (!url.endsWith(suffix = c.getCanonicalName().replace('.', '/') + ".class")) {
            if (quietly) {
                return null;
            }
            throw Types.iae(cause, "Unsupported URL format: " + url, why);
        }
        String base = url.substring(0, url.length() - suffix.length());
        String path = base;
        if (path.startsWith("jar:")) {
            path = path.substring(4, path.length() - 2);
        }
        try {
            return new URL(path);
        }
        catch (MalformedURLException e) {
            if (quietly) {
                return null;
            }
            throw Types.iae(e, "Malformed URL", why);
        }
    }

    public static String name(Type t) {
        if (t instanceof Class) {
            Class c = (Class)t;
            return c.isArray() ? Types.name(Types.component(c)) + "[]" : c.getName();
        }
        return t.toString();
    }

    public static Class<?> raw(Type type) {
        if (type == null) {
            return null;
        }
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof GenericArrayType) {
            return Types.array(Types.raw(((GenericArrayType)type).getGenericComponentType()));
        }
        List<Class<?>> c = Types.raws(type);
        if (c == null || c.size() == 0) {
            return null;
        }
        return c.get(0);
    }

    public static List<Class<?>> raws(Type type) {
        if (type == null) {
            return null;
        }
        return GenericTypeReflector.getUpperBoundClassAndInterfaces(type);
    }

    public static boolean isBoolean(Class<?> type) {
        return type == Boolean.TYPE || Boolean.class.isAssignableFrom(type);
    }

    public static boolean isByte(Class<?> type) {
        return type == Byte.TYPE || Byte.class.isAssignableFrom(type);
    }

    public static boolean isCharacter(Class<?> type) {
        return type == Character.TYPE || Character.class.isAssignableFrom(type);
    }

    public static boolean isDouble(Class<?> type) {
        return type == Double.TYPE || Double.class.isAssignableFrom(type);
    }

    public static boolean isFloat(Class<?> type) {
        return type == Float.TYPE || Float.class.isAssignableFrom(type);
    }

    public static boolean isInteger(Class<?> type) {
        return type == Integer.TYPE || Integer.class.isAssignableFrom(type);
    }

    public static boolean isLong(Class<?> type) {
        return type == Long.TYPE || Long.class.isAssignableFrom(type);
    }

    public static boolean isShort(Class<?> type) {
        return type == Short.TYPE || Short.class.isAssignableFrom(type);
    }

    public static boolean isNumber(Class<?> type) {
        return Number.class.isAssignableFrom(type) || type == Byte.TYPE || type == Double.TYPE || type == Float.TYPE || type == Integer.TYPE || type == Long.TYPE || type == Short.TYPE;
    }

    public static boolean isText(Class<?> type) {
        return String.class.isAssignableFrom(type) || Types.isCharacter(type);
    }

    public static <T> Class<T> box(Class<T> type) {
        Class destType = type == Boolean.TYPE ? Boolean.class : (type == Byte.TYPE ? Byte.class : (type == Character.TYPE ? Character.class : (type == Double.TYPE ? Double.class : (type == Float.TYPE ? Float.class : (type == Integer.TYPE ? Integer.class : (type == Long.TYPE ? Long.class : (type == Short.TYPE ? Short.class : (type == Void.TYPE ? Void.class : type))))))));
        Class<Boolean> result = destType;
        return result;
    }

    public static <T> Class<T> unbox(Class<T> type) {
        Class<Object> destType = type == Boolean.class ? Boolean.TYPE : (type == Byte.class ? Byte.TYPE : (type == Character.class ? Character.TYPE : (type == Double.class ? Double.TYPE : (type == Float.class ? Float.TYPE : (type == Integer.class ? Integer.TYPE : (type == Long.class ? Long.TYPE : (type == Short.class ? Short.TYPE : (type == Void.class ? Void.TYPE : type))))))));
        Class<Boolean> result = destType;
        return result;
    }

    public static <T> T nullValue(Class<T> type) {
        Serializable defaultValue = type == Boolean.TYPE ? Boolean.valueOf(false) : (type == Byte.TYPE ? Byte.valueOf((byte)0) : (type == Character.TYPE ? (Serializable)Character.valueOf('\u0000') : (Serializable)(type == Double.TYPE ? (Number)0.0 : (Number)(type == Float.TYPE ? (Number)Float.valueOf(0.0f) : (Number)(type == Integer.TYPE ? (Number)0 : (Number)(type == Long.TYPE ? (Number)0L : (Number)(type == Short.TYPE ? Short.valueOf((short)0) : null)))))));
        Boolean result = defaultValue;
        return (T)result;
    }

    public static Field field(Class<?> c, String name) {
        if (c == null) {
            throw Types.iae("No such field: " + name);
        }
        try {
            return c.getDeclaredField(name);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return Types.field(c.getSuperclass(), name);
        }
    }

    public static Method method(Class<?> c, String name, Class<?> ... parameterTypes) {
        if (c == null) {
            throw Types.iae("No such field: " + name);
        }
        try {
            return c.getDeclaredMethod(name, parameterTypes);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return Types.method(c.getSuperclass(), name, parameterTypes);
        }
    }

    public static Class<?> array(Class<?> componentType) {
        if (componentType == null) {
            return null;
        }
        return Array.newInstance(componentType, 0).getClass();
    }

    public static Class<?> array(Class<?> componentType, int dim) {
        if (dim < 0) {
            throw Types.iae("Negative dimension");
        }
        if (dim == 0) {
            return componentType;
        }
        return Types.array(Types.array(componentType), dim - 1);
    }

    public static Type array(Type componentType) {
        if (componentType == null) {
            return null;
        }
        if (componentType instanceof Class) {
            return Types.array((Class)componentType);
        }
        return new TypeUtils.GenericArrayTypeImpl(componentType);
    }

    public static Type component(Type type) {
        if (type instanceof Class) {
            return ((Class)type).getComponentType();
        }
        if (type instanceof GenericArrayType) {
            return ((GenericArrayType)type).getGenericComponentType();
        }
        return null;
    }

    public static Type fieldType(Field field, Class<?> type) {
        Type wildType = GenericTypeReflector.addWildcardParameters(type);
        return GenericTypeReflector.getExactFieldType(field, wildType);
    }

    public static Type methodReturnType(Method method, Class<?> type) {
        Type wildType = GenericTypeReflector.addWildcardParameters(type);
        return GenericTypeReflector.getExactReturnType(method, wildType);
    }

    public static Type[] methodParamTypes(Method method, Class<?> type) {
        Type wildType = GenericTypeReflector.addWildcardParameters(type);
        return GenericTypeReflector.getExactParameterTypes(method, wildType);
    }

    public static Type param(Type type, Class<?> c, int no) {
        return GenericTypeReflector.getTypeParameter(type, c.getTypeParameters()[no]);
    }

    public static boolean isAssignable(Type source, Type target) {
        return TypeUtils.isAssignable(source, target);
    }

    public static boolean isInstance(Object obj, Class<?> dest) {
        if (dest == null) {
            return false;
        }
        return obj == null || dest.isInstance(obj);
    }

    public static <T> T cast(Object src, Class<T> dest) {
        if (!Types.isInstance(src, dest)) {
            return null;
        }
        Object result = src;
        return (T)result;
    }

    public static <T> T enumValue(String name, Class<T> dest) {
        T result;
        if (!dest.isEnum()) {
            throw Types.iae("Not an enum type: " + Types.name(dest));
        }
        T typedResult = result = Enum.valueOf(dest, name);
        return typedResult;
    }

    public static <T> T enumFromLabel(String label, Class<T> dest) {
        T[] values = dest.getEnumConstants();
        if (values == null) {
            throw Types.iae("Not an enum type: " + Types.name(dest));
        }
        for (T value : values) {
            if (!Objects.equals(label, value.toString())) continue;
            return value;
        }
        throw Types.iae("Enum class " + dest.getName() + " has no such label: " + label);
    }

    public static <T> T enumFromString(String s, Class<T> dest) {
        if (!dest.isEnum()) {
            throw Types.iae("Not an enum type: " + Types.name(dest));
        }
        try {
            return Types.enumValue(s, dest);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            try {
                return Types.enumFromLabel(s, dest);
            }
            catch (IllegalArgumentException illegalArgumentException2) {
                throw Types.iae("Enum class " + dest.getName() + " has no such value nor label: " + s);
            }
        }
    }

    public static ParameterizedType parameterize(Class<?> rawType, Type ... typeArgs) {
        return Types.parameterizeWithOwner(null, rawType, typeArgs);
    }

    public static ParameterizedType parameterizeWithOwner(Type ownerType, Class<?> rawType, Type ... typeArgs) {
        return TypeUtils.parameterizeWithOwner(ownerType, rawType, typeArgs);
    }

    public static WildcardType wildcard() {
        return Types.wildcard((Type)null, (Type)null);
    }

    public static WildcardType wildcard(Type upperBound, Type lowerBound) {
        return new TypeUtils.WildcardTypeImpl(upperBound, lowerBound);
    }

    public static WildcardType wildcard(Type[] upperBounds, Type[] lowerBounds) {
        return new TypeUtils.WildcardTypeImpl(upperBounds, lowerBounds);
    }

    public static boolean containsTypeVars(Type type) {
        return TypeUtils.containsTypeVariables(type);
    }

    public static Map<TypeVariable<?>, Type> args(Type type, Class<?> toClass) {
        return TypeUtils.getTypeArguments(type, toClass);
    }

    public static Map<TypeVariable<?>, Type> args(Class<?> c, ParameterizedType superType) {
        return TypeUtils.determineTypeArguments(c, superType);
    }

    public static final ParameterizedType parameterize(Class<?> raw, Map<TypeVariable<?>, Type> typeArgMappings) {
        return TypeUtils.parameterize(raw, typeArgMappings);
    }

    private static IllegalArgumentException iae(String ... s) {
        return Types.iae(null, s);
    }

    private static IllegalArgumentException iae(Throwable cause, String ... notes) {
        String s = String.join((CharSequence)", ", notes);
        IllegalArgumentException exc = new IllegalArgumentException(s);
        if (cause != null) {
            exc.initCause(cause);
        }
        throw exc;
    }

    private static Class<?> arrayOrNull(Class<?> componentType) {
        try {
            return Types.array(componentType);
        }
        catch (IllegalArgumentException exc) {
            return null;
        }
    }

    private static class VarMap {
        private final Map<TypeVariable<?>, Type> map = new HashMap();

        VarMap() {
        }

        void add(TypeVariable<?> variable, Type value) {
            this.map.put(variable, value);
        }

        void addAll(TypeVariable<?>[] variables, Type[] values) {
            assert (variables.length == values.length);
            for (int i = 0; i < variables.length; ++i) {
                this.map.put(variables[i], values[i]);
            }
        }

        Type map(Type type) {
            if (type instanceof Class) {
                return type;
            }
            if (type instanceof TypeVariable) {
                assert (this.map.containsKey(type));
                return this.map.get(type);
            }
            if (type instanceof ParameterizedType) {
                ParameterizedType pType = (ParameterizedType)type;
                Type ownerType = pType.getOwnerType() == null ? pType.getOwnerType() : this.map(pType.getOwnerType());
                return Types.parameterizeWithOwner(ownerType, (Class)pType.getRawType(), this.map(pType.getActualTypeArguments()));
            }
            if (type instanceof WildcardType) {
                WildcardType wType = (WildcardType)type;
                return new TypeUtils.WildcardTypeImpl(this.map(wType.getUpperBounds()), this.map(wType.getLowerBounds()));
            }
            if (type instanceof GenericArrayType) {
                return Types.array(this.map(((GenericArrayType)type).getGenericComponentType()));
            }
            throw new RuntimeException("not implemented: mapping " + type.getClass() + " (" + type + ")");
        }

        Type[] map(Type[] types) {
            Type[] result = new Type[types.length];
            for (int i = 0; i < types.length; ++i) {
                result[i] = this.map(types[i]);
            }
            return result;
        }
    }

    private static class CaptureTypeImpl
    implements CaptureType {
        private final WildcardType wildcard;
        private final TypeVariable<?> variable;
        private final Type[] lowerBounds;
        private Type[] upperBounds;

        public CaptureTypeImpl(WildcardType wildcard, TypeVariable<?> variable) {
            this.wildcard = wildcard;
            this.variable = variable;
            this.lowerBounds = wildcard.getLowerBounds();
        }

        void init(VarMap varMap) {
            ArrayList<Type> upperBoundsList = new ArrayList<Type>();
            upperBoundsList.addAll(Arrays.asList(varMap.map(this.variable.getBounds())));
            List<Type> wildcardUpperBounds = Arrays.asList(this.wildcard.getUpperBounds());
            if (wildcardUpperBounds.size() > 0 && wildcardUpperBounds.get(0) == Object.class) {
                upperBoundsList.addAll(wildcardUpperBounds.subList(1, wildcardUpperBounds.size()));
            } else {
                upperBoundsList.addAll(wildcardUpperBounds);
            }
            this.upperBounds = new Type[upperBoundsList.size()];
            upperBoundsList.toArray(this.upperBounds);
        }

        @Override
        public Type[] getLowerBounds() {
            return (Type[])this.lowerBounds.clone();
        }

        @Override
        public Type[] getUpperBounds() {
            assert (this.upperBounds != null);
            return (Type[])this.upperBounds.clone();
        }

        public String toString() {
            return "capture of " + this.wildcard;
        }
    }

    private static interface CaptureType
    extends Type {
        public Type[] getUpperBounds();

        public Type[] getLowerBounds();
    }

    private static class GenericTypeReflector {
        private static final Type UNBOUND_WILDCARD = new TypeUtils.WildcardTypeImpl(new Type[]{Object.class}, new Type[0]);

        private GenericTypeReflector() {
        }

        public static Class<?> erase(Type type) {
            if (type instanceof Class) {
                return (Class)type;
            }
            if (type instanceof ParameterizedType) {
                return (Class)((ParameterizedType)type).getRawType();
            }
            if (type instanceof TypeVariable) {
                TypeVariable tv = (TypeVariable)type;
                if (tv.getBounds().length == 0) {
                    return Object.class;
                }
                return GenericTypeReflector.erase(tv.getBounds()[0]);
            }
            if (type instanceof GenericArrayType) {
                GenericArrayType aType = (GenericArrayType)type;
                return Types.array(GenericTypeReflector.erase(aType.getGenericComponentType()));
            }
            throw new RuntimeException("not supported: " + type.getClass());
        }

        private static Type mapTypeParameters(Type toMapType, Type typeAndParams) {
            if (GenericTypeReflector.isMissingTypeParameters(typeAndParams)) {
                return GenericTypeReflector.erase(toMapType);
            }
            VarMap varMap = new VarMap();
            Type handlingTypeAndParams = typeAndParams;
            while (handlingTypeAndParams instanceof ParameterizedType) {
                ParameterizedType pType = (ParameterizedType)handlingTypeAndParams;
                Class clazz = (Class)pType.getRawType();
                varMap.addAll(clazz.getTypeParameters(), pType.getActualTypeArguments());
                handlingTypeAndParams = pType.getOwnerType();
            }
            return varMap.map(toMapType);
        }

        private static boolean isMissingTypeParameters(Type type) {
            if (type instanceof Class) {
                for (Class<?> clazz = (Class<?>)type; clazz != null; clazz = clazz.getEnclosingClass()) {
                    if (clazz.getTypeParameters().length == 0) continue;
                    return true;
                }
                return false;
            }
            if (type instanceof ParameterizedType) {
                return false;
            }
            throw new AssertionError((Object)("Unexpected type " + type.getClass()));
        }

        public static Type addWildcardParameters(Class<?> clazz) {
            if (clazz.isArray()) {
                return Types.array(GenericTypeReflector.addWildcardParameters(clazz.getComponentType()));
            }
            if (GenericTypeReflector.isMissingTypeParameters(clazz)) {
                TypeVariable<Class<?>>[] vars = clazz.getTypeParameters();
                Object[] arguments = new Type[vars.length];
                Arrays.fill(arguments, UNBOUND_WILDCARD);
                Type owner = clazz.getDeclaringClass() == null ? null : GenericTypeReflector.addWildcardParameters(clazz.getDeclaringClass());
                return Types.parameterizeWithOwner(owner, clazz, (Type[])arguments);
            }
            return clazz;
        }

        public static Type getExactSuperType(Type type, Class<?> searchClass) {
            if (type instanceof ParameterizedType || type instanceof Class || type instanceof GenericArrayType) {
                Class<?> clazz = GenericTypeReflector.erase(type);
                if (searchClass == clazz) {
                    return type;
                }
                if (!searchClass.isAssignableFrom(clazz)) {
                    return null;
                }
            }
            for (Type superType : GenericTypeReflector.getExactDirectSuperTypes(type)) {
                Type result = GenericTypeReflector.getExactSuperType(superType, searchClass);
                if (result == null) continue;
                return result;
            }
            return null;
        }

        public static Type getTypeParameter(Type type, TypeVariable<? extends Class<?>> variable) {
            Class<?> clazz = variable.getGenericDeclaration();
            Type superType = GenericTypeReflector.getExactSuperType(type, clazz);
            if (superType instanceof ParameterizedType) {
                int index = Arrays.asList(clazz.getTypeParameters()).indexOf(variable);
                return ((ParameterizedType)superType).getActualTypeArguments()[index];
            }
            return null;
        }

        public static boolean isSuperType(Type superType, Type subType) {
            if (superType instanceof ParameterizedType || superType instanceof Class || superType instanceof GenericArrayType) {
                Class<?> superClass = GenericTypeReflector.erase(superType);
                Type mappedSubType = GenericTypeReflector.getExactSuperType(GenericTypeReflector.capture(subType), superClass);
                if (mappedSubType == null) {
                    return false;
                }
                if (superType instanceof Class) {
                    return true;
                }
                if (mappedSubType instanceof Class) {
                    return true;
                }
                if (mappedSubType instanceof GenericArrayType) {
                    Type superComponentType = GenericTypeReflector.getArrayComponentType(superType);
                    assert (superComponentType != null);
                    Type mappedSubComponentType = GenericTypeReflector.getArrayComponentType(mappedSubType);
                    assert (mappedSubComponentType != null);
                    return GenericTypeReflector.isSuperType(superComponentType, mappedSubComponentType);
                }
                assert (mappedSubType instanceof ParameterizedType);
                ParameterizedType pMappedSubType = (ParameterizedType)mappedSubType;
                assert (pMappedSubType.getRawType() == superClass);
                ParameterizedType pSuperType = (ParameterizedType)superType;
                Type[] superTypeArgs = pSuperType.getActualTypeArguments();
                Type[] subTypeArgs = pMappedSubType.getActualTypeArguments();
                assert (superTypeArgs.length == subTypeArgs.length);
                for (int i = 0; i < superTypeArgs.length; ++i) {
                    if (GenericTypeReflector.contains(superTypeArgs[i], subTypeArgs[i])) continue;
                    return false;
                }
                return pSuperType.getOwnerType() == null || GenericTypeReflector.isSuperType(pSuperType.getOwnerType(), pMappedSubType.getOwnerType());
            }
            if (superType instanceof CaptureType) {
                if (superType.equals(subType)) {
                    return true;
                }
                for (Type lowerBound : ((CaptureType)superType).getLowerBounds()) {
                    if (!GenericTypeReflector.isSuperType(lowerBound, subType)) continue;
                    return true;
                }
                return false;
            }
            if (superType instanceof GenericArrayType) {
                return GenericTypeReflector.isArraySupertype(superType, subType);
            }
            throw new RuntimeException("not implemented: " + superType.getClass());
        }

        private static boolean isArraySupertype(Type arraySuperType, Type subType) {
            Type superTypeComponent = GenericTypeReflector.getArrayComponentType(arraySuperType);
            assert (superTypeComponent != null);
            Type subTypeComponent = GenericTypeReflector.getArrayComponentType(subType);
            if (subTypeComponent == null) {
                return false;
            }
            return GenericTypeReflector.isSuperType(superTypeComponent, subTypeComponent);
        }

        public static Type getArrayComponentType(Type type) {
            if (type instanceof Class) {
                Class clazz = (Class)type;
                return clazz.getComponentType();
            }
            if (type instanceof GenericArrayType) {
                GenericArrayType aType = (GenericArrayType)type;
                return aType.getGenericComponentType();
            }
            return null;
        }

        private static boolean contains(Type containingType, Type containedType) {
            if (containingType instanceof WildcardType) {
                WildcardType wContainingType = (WildcardType)containingType;
                for (Type upperBound : wContainingType.getUpperBounds()) {
                    if (GenericTypeReflector.isSuperType(upperBound, containedType)) continue;
                    return false;
                }
                for (Type lowerBound : wContainingType.getLowerBounds()) {
                    if (GenericTypeReflector.isSuperType(containedType, lowerBound)) continue;
                    return false;
                }
                return true;
            }
            return containingType.equals(containedType);
        }

        private static Type[] getExactDirectSuperTypes(Type type) {
            if (type instanceof ParameterizedType || type instanceof Class) {
                int resultIndex;
                Type[] result;
                Class clazz;
                if (type instanceof ParameterizedType) {
                    clazz = (Class)((ParameterizedType)type).getRawType();
                } else {
                    clazz = (Class)type;
                    if (clazz.isArray()) {
                        return GenericTypeReflector.getArrayExactDirectSuperTypes(clazz);
                    }
                }
                Type[] superInterfaces = clazz.getGenericInterfaces();
                Type superClass = clazz.getGenericSuperclass();
                if (superClass == null) {
                    result = new Type[superInterfaces.length];
                    resultIndex = 0;
                } else {
                    result = new Type[superInterfaces.length + 1];
                    resultIndex = 1;
                    result[0] = GenericTypeReflector.mapTypeParameters(superClass, type);
                }
                for (Type superInterface : superInterfaces) {
                    result[resultIndex++] = GenericTypeReflector.mapTypeParameters(superInterface, type);
                }
                return result;
            }
            if (type instanceof TypeVariable) {
                TypeVariable tv = (TypeVariable)type;
                return tv.getBounds();
            }
            if (type instanceof WildcardType) {
                return ((WildcardType)type).getUpperBounds();
            }
            if (type instanceof CaptureType) {
                return ((CaptureType)type).getUpperBounds();
            }
            if (type instanceof GenericArrayType) {
                return GenericTypeReflector.getArrayExactDirectSuperTypes(type);
            }
            throw new RuntimeException("not implemented type: " + type);
        }

        private static Type[] getArrayExactDirectSuperTypes(Type arrayType) {
            Type[] result;
            int resultIndex;
            Type typeComponent = GenericTypeReflector.getArrayComponentType(arrayType);
            if (typeComponent instanceof Class && ((Class)typeComponent).isPrimitive()) {
                resultIndex = 0;
                result = new Type[3];
            } else {
                Type[] componentSupertypes = GenericTypeReflector.getExactDirectSuperTypes(typeComponent);
                result = new Type[componentSupertypes.length + 3];
                for (resultIndex = 0; resultIndex < componentSupertypes.length; ++resultIndex) {
                    result[resultIndex] = Types.array(componentSupertypes[resultIndex]);
                }
            }
            result[resultIndex++] = Object.class;
            result[resultIndex++] = Cloneable.class;
            result[resultIndex++] = Serializable.class;
            return result;
        }

        public static Type getExactReturnType(Method m, Type type) {
            Type returnType = m.getGenericReturnType();
            Type exactDeclaringType = GenericTypeReflector.getExactSuperType(GenericTypeReflector.capture(type), m.getDeclaringClass());
            if (exactDeclaringType == null) {
                throw new IllegalArgumentException("The method " + m + " is not a member of type " + type);
            }
            return GenericTypeReflector.mapTypeParameters(returnType, exactDeclaringType);
        }

        public static Type getExactFieldType(Field f, Type type) {
            Type returnType = f.getGenericType();
            Type exactDeclaringType = GenericTypeReflector.getExactSuperType(GenericTypeReflector.capture(type), f.getDeclaringClass());
            if (exactDeclaringType == null) {
                throw new IllegalArgumentException("The field " + f + " is not a member of type " + type);
            }
            return GenericTypeReflector.mapTypeParameters(returnType, exactDeclaringType);
        }

        public static Type[] getExactParameterTypes(Method m, Type type) {
            Type[] parameterTypes = m.getGenericParameterTypes();
            Type exactDeclaringType = GenericTypeReflector.getExactSuperType(GenericTypeReflector.capture(type), m.getDeclaringClass());
            if (exactDeclaringType == null) {
                throw new IllegalArgumentException("The method " + m + " is not a member of type " + type);
            }
            Type[] result = new Type[parameterTypes.length];
            for (int i = 0; i < parameterTypes.length; ++i) {
                result[i] = GenericTypeReflector.mapTypeParameters(parameterTypes[i], exactDeclaringType);
            }
            return result;
        }

        public static Type capture(Type type) {
            VarMap varMap = new VarMap();
            ArrayList<CaptureTypeImpl> toInit = new ArrayList<CaptureTypeImpl>();
            if (type instanceof ParameterizedType) {
                ParameterizedType pType = (ParameterizedType)type;
                Class clazz = (Class)pType.getRawType();
                Type[] arguments = pType.getActualTypeArguments();
                TypeVariable<Class<T>>[] vars = clazz.getTypeParameters();
                Type[] capturedArguments = new Type[arguments.length];
                assert (arguments.length == vars.length);
                for (int i = 0; i < arguments.length; ++i) {
                    Type argument = arguments[i];
                    if (argument instanceof WildcardType) {
                        CaptureTypeImpl captured = new CaptureTypeImpl((WildcardType)argument, vars[i]);
                        argument = captured;
                        toInit.add(captured);
                    }
                    capturedArguments[i] = argument;
                    varMap.add(vars[i], argument);
                }
                for (CaptureTypeImpl captured : toInit) {
                    captured.init(varMap);
                }
                Type ownerType = pType.getOwnerType() == null ? null : GenericTypeReflector.capture(pType.getOwnerType());
                return Types.parameterizeWithOwner(ownerType, clazz, capturedArguments);
            }
            return type;
        }

        public static List<Class<?>> getUpperBoundClassAndInterfaces(Type type) {
            LinkedHashSet result = new LinkedHashSet();
            GenericTypeReflector.buildUpperBoundClassAndInterfaces(type, result);
            return new ArrayList(result);
        }

        private static void buildUpperBoundClassAndInterfaces(Type type, Set<Class<?>> result) {
            if (type instanceof ParameterizedType || type instanceof Class) {
                result.add(GenericTypeReflector.erase(type));
                return;
            }
            for (Type superType : GenericTypeReflector.getExactDirectSuperTypes(type)) {
                GenericTypeReflector.buildUpperBoundClassAndInterfaces(superType, result);
            }
        }
    }

    private static class TypeUtils {
        public static final WildcardType WILDCARD_ALL = TypeUtils.wildcardType().withUpperBounds(new Type[]{Object.class}).build();
        private static final String DEFAULT_IS_NULL_EX_MESSAGE = "The validated object is null";
        private static final String DEFAULT_NO_NULL_ELEMENTS_ARRAY_EX_MESSAGE = "The validated array contains null element at index: %d";
        private static final String DEFAULT_NOT_EMPTY_ARRAY_EX_MESSAGE = "The validated array is empty";

        private TypeUtils() {
        }

        public static boolean isAssignable(Type type, Type toType) {
            if (toType == null) {
                throw new NullPointerException("Destination type is null");
            }
            return TypeUtils.isAssignable(type, toType, null);
        }

        private static boolean isAssignable(Type type, Type toType, Map<TypeVariable<?>, Type> typeVarAssigns) {
            if (toType == null || toType instanceof Class) {
                return TypeUtils.isAssignable(type, (Class)toType);
            }
            if (toType instanceof ParameterizedType) {
                return TypeUtils.isAssignable(type, (ParameterizedType)toType, typeVarAssigns);
            }
            if (toType instanceof GenericArrayType) {
                return TypeUtils.isAssignable(type, (GenericArrayType)toType, typeVarAssigns);
            }
            if (toType instanceof WildcardType) {
                return TypeUtils.isAssignable(type, (WildcardType)toType, typeVarAssigns);
            }
            if (toType instanceof TypeVariable) {
                return TypeUtils.isAssignable(type, (TypeVariable)toType, typeVarAssigns);
            }
            throw new IllegalStateException("found an unhandled type: " + toType);
        }

        private static boolean isAssignable(Type type, Class<?> toClass) {
            if (type == null) {
                return toClass == null || !toClass.isPrimitive();
            }
            if (toClass == null) {
                return false;
            }
            if (toClass.equals(type)) {
                return true;
            }
            if (type instanceof Class) {
                return toClass.isAssignableFrom((Class)type);
            }
            if (type instanceof ParameterizedType) {
                return TypeUtils.isAssignable(TypeUtils.getRawType((ParameterizedType)type), toClass);
            }
            if (type instanceof TypeVariable) {
                for (Type bound : ((TypeVariable)type).getBounds()) {
                    if (!TypeUtils.isAssignable(bound, toClass)) continue;
                    return true;
                }
                return false;
            }
            if (type instanceof GenericArrayType) {
                return toClass.equals(Object.class) || toClass.isArray() && TypeUtils.isAssignable(((GenericArrayType)type).getGenericComponentType(), toClass.getComponentType());
            }
            if (type instanceof WildcardType) {
                return false;
            }
            throw new IllegalStateException("found an unhandled type: " + type);
        }

        private static boolean isAssignable(Type type, ParameterizedType toParameterizedType, Map<TypeVariable<?>, Type> typeVarAssigns) {
            if (type == null) {
                return true;
            }
            if (toParameterizedType == null) {
                return false;
            }
            if (toParameterizedType.equals(type)) {
                return true;
            }
            Class<?> toClass = TypeUtils.getRawType(toParameterizedType);
            Map<TypeVariable<?>, Type> fromTypeVarAssigns = TypeUtils.getTypeArguments(type, toClass, null);
            if (fromTypeVarAssigns == null) {
                return false;
            }
            if (fromTypeVarAssigns.isEmpty()) {
                return true;
            }
            Map<TypeVariable<?>, Type> toTypeVarAssigns = TypeUtils.getTypeArguments(toParameterizedType, toClass, typeVarAssigns);
            for (TypeVariable<?> var : toTypeVarAssigns.keySet()) {
                Type toTypeArg = TypeUtils.unrollVariableAssignments(var, toTypeVarAssigns);
                Type fromTypeArg = TypeUtils.unrollVariableAssignments(var, fromTypeVarAssigns);
                if (fromTypeArg == null || fromTypeArg.equals(toTypeArg) || toTypeArg instanceof WildcardType && TypeUtils.isAssignable(fromTypeArg, toTypeArg, typeVarAssigns)) continue;
                return false;
            }
            return true;
        }

        private static Type unrollVariableAssignments(TypeVariable<?> var, Map<TypeVariable<?>, Type> typeVarAssigns) {
            Type result;
            while ((result = typeVarAssigns.get(var)) instanceof TypeVariable && !result.equals(var)) {
                var = (TypeVariable)result;
            }
            return result;
        }

        private static boolean isAssignable(Type type, GenericArrayType toGenericArrayType, Map<TypeVariable<?>, Type> typeVarAssigns) {
            if (type == null) {
                return true;
            }
            if (toGenericArrayType == null) {
                return false;
            }
            if (toGenericArrayType.equals(type)) {
                return true;
            }
            Type toComponentType = toGenericArrayType.getGenericComponentType();
            if (type instanceof Class) {
                Class cls = (Class)type;
                return cls.isArray() && TypeUtils.isAssignable(cls.getComponentType(), toComponentType, typeVarAssigns);
            }
            if (type instanceof GenericArrayType) {
                return TypeUtils.isAssignable(((GenericArrayType)type).getGenericComponentType(), toComponentType, typeVarAssigns);
            }
            if (type instanceof WildcardType) {
                for (Type bound : TypeUtils.getImplicitUpperBounds((WildcardType)type)) {
                    if (!TypeUtils.isAssignable(bound, toGenericArrayType)) continue;
                    return true;
                }
                return false;
            }
            if (type instanceof TypeVariable) {
                for (Type bound : TypeUtils.getImplicitBounds((TypeVariable)type)) {
                    if (!TypeUtils.isAssignable(bound, toGenericArrayType)) continue;
                    return true;
                }
                return false;
            }
            if (type instanceof ParameterizedType) {
                return false;
            }
            throw new IllegalStateException("found an unhandled type: " + type);
        }

        private static boolean isAssignable(Type type, WildcardType toWildcardType, Map<TypeVariable<?>, Type> typeVarAssigns) {
            if (type == null) {
                return true;
            }
            if (toWildcardType == null) {
                return false;
            }
            if (toWildcardType.equals(type)) {
                return true;
            }
            Type[] toUpperBounds = TypeUtils.getImplicitUpperBounds(toWildcardType);
            Type[] toLowerBounds = TypeUtils.getImplicitLowerBounds(toWildcardType);
            if (type instanceof WildcardType) {
                WildcardType wildcardType = (WildcardType)type;
                Type[] upperBounds = TypeUtils.getImplicitUpperBounds(wildcardType);
                Type[] lowerBounds = TypeUtils.getImplicitLowerBounds(wildcardType);
                for (Type toBound : toUpperBounds) {
                    toBound = TypeUtils.substituteTypeVariables(toBound, typeVarAssigns);
                    for (Type bound : upperBounds) {
                        if (TypeUtils.isAssignable(bound, toBound, typeVarAssigns)) continue;
                        return false;
                    }
                }
                for (Type toBound : toLowerBounds) {
                    toBound = TypeUtils.substituteTypeVariables(toBound, typeVarAssigns);
                    for (Type bound : lowerBounds) {
                        if (TypeUtils.isAssignable(toBound, bound, typeVarAssigns)) continue;
                        return false;
                    }
                }
                return true;
            }
            for (Type toBound : toUpperBounds) {
                if (TypeUtils.isAssignable(type, TypeUtils.substituteTypeVariables(toBound, typeVarAssigns), typeVarAssigns)) continue;
                return false;
            }
            for (Type toBound : toLowerBounds) {
                if (TypeUtils.isAssignable(TypeUtils.substituteTypeVariables(toBound, typeVarAssigns), type, typeVarAssigns)) continue;
                return false;
            }
            return true;
        }

        private static boolean isAssignable(Type type, TypeVariable<?> toTypeVariable, Map<TypeVariable<?>, Type> typeVarAssigns) {
            if (type == null) {
                return true;
            }
            if (toTypeVariable == null) {
                return false;
            }
            if (toTypeVariable.equals(type)) {
                return true;
            }
            if (type instanceof TypeVariable) {
                Type[] bounds;
                for (Type bound : bounds = TypeUtils.getImplicitBounds((TypeVariable)type)) {
                    if (!TypeUtils.isAssignable(bound, toTypeVariable, typeVarAssigns)) continue;
                    return true;
                }
            }
            if (type instanceof Class || type instanceof ParameterizedType || type instanceof GenericArrayType || type instanceof WildcardType) {
                return false;
            }
            throw new IllegalStateException("found an unhandled type: " + type);
        }

        private static Type substituteTypeVariables(Type type, Map<TypeVariable<?>, Type> typeVarAssigns) {
            if (type instanceof TypeVariable && typeVarAssigns != null) {
                Type replacementType = typeVarAssigns.get(type);
                if (replacementType == null) {
                    throw new IllegalArgumentException("missing assignment type for type variable " + type);
                }
                return replacementType;
            }
            return type;
        }

        public static Map<TypeVariable<?>, Type> getTypeArguments(ParameterizedType type) {
            return TypeUtils.getTypeArguments(type, TypeUtils.getRawType(type), null);
        }

        public static Map<TypeVariable<?>, Type> getTypeArguments(Type type, Class<?> toClass) {
            return TypeUtils.getTypeArguments(type, toClass, null);
        }

        private static Map<TypeVariable<?>, Type> getTypeArguments(Type type, Class<?> toClass, Map<TypeVariable<?>, Type> subtypeVarAssigns) {
            if (type instanceof Class) {
                return TypeUtils.getTypeArguments((Class)type, toClass, subtypeVarAssigns);
            }
            if (type instanceof ParameterizedType) {
                return TypeUtils.getTypeArguments((ParameterizedType)type, toClass, subtypeVarAssigns);
            }
            if (type instanceof GenericArrayType) {
                return TypeUtils.getTypeArguments(((GenericArrayType)type).getGenericComponentType(), toClass.isArray() ? toClass.getComponentType() : toClass, subtypeVarAssigns);
            }
            if (type instanceof WildcardType) {
                for (Type bound : TypeUtils.getImplicitUpperBounds((WildcardType)type)) {
                    if (!TypeUtils.isAssignable(bound, toClass)) continue;
                    return TypeUtils.getTypeArguments(bound, toClass, subtypeVarAssigns);
                }
                return null;
            }
            if (type instanceof TypeVariable) {
                for (Type bound : TypeUtils.getImplicitBounds((TypeVariable)type)) {
                    if (!TypeUtils.isAssignable(bound, toClass)) continue;
                    return TypeUtils.getTypeArguments(bound, toClass, subtypeVarAssigns);
                }
                return null;
            }
            throw new IllegalStateException("found an unhandled type: " + type);
        }

        private static Map<TypeVariable<?>, Type> getTypeArguments(ParameterizedType parameterizedType, Class<?> toClass, Map<TypeVariable<?>, Type> subtypeVarAssigns) {
            HashMap<TypeVariable<?>, Type> typeVarAssigns;
            Class<?> cls = TypeUtils.getRawType(parameterizedType);
            if (!TypeUtils.isAssignable(cls, toClass)) {
                return null;
            }
            Type ownerType = parameterizedType.getOwnerType();
            if (ownerType instanceof ParameterizedType) {
                ParameterizedType parameterizedOwnerType = (ParameterizedType)ownerType;
                typeVarAssigns = TypeUtils.getTypeArguments(parameterizedOwnerType, TypeUtils.getRawType(parameterizedOwnerType), subtypeVarAssigns);
            } else {
                typeVarAssigns = subtypeVarAssigns == null ? new HashMap() : new HashMap(subtypeVarAssigns);
            }
            Type[] typeArgs = parameterizedType.getActualTypeArguments();
            TypeVariable<Class<?>>[] typeParams = cls.getTypeParameters();
            for (int i = 0; i < typeParams.length; ++i) {
                Type typeArg = typeArgs[i];
                typeVarAssigns.put(typeParams[i], typeVarAssigns.containsKey(typeArg) ? (Type)typeVarAssigns.get(typeArg) : typeArg);
            }
            if (toClass.equals(cls)) {
                return typeVarAssigns;
            }
            return TypeUtils.getTypeArguments(TypeUtils.getClosestParentType(cls, toClass), toClass, typeVarAssigns);
        }

        private static Map<TypeVariable<?>, Type> getTypeArguments(Class<?> cls, Class<?> toClass, Map<TypeVariable<?>, Type> subtypeVarAssigns) {
            HashMap typeVarAssigns;
            if (!TypeUtils.isAssignable(cls, toClass)) {
                return null;
            }
            if (cls.isPrimitive()) {
                if (toClass.isPrimitive()) {
                    return new HashMap();
                }
                cls = Types.box(cls);
            }
            HashMap hashMap = typeVarAssigns = subtypeVarAssigns == null ? new HashMap() : new HashMap(subtypeVarAssigns);
            if (toClass.equals(cls)) {
                return typeVarAssigns;
            }
            return TypeUtils.getTypeArguments(TypeUtils.getClosestParentType(cls, toClass), toClass, typeVarAssigns);
        }

        public static Map<TypeVariable<?>, Type> determineTypeArguments(Class<?> cls, ParameterizedType superType) {
            TypeUtils.validateNotNull(cls, "cls is null", new Object[0]);
            TypeUtils.validateNotNull(superType, "superType is null", new Object[0]);
            Class<?> superClass = TypeUtils.getRawType(superType);
            if (!TypeUtils.isAssignable(cls, superClass)) {
                return null;
            }
            if (cls.equals(superClass)) {
                return TypeUtils.getTypeArguments(superType, superClass, null);
            }
            Type midType = TypeUtils.getClosestParentType(cls, superClass);
            if (midType instanceof Class) {
                return TypeUtils.determineTypeArguments((Class)midType, superType);
            }
            ParameterizedType midParameterizedType = (ParameterizedType)midType;
            Class<?> midClass = TypeUtils.getRawType(midParameterizedType);
            Map<TypeVariable<?>, Type> typeVarAssigns = TypeUtils.determineTypeArguments(midClass, superType);
            TypeUtils.mapTypeVariablesToArguments(cls, midParameterizedType, typeVarAssigns);
            return typeVarAssigns;
        }

        private static <T> void mapTypeVariablesToArguments(Class<T> cls, ParameterizedType parameterizedType, Map<TypeVariable<?>, Type> typeVarAssigns) {
            Type ownerType = parameterizedType.getOwnerType();
            if (ownerType instanceof ParameterizedType) {
                TypeUtils.mapTypeVariablesToArguments(cls, (ParameterizedType)ownerType, typeVarAssigns);
            }
            Type[] typeArgs = parameterizedType.getActualTypeArguments();
            TypeVariable<Class<?>>[] typeVars = TypeUtils.getRawType(parameterizedType).getTypeParameters();
            List<TypeVariable<Class<T>>> typeVarList = Arrays.asList(cls.getTypeParameters());
            for (int i = 0; i < typeArgs.length; ++i) {
                TypeVariable<Class<?>> typeVar = typeVars[i];
                Type typeArg = typeArgs[i];
                if (!typeVarList.contains(typeArg) || !typeVarAssigns.containsKey(typeVar)) continue;
                typeVarAssigns.put((TypeVariable)typeArg, typeVarAssigns.get(typeVar));
            }
        }

        private static Type getClosestParentType(Class<?> cls, Class<?> superClass) {
            if (superClass.isInterface()) {
                Type[] interfaceTypes = cls.getGenericInterfaces();
                Type genericInterface = null;
                for (Type midType : interfaceTypes) {
                    Class midClass = null;
                    if (midType instanceof ParameterizedType) {
                        midClass = TypeUtils.getRawType((ParameterizedType)midType);
                    } else if (midType instanceof Class) {
                        midClass = (Class)midType;
                    } else {
                        throw new IllegalStateException("Unexpected generic interface type found: " + midType);
                    }
                    if (!TypeUtils.isAssignable((Type)midClass, superClass) || !TypeUtils.isAssignable(genericInterface, (Type)midClass)) continue;
                    genericInterface = midType;
                }
                if (genericInterface != null) {
                    return genericInterface;
                }
            }
            return cls.getGenericSuperclass();
        }

        public static boolean isInstance(Object value, Type type) {
            if (type == null) {
                return false;
            }
            return value == null ? !(type instanceof Class) || !((Class)type).isPrimitive() : TypeUtils.isAssignable(value.getClass(), type, null);
        }

        public static Type[] normalizeUpperBounds(Type[] bounds) {
            TypeUtils.validateNotNull(bounds, "null value specified for bounds array", new Object[0]);
            if (bounds.length < 2) {
                return bounds;
            }
            HashSet<Type> types = new HashSet<Type>(bounds.length);
            for (Type type1 : bounds) {
                boolean subtypeFound = false;
                for (Type type2 : bounds) {
                    if (type1 == type2 || !TypeUtils.isAssignable(type2, type1, null)) continue;
                    subtypeFound = true;
                    break;
                }
                if (subtypeFound) continue;
                types.add(type1);
            }
            return types.toArray(new Type[types.size()]);
        }

        public static Type[] getImplicitBounds(TypeVariable<?> typeVariable) {
            Type[] typeArray;
            TypeUtils.validateNotNull(typeVariable, "typeVariable is null", new Object[0]);
            Type[] bounds = typeVariable.getBounds();
            if (bounds.length == 0) {
                Type[] typeArray2 = new Type[1];
                typeArray = typeArray2;
                typeArray2[0] = Object.class;
            } else {
                typeArray = TypeUtils.normalizeUpperBounds(bounds);
            }
            return typeArray;
        }

        public static Type[] getImplicitUpperBounds(WildcardType wildcardType) {
            Type[] typeArray;
            TypeUtils.validateNotNull(wildcardType, "wildcardType is null", new Object[0]);
            Type[] bounds = wildcardType.getUpperBounds();
            if (bounds.length == 0) {
                Type[] typeArray2 = new Type[1];
                typeArray = typeArray2;
                typeArray2[0] = Object.class;
            } else {
                typeArray = TypeUtils.normalizeUpperBounds(bounds);
            }
            return typeArray;
        }

        public static Type[] getImplicitLowerBounds(WildcardType wildcardType) {
            Type[] typeArray;
            TypeUtils.validateNotNull(wildcardType, "wildcardType is null", new Object[0]);
            Type[] bounds = wildcardType.getLowerBounds();
            if (bounds.length == 0) {
                Type[] typeArray2 = new Type[1];
                typeArray = typeArray2;
                typeArray2[0] = null;
            } else {
                typeArray = bounds;
            }
            return typeArray;
        }

        public static boolean typesSatisfyVariables(Map<TypeVariable<?>, Type> typeVarAssigns) {
            TypeUtils.validateNotNull(typeVarAssigns, "typeVarAssigns is null", new Object[0]);
            for (Map.Entry<TypeVariable<?>, Type> entry : typeVarAssigns.entrySet()) {
                TypeVariable<?> typeVar = entry.getKey();
                Type type = entry.getValue();
                for (Type bound : TypeUtils.getImplicitBounds(typeVar)) {
                    if (TypeUtils.isAssignable(type, TypeUtils.substituteTypeVariables(bound, typeVarAssigns), typeVarAssigns)) continue;
                    return false;
                }
            }
            return true;
        }

        private static Class<?> getRawType(ParameterizedType parameterizedType) {
            Type rawType = parameterizedType.getRawType();
            if (!(rawType instanceof Class)) {
                throw new IllegalStateException("Wait... What!? Type of rawType: " + rawType);
            }
            return (Class)rawType;
        }

        public static Class<?> getRawType(Type type, Type assigningType) {
            if (type instanceof Class) {
                return (Class)type;
            }
            if (type instanceof ParameterizedType) {
                return TypeUtils.getRawType((ParameterizedType)type);
            }
            if (type instanceof TypeVariable) {
                if (assigningType == null) {
                    return null;
                }
                Object genericDeclaration = ((TypeVariable)type).getGenericDeclaration();
                if (!(genericDeclaration instanceof Class)) {
                    return null;
                }
                Map<TypeVariable<?>, Type> typeVarAssigns = TypeUtils.getTypeArguments(assigningType, (Class)genericDeclaration);
                if (typeVarAssigns == null) {
                    return null;
                }
                Type typeArgument = typeVarAssigns.get(type);
                if (typeArgument == null) {
                    return null;
                }
                return TypeUtils.getRawType(typeArgument, assigningType);
            }
            if (type instanceof GenericArrayType) {
                Class<?> rawComponentType = TypeUtils.getRawType(((GenericArrayType)type).getGenericComponentType(), assigningType);
                return Types.array(rawComponentType);
            }
            if (type instanceof WildcardType) {
                return null;
            }
            throw new IllegalArgumentException("unknown type: " + type);
        }

        public static boolean isArrayType(Type type) {
            return type instanceof GenericArrayType || type instanceof Class && ((Class)type).isArray();
        }

        public static Type getArrayComponentType(Type type) {
            if (type instanceof Class) {
                Class clazz = (Class)type;
                return clazz.isArray() ? clazz.getComponentType() : null;
            }
            if (type instanceof GenericArrayType) {
                return ((GenericArrayType)type).getGenericComponentType();
            }
            return null;
        }

        public static Type unrollVariables(Map<TypeVariable<?>, Type> typeArguments, Type type) {
            if (typeArguments == null) {
                typeArguments = Collections.emptyMap();
            }
            if (TypeUtils.containsTypeVariables(type)) {
                if (type instanceof TypeVariable) {
                    return TypeUtils.unrollVariables(typeArguments, typeArguments.get(type));
                }
                if (type instanceof ParameterizedType) {
                    Map<TypeVariable<?>, Type> parameterizedTypeArguments;
                    ParameterizedType p = (ParameterizedType)type;
                    if (p.getOwnerType() == null) {
                        parameterizedTypeArguments = typeArguments;
                    } else {
                        parameterizedTypeArguments = new HashMap(typeArguments);
                        parameterizedTypeArguments.putAll(TypeUtils.getTypeArguments(p));
                    }
                    Type[] args = p.getActualTypeArguments();
                    for (int i = 0; i < args.length; ++i) {
                        Type unrolled = TypeUtils.unrollVariables(parameterizedTypeArguments, args[i]);
                        if (unrolled == null) continue;
                        args[i] = unrolled;
                    }
                    return TypeUtils.parameterizeWithOwner(p.getOwnerType(), (Class)p.getRawType(), args);
                }
                if (type instanceof WildcardType) {
                    WildcardType wild = (WildcardType)type;
                    return TypeUtils.wildcardType().withUpperBounds(TypeUtils.unrollBounds(typeArguments, wild.getUpperBounds())).withLowerBounds(TypeUtils.unrollBounds(typeArguments, wild.getLowerBounds())).build();
                }
            }
            return type;
        }

        private static Type[] unrollBounds(Map<TypeVariable<?>, Type> typeArguments, Type[] bounds) {
            ArrayList<Type> result = new ArrayList<Type>();
            for (Type bound : bounds) {
                Type unrolled = TypeUtils.unrollVariables(typeArguments, bound);
                if (unrolled == null) continue;
                result.add(unrolled);
            }
            return result.toArray(new Type[result.size()]);
        }

        public static boolean containsTypeVariables(Type type) {
            if (type instanceof TypeVariable) {
                return true;
            }
            if (type instanceof Class) {
                return ((Class)type).getTypeParameters().length > 0;
            }
            if (type instanceof ParameterizedType) {
                for (Type arg : ((ParameterizedType)type).getActualTypeArguments()) {
                    if (!TypeUtils.containsTypeVariables(arg)) continue;
                    return true;
                }
                return false;
            }
            if (type instanceof WildcardType) {
                WildcardType wild = (WildcardType)type;
                return TypeUtils.containsTypeVariables(TypeUtils.getImplicitLowerBounds(wild)[0]) || TypeUtils.containsTypeVariables(TypeUtils.getImplicitUpperBounds(wild)[0]);
            }
            return false;
        }

        public static final ParameterizedType parameterize(Class<?> raw, Type ... typeArguments) {
            return TypeUtils.parameterizeWithOwner(null, raw, typeArguments);
        }

        public static final ParameterizedType parameterize(Class<?> raw, Map<TypeVariable<?>, Type> typeArgMappings) {
            TypeUtils.validateNotNull(raw, "raw class is null", new Object[0]);
            TypeUtils.validateNotNull(typeArgMappings, "typeArgMappings is null", new Object[0]);
            return TypeUtils.parameterizeWithOwner(null, raw, TypeUtils.extractTypeArgumentsFrom(typeArgMappings, raw.getTypeParameters()));
        }

        public static final ParameterizedType parameterizeWithOwner(Type owner, Class<?> raw, Type ... typeArguments) {
            Type useOwner;
            TypeUtils.validateNotNull(raw, "raw class is null", new Object[0]);
            if (raw.getEnclosingClass() == null) {
                TypeUtils.validateIsTrue(owner == null, "no owner allowed for top-level %s", raw);
                useOwner = null;
            } else if (owner == null) {
                useOwner = raw.getEnclosingClass();
            } else {
                TypeUtils.validateIsTrue(TypeUtils.isAssignable(owner, raw.getEnclosingClass()), "%s is invalid owner type for parameterized %s", owner, raw);
                useOwner = owner;
            }
            TypeUtils.validateNoNullElements(typeArguments, "null type argument at index %s", new Object[0]);
            TypeUtils.validateIsTrue(raw.getTypeParameters().length == typeArguments.length, "invalid number of type parameters specified: expected %s, got %s", raw.getTypeParameters().length, typeArguments.length);
            return new ParameterizedTypeImpl(raw, useOwner, typeArguments);
        }

        public static final ParameterizedType parameterizeWithOwner(Type owner, Class<?> raw, Map<TypeVariable<?>, Type> typeArgMappings) {
            TypeUtils.validateNotNull(raw, "raw class is null", new Object[0]);
            TypeUtils.validateNotNull(typeArgMappings, "typeArgMappings is null", new Object[0]);
            return TypeUtils.parameterizeWithOwner(owner, raw, TypeUtils.extractTypeArgumentsFrom(typeArgMappings, raw.getTypeParameters()));
        }

        private static Type[] extractTypeArgumentsFrom(Map<TypeVariable<?>, Type> mappings, TypeVariable<?>[] variables) {
            Type[] result = new Type[variables.length];
            int index = 0;
            for (TypeVariable<?> var : variables) {
                TypeUtils.validateIsTrue(mappings.containsKey(var), "missing argument mapping for %s", TypeUtils.toString(var));
                result[index++] = mappings.get(var);
            }
            return result;
        }

        public static WildcardTypeBuilder wildcardType() {
            return new WildcardTypeBuilder();
        }

        public static GenericArrayType genericArrayType(Type componentType) {
            return new GenericArrayTypeImpl(TypeUtils.validateNotNull(componentType, "componentType is null", new Object[0]));
        }

        public static boolean equals(Type t1, Type t2) {
            if (Objects.equals(t1, t2)) {
                return true;
            }
            if (t1 instanceof ParameterizedType) {
                return TypeUtils.equals((ParameterizedType)t1, t2);
            }
            if (t1 instanceof GenericArrayType) {
                return TypeUtils.equals((GenericArrayType)t1, t2);
            }
            if (t1 instanceof WildcardType) {
                return TypeUtils.equals((WildcardType)t1, t2);
            }
            return false;
        }

        private static boolean equals(ParameterizedType p, Type t) {
            if (t instanceof ParameterizedType) {
                ParameterizedType other = (ParameterizedType)t;
                if (TypeUtils.equals(p.getRawType(), other.getRawType()) && TypeUtils.equals(p.getOwnerType(), other.getOwnerType())) {
                    return TypeUtils.equals(p.getActualTypeArguments(), other.getActualTypeArguments());
                }
            }
            return false;
        }

        private static boolean equals(GenericArrayType a, Type t) {
            return t instanceof GenericArrayType && TypeUtils.equals(a.getGenericComponentType(), ((GenericArrayType)t).getGenericComponentType());
        }

        private static boolean equals(WildcardType w, Type t) {
            if (t instanceof WildcardType) {
                WildcardType other = (WildcardType)t;
                return TypeUtils.equals(TypeUtils.getImplicitLowerBounds(w), TypeUtils.getImplicitLowerBounds(other)) && TypeUtils.equals(TypeUtils.getImplicitUpperBounds(w), TypeUtils.getImplicitUpperBounds(other));
            }
            return true;
        }

        private static boolean equals(Type[] t1, Type[] t2) {
            if (t1.length == t2.length) {
                for (int i = 0; i < t1.length; ++i) {
                    if (TypeUtils.equals(t1[i], t2[i])) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public static String toString(Type type) {
            return TypeUtils.toString(type, new HashSet<Type>());
        }

        private static String toString(Type type, Set<Type> done) {
            TypeUtils.validateNotNull(type);
            if (type instanceof Class) {
                return TypeUtils.classToString((Class)type, done);
            }
            if (type instanceof ParameterizedType) {
                return TypeUtils.parameterizedTypeToString((ParameterizedType)type, done);
            }
            if (type instanceof WildcardType) {
                return TypeUtils.wildcardTypeToString((WildcardType)type, done);
            }
            if (type instanceof CaptureType) {
                return TypeUtils.captureTypeToString((CaptureType)type, done);
            }
            if (type instanceof TypeVariable) {
                return TypeUtils.typeVariableToString((TypeVariable)type, done);
            }
            if (type instanceof GenericArrayType) {
                return TypeUtils.genericArrayTypeToString((GenericArrayType)type);
            }
            throw new IllegalArgumentException("Unknown generic type: " + type.getClass().getName());
        }

        public static String toLongString(TypeVariable<?> var) {
            StringBuilder buf;
            block5: {
                TypeUtils.validateNotNull(var, "var is null", new Object[0]);
                buf = new StringBuilder();
                Object d = var.getGenericDeclaration();
                if (d instanceof Class) {
                    Class<?> c = (Class<?>)d;
                    while (true) {
                        if (c.getEnclosingClass() == null) {
                            buf.insert(0, c.getName());
                            break block5;
                        }
                        buf.insert(0, c.getSimpleName()).insert(0, '.');
                        c = c.getEnclosingClass();
                    }
                }
                if (d instanceof Type) {
                    buf.append(TypeUtils.toString((Type)d));
                } else {
                    buf.append(d);
                }
            }
            return buf.append(':').append(TypeUtils.typeVariableToString(var, new HashSet<Type>())).toString();
        }

        private static String classToString(Class<?> c, Set<Type> done) {
            StringBuilder buf = new StringBuilder();
            if (c.getEnclosingClass() != null) {
                buf.append(TypeUtils.classToString(c.getEnclosingClass(), done)).append('.').append(c.getSimpleName());
            } else {
                buf.append(c.getName());
            }
            if (c.getTypeParameters().length > 0) {
                buf.append('<');
                TypeUtils.appendAllTo(buf, ", ", done, c.getTypeParameters());
                buf.append('>');
            }
            return buf.toString();
        }

        private static String typeVariableToString(TypeVariable<?> v, Set<Type> done) {
            StringBuilder buf = new StringBuilder(v.getName());
            if (done.contains(v)) {
                return buf.toString();
            }
            done.add(v);
            Type[] bounds = v.getBounds();
            if (!(bounds.length <= 0 || bounds.length == 1 && Object.class.equals((Object)bounds[0]))) {
                buf.append(" extends ");
                TypeUtils.appendAllTo(buf, " & ", done, v.getBounds());
            }
            return buf.toString();
        }

        private static String parameterizedTypeToString(ParameterizedType p, Set<Type> done) {
            StringBuilder buf = new StringBuilder();
            Type useOwner = p.getOwnerType();
            Class raw = (Class)p.getRawType();
            Type[] typeArguments = p.getActualTypeArguments();
            if (useOwner == null) {
                buf.append(raw.getName());
            } else {
                if (useOwner instanceof Class) {
                    buf.append(((Class)useOwner).getName());
                } else {
                    buf.append(useOwner.toString());
                }
                buf.append('.').append(raw.getSimpleName());
            }
            TypeUtils.appendAllTo(buf.append('<'), ", ", done, typeArguments).append('>');
            return buf.toString();
        }

        private static String wildcardTypeToString(WildcardType w, Set<Type> done) {
            StringBuilder buf = new StringBuilder().append('?');
            if (done.contains(w)) {
                return buf.toString();
            }
            done.add(w);
            TypeUtils.appendTypeBounds(buf, w.getLowerBounds(), w.getUpperBounds(), done);
            return buf.toString();
        }

        private static String captureTypeToString(CaptureType t, Set<Type> done) {
            StringBuilder buf = new StringBuilder().append("capture of ?");
            if (done.contains(t)) {
                return buf.toString();
            }
            done.add(t);
            TypeUtils.appendTypeBounds(buf, t.getLowerBounds(), t.getUpperBounds(), done);
            return buf.toString();
        }

        private static String genericArrayTypeToString(GenericArrayType g) {
            return String.format("%s[]", TypeUtils.toString(g.getGenericComponentType()));
        }

        private static void appendTypeBounds(StringBuilder buf, Type[] lowerBounds, Type[] upperBounds, Set<Type> done) {
            if (lowerBounds.length > 1 || lowerBounds.length == 1 && lowerBounds[0] != null) {
                TypeUtils.appendAllTo(buf.append(" super "), " & ", done, lowerBounds);
            } else if (upperBounds.length > 1 || upperBounds.length == 1 && !Object.class.equals((Object)upperBounds[0])) {
                TypeUtils.appendAllTo(buf.append(" extends "), " & ", done, upperBounds);
            }
        }

        private static StringBuilder appendAllTo(StringBuilder buf, String sep, Set<Type> done, Type ... types) {
            TypeUtils.validateNotEmpty(TypeUtils.validateNoNullElements(types));
            if (types.length > 0) {
                buf.append(TypeUtils.toString(types[0], done));
                for (int i = 1; i < types.length; ++i) {
                    buf.append(sep).append(TypeUtils.toString(types[i], done));
                }
            }
            return buf;
        }

        private static <T> T validateNotNull(T object) {
            return TypeUtils.validateNotNull(object, DEFAULT_IS_NULL_EX_MESSAGE, new Object[0]);
        }

        private static <T> T validateNotNull(T object, String message, Object ... values) {
            if (object == null) {
                throw new NullPointerException(String.format(message, values));
            }
            return object;
        }

        private static void validateIsTrue(boolean expression, String message, Object ... values) {
            if (!expression) {
                throw new IllegalArgumentException(String.format(message, values));
            }
        }

        private static <T> T[] validateNoNullElements(T[] array) {
            return TypeUtils.validateNoNullElements(array, DEFAULT_NO_NULL_ELEMENTS_ARRAY_EX_MESSAGE, new Object[0]);
        }

        private static <T> T[] validateNoNullElements(T[] array, String message, Object ... values) {
            TypeUtils.validateNotNull(array);
            for (int i = 0; i < array.length; ++i) {
                if (array[i] != null) continue;
                Object[] values2 = new Object[values.length + 1];
                System.arraycopy(values, 0, values2, 0, values.length);
                values2[values.length] = i;
                throw new IllegalArgumentException(String.format(message, values2));
            }
            return array;
        }

        private static <T> T[] validateNotEmpty(T[] array) {
            return TypeUtils.validateNotEmpty(array, DEFAULT_NOT_EMPTY_ARRAY_EX_MESSAGE, new Object[0]);
        }

        private static <T> T[] validateNotEmpty(T[] array, String message, Object ... values) {
            if (array == null) {
                throw new NullPointerException(String.format(message, values));
            }
            if (array.length == 0) {
                throw new IllegalArgumentException(String.format(message, values));
            }
            return array;
        }

        private static final class WildcardTypeImpl
        implements WildcardType {
            private static final Type[] EMPTY_BOUNDS = new Type[0];
            private final Type[] upperBounds;
            private final Type[] lowerBounds;

            private WildcardTypeImpl(Type upperBound, Type lowerBound) {
                Type[] typeArray;
                Type[] typeArray2;
                if (upperBound == null) {
                    typeArray2 = null;
                } else {
                    Type[] typeArray3 = new Type[1];
                    typeArray2 = typeArray3;
                    typeArray3[0] = upperBound;
                }
                if (lowerBound == null) {
                    typeArray = null;
                } else {
                    Type[] typeArray4 = new Type[1];
                    typeArray = typeArray4;
                    typeArray4[0] = lowerBound;
                }
                this(typeArray2, typeArray);
            }

            private WildcardTypeImpl(Type[] upperBounds, Type[] lowerBounds) {
                this.upperBounds = upperBounds == null ? EMPTY_BOUNDS : upperBounds;
                this.lowerBounds = lowerBounds == null ? EMPTY_BOUNDS : lowerBounds;
            }

            @Override
            public Type[] getUpperBounds() {
                return (Type[])this.upperBounds.clone();
            }

            @Override
            public Type[] getLowerBounds() {
                return (Type[])this.lowerBounds.clone();
            }

            public String toString() {
                return TypeUtils.toString(this);
            }

            public boolean equals(Object obj) {
                return obj == this || obj instanceof WildcardType && TypeUtils.equals(this, (WildcardType)obj);
            }

            public int hashCode() {
                int result = 18688;
                result |= Arrays.hashCode(this.upperBounds);
                result <<= 8;
                return result |= Arrays.hashCode(this.lowerBounds);
            }
        }

        private static final class ParameterizedTypeImpl
        implements ParameterizedType {
            private final Class<?> raw;
            private final Type useOwner;
            private final Type[] typeArguments;

            private ParameterizedTypeImpl(Class<?> raw, Type useOwner, Type[] typeArguments) {
                this.raw = raw;
                this.useOwner = useOwner;
                this.typeArguments = typeArguments;
            }

            @Override
            public Type getRawType() {
                return this.raw;
            }

            @Override
            public Type getOwnerType() {
                return this.useOwner;
            }

            @Override
            public Type[] getActualTypeArguments() {
                return (Type[])this.typeArguments.clone();
            }

            public String toString() {
                return TypeUtils.toString(this);
            }

            public boolean equals(Object obj) {
                return obj == this || obj instanceof ParameterizedType && TypeUtils.equals(this, (ParameterizedType)obj);
            }

            public int hashCode() {
                int result = 1136;
                result |= this.raw.hashCode();
                result <<= 4;
                result |= Objects.hashCode(this.useOwner);
                result <<= 8;
                return result |= Arrays.hashCode(this.typeArguments);
            }
        }

        private static final class GenericArrayTypeImpl
        implements GenericArrayType {
            private final Type componentType;

            private GenericArrayTypeImpl(Type componentType) {
                this.componentType = componentType;
            }

            @Override
            public Type getGenericComponentType() {
                return this.componentType;
            }

            public String toString() {
                return TypeUtils.toString(this);
            }

            public boolean equals(Object obj) {
                return obj == this || obj instanceof GenericArrayType && TypeUtils.equals(this, (GenericArrayType)obj);
            }

            public int hashCode() {
                int result = 1072;
                return result |= this.componentType.hashCode();
            }
        }

        public static class WildcardTypeBuilder {
            private Type[] upperBounds;
            private Type[] lowerBounds;

            private WildcardTypeBuilder() {
            }

            public WildcardTypeBuilder withUpperBounds(Type ... bounds) {
                this.upperBounds = bounds;
                return this;
            }

            public WildcardTypeBuilder withLowerBounds(Type ... bounds) {
                this.lowerBounds = bounds;
                return this;
            }

            public WildcardType build() {
                return new WildcardTypeImpl(this.upperBounds, this.lowerBounds);
            }
        }
    }
}

