/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.drawing;

import java.util.List;
import java.util.Objects;
import net.algart.arrays.Matrix;
import net.algart.executors.modules.core.common.matrices.SeveralMultiMatricesOperation;
import net.algart.executors.modules.core.matrices.geometry.Resize;
import net.algart.executors.modules.core.matrices.misc.Selector;
import net.algart.executors.modules.cv.matrices.morphology.MorphologyFilter;
import net.algart.executors.modules.cv.matrices.morphology.MorphologyOperation;
import net.algart.executors.modules.cv.matrices.morphology.StrictMorphology;
import net.algart.executors.modules.cv.matrices.objects.markers.PaintLabelledObjects;
import net.algart.multimatrix.MultiMatrix;
import net.algart.multimatrix.MultiMatrix2D;

public final class DrawLabels
extends SeveralMultiMatricesOperation {
    public static final String LABELS = "labels";
    private DrawnFeatures drawnFeatures = DrawnFeatures.BOUNDARIES_BETWEEN_LABELS;
    private String color = "#FFFFFF";
    private boolean convertMonoToColor = true;
    private int scale = 1;
    private long randSeed = 0L;

    public DrawLabels() {
        super(new String[]{DEFAULT_INPUT_PORT, LABELS});
    }

    public DrawnFeatures getDrawnFeatures() {
        return this.drawnFeatures;
    }

    public DrawLabels setDrawnFeatures(DrawnFeatures drawnFeatures) {
        this.drawnFeatures = (DrawnFeatures)((Object)DrawLabels.nonNull((Object)((Object)drawnFeatures)));
        return this;
    }

    public String getColor() {
        return this.color;
    }

    public DrawLabels setColor(String color) {
        this.color = (String)DrawLabels.nonNull((Object)color);
        return this;
    }

    public boolean isConvertMonoToColor() {
        return this.convertMonoToColor;
    }

    public DrawLabels setConvertMonoToColor(boolean convertMonoToColor) {
        this.convertMonoToColor = convertMonoToColor;
        return this;
    }

    public int getScale() {
        return this.scale;
    }

    public DrawLabels setScale(int scale) {
        this.scale = DrawLabels.positive((int)scale);
        return this;
    }

    public long getRandSeed() {
        return this.randSeed;
    }

    public DrawLabels setRandSeed(long randSeed) {
        this.randSeed = randSeed;
        return this;
    }

    public MultiMatrix process(List<MultiMatrix> sources) {
        MultiMatrix2D result;
        MultiMatrix2D drawn;
        MultiMatrix2D source;
        Objects.requireNonNull(sources, "Null sources");
        MultiMatrix2D multiMatrix2D = source = sources.get(0) == null ? null : sources.get(0).asMultiMatrix2D();
        if (this.convertMonoToColor && source != null && source.isMono() && (source = source.asOtherNumberOfChannels(3)).bitsPerElement() == 1) {
            source = source.asPrecision(Byte.TYPE);
        }
        Objects.requireNonNull(sources.get(1), "Null sources.get(1) (labels matrix)");
        MultiMatrix2D labels = sources.get(1).asMultiMatrix2D();
        labels.checkDimensionEquality((MultiMatrix)source, LABELS, "source");
        if (this.scale > 1) {
            Resize resize = new Resize();
            resize.setResizingMode(Resize.ResizingMode.NEAREST);
            resize.setDimX((double)(labels.dimX() * (long)this.scale));
            resize.setDimY((double)(labels.dimY() * (long)this.scale));
            labels = resize.process(labels);
            if (source != null) {
                source = resize.process(source);
            }
        }
        if (this.drawnFeatures == DrawnFeatures.RANDOMLY_COLORED_LABELS) {
            try (PaintLabelledObjects paintLabelledObjects = new PaintLabelledObjects();){
                paintLabelledObjects.setRandomPalette(true).setRandSeed(this.randSeed);
                MultiMatrix2D multiMatrix2D2 = paintLabelledObjects.process(labels, source, null);
                return multiMatrix2D2;
            }
        }
        if (this.drawnFeatures.boundaries) {
            try (StrictMorphology morphologyGradient = new StrictMorphology();){
                morphologyGradient.setOperation(MorphologyOperation.BEUCHER_GRADIENT);
                morphologyGradient.setCustomPattern(this.drawnFeatures.thick ? MorphologyFilter.Shape.SPHERE.newPattern(labels.dimCount(), 4) : MorphologyOperation.crossPattern(labels.dimCount()));
                assert (MorphologyOperation.crossPattern(labels.dimCount()).equals((Object)MorphologyFilter.Shape.SPHERE.newPattern(labels.dimCount(), 2))) : String.valueOf(MorphologyOperation.crossPattern(labels.dimCount())) + "!=" + String.valueOf(MorphologyFilter.Shape.SPHERE.newPattern(labels.dimCount(), 2));
                morphologyGradient.setContinuationMode(Matrix.ContinuationMode.MIRROR_CYCLIC);
                drawn = morphologyGradient.process((MultiMatrix)labels).asMultiMatrix2D().nonZeroPixels(false);
            }
        } else {
            drawn = labels.nonZeroPixels(false);
        }
        try (Selector selector = new Selector();){
            selector.setFiller(0, "#000000");
            selector.setFiller(1, this.color);
            if (this.convertMonoToColor) {
                selector.setMinimalRequiredNumberOfChannels(3);
            }
            result = selector.process(new MultiMatrix[]{drawn, source, null}).asMultiMatrix2D();
        }
        if (this.drawnFeatures.zeroBackground) {
            result = result.min(labels.nonZeroAnyChannel()).clone();
        }
        return result;
    }

    protected boolean allowUninitializedInput(int inputIndex) {
        return inputIndex == 0;
    }

    public static enum DrawnFeatures {
        NON_ZERO_LABELS(false, false, false),
        RANDOMLY_COLORED_LABELS(false, false, false),
        BOUNDARIES_BETWEEN_LABELS(true, false, false),
        ZERO_BACKGROUND_AND_BOUNDARIES_BETWEEN_NONZERO_LABELS(true, false, true),
        THICK_BOUNDARIES_BETWEEN_LABELS(true, true, false),
        ZERO_BACKGROUND_AND_THICK_BOUNDARIES_BETWEEN_NONZERO_LABELS(true, true, true);

        private final boolean boundaries;
        private final boolean thick;
        private final boolean zeroBackground;

        private DrawnFeatures(boolean boundaries, boolean thick, boolean zeroBackground) {
            this.boundaries = boundaries;
            this.thick = thick;
            this.zeroBackground = zeroBackground;
        }
    }
}

