/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.objects.binary;

import net.algart.arrays.BitArray;
import net.algart.arrays.IterativeArrayProcessor;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.arrays.UpdatableBitArray;
import net.algart.executors.modules.core.common.matrices.BitMultiMatrixFilter;
import net.algart.matrices.skeletons.OctupleThinningSkeleton2D;
import net.algart.matrices.skeletons.Quadruple3x5ThinningSkeleton2D;
import net.algart.matrices.skeletons.StrongQuadruple3x5ThinningSkeleton2D;
import net.algart.matrices.skeletons.WeakOctupleThinningSkeleton2D;

public final class Skeletonization
extends BitMultiMatrixFilter {
    private Algorithm algorithm = Algorithm.OCTUPLE_PLUS_STRONG_QUADRUPLE_THINNING;
    private boolean diagonalThinning = true;
    private boolean topological = false;
    private long maxNumberOfIterations = -1L;
    private long numberOfAdditionalTopologicalIterations = 0L;
    private boolean addBorder = false;

    public Algorithm getAlgorithm() {
        return this.algorithm;
    }

    public Skeletonization setAlgorithm(Algorithm algorithm) {
        this.algorithm = (Algorithm)((Object)Skeletonization.nonNull((Object)((Object)algorithm)));
        return this;
    }

    public boolean isDiagonalThinning() {
        return this.diagonalThinning;
    }

    public Skeletonization setDiagonalThinning(boolean diagonalThinning) {
        this.diagonalThinning = diagonalThinning;
        return this;
    }

    public boolean isTopological() {
        return this.topological;
    }

    public Skeletonization setTopological(boolean topological) {
        this.topological = topological;
        return this;
    }

    public long getMaxNumberOfIterations() {
        return this.maxNumberOfIterations;
    }

    public Skeletonization setMaxNumberOfIterations(long maxNumberOfIterations) {
        this.maxNumberOfIterations = maxNumberOfIterations;
        return this;
    }

    public long getNumberOfAdditionalTopologicalIterations() {
        return this.numberOfAdditionalTopologicalIterations;
    }

    public Skeletonization setNumberOfAdditionalTopologicalIterations(long numberOfAdditionalTopologicalIterations) {
        this.numberOfAdditionalTopologicalIterations = numberOfAdditionalTopologicalIterations;
        return this;
    }

    public boolean isAddBorder() {
        return this.addBorder;
    }

    public void setAddBorder(boolean addBorder) {
        this.addBorder = addBorder;
    }

    public Matrix<? extends PArray> processMatrix(Matrix<? extends PArray> bitMatrix) {
        Matrix updatableBitMatrix = Skeletonization.cloneBit((Matrix)bitMatrix.cast(BitArray.class));
        if (this.addBorder) {
            Skeletonization.drawBorder((Matrix<UpdatableBitArray>)updatableBitMatrix, this.zeroExtendingValue());
        }
        IterativeArrayProcessor processor = this.algorithm.getSkeletonProcessor((Matrix<? extends UpdatableBitArray>)updatableBitMatrix, this.diagonalThinning, this.topological).limitIterations(this.maxNumberOfIterations);
        Skeletonization.logDebug(() -> "Skeletonization: " + String.valueOf(processor) + " for " + String.valueOf(bitMatrix));
        Matrix result = (Matrix)processor.process();
        if (this.numberOfAdditionalTopologicalIterations != 0L) {
            result = (Matrix)this.algorithm.getPostprocessingTopologicalProcessor((Matrix<? extends UpdatableBitArray>)result, this.diagonalThinning).limitIterations(this.numberOfAdditionalTopologicalIterations).process();
        }
        return result;
    }

    private static void drawBorder(Matrix<UpdatableBitArray> bitMatrix, int d) {
        long dimX = bitMatrix.dimX() - (long)(2 * d);
        long dimY = bitMatrix.dimY() - (long)(2 * d);
        if (dimX > 0L && dimY > 0L) {
            ((UpdatableBitArray)bitMatrix.subMatr((long)d, (long)d, dimX, 1L).array()).fill(true);
            ((UpdatableBitArray)bitMatrix.subMatr((long)d, dimY + (long)d - 1L, dimX, 1L).array()).fill(true);
            ((UpdatableBitArray)bitMatrix.subMatr((long)d, (long)d, 1L, dimY).array()).fill(true);
            ((UpdatableBitArray)bitMatrix.subMatr(dimX + (long)d - 1L, (long)d, 1L, dimY).array()).fill(true);
        }
    }

    protected boolean zeroExtending() {
        return true;
    }

    public static enum Algorithm {
        OCTUPLE_PLUS_QUADRUPLE_THINNING{

            @Override
            IterativeArrayProcessor<Matrix<? extends UpdatableBitArray>> getSkeletonProcessor(Matrix<? extends UpdatableBitArray> m, boolean diagonalThinning, boolean topological) {
                return OctupleThinningSkeleton2D.getInstance(null, m, (boolean)diagonalThinning, (boolean)topological).chain((IterativeArrayProcessor)Quadruple3x5ThinningSkeleton2D.getInstance(null, m), 0.01);
            }

            @Override
            IterativeArrayProcessor<Matrix<? extends UpdatableBitArray>> getPostprocessingTopologicalProcessor(Matrix<? extends UpdatableBitArray> m, boolean diagonalThinning) {
                return OctupleThinningSkeleton2D.getInstance(null, m, (boolean)diagonalThinning, (boolean)true);
            }
        }
        ,
        OCTUPLE_PLUS_STRONG_QUADRUPLE_THINNING{

            @Override
            IterativeArrayProcessor<Matrix<? extends UpdatableBitArray>> getSkeletonProcessor(Matrix<? extends UpdatableBitArray> m, boolean diagonalThinning, boolean topological) {
                return OctupleThinningSkeleton2D.getInstance(null, m, (boolean)diagonalThinning, (boolean)topological).chain((IterativeArrayProcessor)StrongQuadruple3x5ThinningSkeleton2D.getInstance(null, m), 0.01);
            }

            @Override
            IterativeArrayProcessor<Matrix<? extends UpdatableBitArray>> getPostprocessingTopologicalProcessor(Matrix<? extends UpdatableBitArray> m, boolean diagonalThinning) {
                return OctupleThinningSkeleton2D.getInstance(null, m, (boolean)diagonalThinning, (boolean)true);
            }
        }
        ,
        OCTUPLE_THINNING{

            @Override
            IterativeArrayProcessor<Matrix<? extends UpdatableBitArray>> getSkeletonProcessor(Matrix<? extends UpdatableBitArray> m, boolean diagonalThinning, boolean topological) {
                return OctupleThinningSkeleton2D.getInstance(null, m, (boolean)diagonalThinning, (boolean)topological);
            }
        }
        ,
        WEAK_OCTUPLE_THINNING{

            @Override
            IterativeArrayProcessor<Matrix<? extends UpdatableBitArray>> getSkeletonProcessor(Matrix<? extends UpdatableBitArray> m, boolean diagonalThinning, boolean topological) {
                return WeakOctupleThinningSkeleton2D.getInstance(null, m, (boolean)true, (boolean)diagonalThinning, (boolean)topological);
            }
        }
        ,
        QUADRUPLE_3_X_5_THINNING{

            @Override
            IterativeArrayProcessor<Matrix<? extends UpdatableBitArray>> getSkeletonProcessor(Matrix<? extends UpdatableBitArray> m, boolean diagonalThinning, boolean topological) {
                return Quadruple3x5ThinningSkeleton2D.getInstance(null, m);
            }

            @Override
            IterativeArrayProcessor<Matrix<? extends UpdatableBitArray>> getPostprocessingTopologicalProcessor(Matrix<? extends UpdatableBitArray> m, boolean diagonalThinning) {
                return OctupleThinningSkeleton2D.getInstance(null, m, (boolean)diagonalThinning, (boolean)true);
            }
        }
        ,
        STRONG_QUADRUPLE_3_X_5_THINNING{

            @Override
            IterativeArrayProcessor<Matrix<? extends UpdatableBitArray>> getSkeletonProcessor(Matrix<? extends UpdatableBitArray> m, boolean diagonalThinning, boolean topological) {
                return StrongQuadruple3x5ThinningSkeleton2D.getInstance(null, m);
            }

            @Override
            IterativeArrayProcessor<Matrix<? extends UpdatableBitArray>> getPostprocessingTopologicalProcessor(Matrix<? extends UpdatableBitArray> m, boolean diagonalThinning) {
                return OctupleThinningSkeleton2D.getInstance(null, m, (boolean)diagonalThinning, (boolean)true);
            }
        };


        abstract IterativeArrayProcessor<Matrix<? extends UpdatableBitArray>> getSkeletonProcessor(Matrix<? extends UpdatableBitArray> var1, boolean var2, boolean var3);

        IterativeArrayProcessor<Matrix<? extends UpdatableBitArray>> getPostprocessingTopologicalProcessor(Matrix<? extends UpdatableBitArray> m, boolean diagonalThinning) {
            return this.getSkeletonProcessor(m, diagonalThinning, true);
        }
    }
}

