/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.objects.labels;

import java.util.Objects;
import net.algart.arrays.Array;
import net.algart.arrays.IntArray;
import net.algart.executors.modules.cv.matrices.objects.labels.LabelledObjectsProcessor1Channels;
import net.algart.executors.modules.cv.matrices.objects.labels.LabelledObjectsProcessor2Channels;
import net.algart.executors.modules.cv.matrices.objects.labels.LabelledObjectsProcessor3Channels;
import net.algart.executors.modules.cv.matrices.objects.labels.LabelledObjectsProcessor4Channels;
import net.algart.executors.modules.cv.matrices.objects.labels.LabelledObjectsProcessor5Channels;
import net.algart.executors.modules.cv.matrices.objects.labels.LabelledObjectsProcessor6Channels;
import net.algart.executors.modules.cv.matrices.objects.labels.LabelledObjectsProcessor7Channels;
import net.algart.executors.modules.cv.matrices.objects.labels.LabelsProcessor;
import net.algart.executors.modules.cv.matrices.objects.labels.SingleObjectProcessor;

public abstract class LabelledObjectsProcessor
extends LabelsProcessor {
    final int numberOfChannels;
    final int[] lists;
    final int[] listHeads;
    final SingleObjectProcessor processor;
    final int[] cardinalities;

    LabelledObjectsProcessor(int[] lists, int[] listHeads, SingleObjectProcessor processor, int numberOfChannels) {
        super((Array)IntArray.as((int[])Objects.requireNonNull(listHeads, "Null listHeads")), LabelledObjectsProcessor.numberOrParticlesInBlockForParallelProcessing(listHeads.length));
        this.numberOfChannels = numberOfChannels;
        this.lists = Objects.requireNonNull(lists, "Null lists");
        this.listHeads = listHeads;
        this.processor = Objects.requireNonNull(processor, "Null processor");
        this.cardinalities = new int[Math.max(0, listHeads.length - 1)];
    }

    public static LabelledObjectsProcessor getInstance(int[] lists, int[] listHeads, SingleObjectProcessor processor, Object[] channels) {
        Objects.requireNonNull(lists, "Null lists");
        Objects.requireNonNull(listHeads, "Null listHeads");
        Objects.requireNonNull(processor, "Null processor");
        Objects.requireNonNull(channels, "Null channels");
        if (channels.length == 0) {
            throw new IllegalArgumentException("Empty channels array");
        }
        Object channel0 = channels[0];
        if (!LabelledObjectsProcessor.isArraySupported(channel0)) {
            throw new IllegalArgumentException("Illegal array type: " + String.valueOf(channel0));
        }
        for (int k = 1; k < channels.length; ++k) {
            if (channels[k].getClass() == channel0.getClass()) continue;
            throw new IllegalArgumentException("Different type of channels: " + String.valueOf(channels[k].getClass()) + " != " + String.valueOf(channel0.getClass()));
        }
        switch (channels.length) {
            case 1: {
                if (channel0 instanceof byte[]) {
                    return new LabelledObjectsProcessor1Channels.ForBytes(lists, listHeads, processor, LabelledObjectsProcessor.castToByte(channels));
                }
                if (channel0 instanceof short[]) {
                    return new LabelledObjectsProcessor1Channels.ForShorts(lists, listHeads, processor, LabelledObjectsProcessor.castToShort(channels));
                }
                if (channel0 instanceof int[]) {
                    return new LabelledObjectsProcessor1Channels.ForInts(lists, listHeads, processor, LabelledObjectsProcessor.castToInt(channels));
                }
                if (channel0 instanceof float[]) {
                    return new LabelledObjectsProcessor1Channels.ForFloats(lists, listHeads, processor, LabelledObjectsProcessor.castToFloat(channels));
                }
                if (channel0 instanceof double[]) {
                    return new LabelledObjectsProcessor1Channels.ForDoubles(lists, listHeads, processor, LabelledObjectsProcessor.castToDouble(channels));
                }
                throw new AssertionError();
            }
            case 2: {
                if (channel0 instanceof byte[]) {
                    return new LabelledObjectsProcessor2Channels.ForBytes(lists, listHeads, processor, LabelledObjectsProcessor.castToByte(channels));
                }
                if (channel0 instanceof short[]) {
                    return new LabelledObjectsProcessor2Channels.ForShorts(lists, listHeads, processor, LabelledObjectsProcessor.castToShort(channels));
                }
                if (channel0 instanceof int[]) {
                    return new LabelledObjectsProcessor2Channels.ForInts(lists, listHeads, processor, LabelledObjectsProcessor.castToInt(channels));
                }
                if (channel0 instanceof float[]) {
                    return new LabelledObjectsProcessor2Channels.ForFloats(lists, listHeads, processor, LabelledObjectsProcessor.castToFloat(channels));
                }
                if (channel0 instanceof double[]) {
                    return new LabelledObjectsProcessor2Channels.ForDoubles(lists, listHeads, processor, LabelledObjectsProcessor.castToDouble(channels));
                }
                throw new AssertionError();
            }
            case 3: {
                if (channel0 instanceof byte[]) {
                    return new LabelledObjectsProcessor3Channels.ForBytes(lists, listHeads, processor, LabelledObjectsProcessor.castToByte(channels));
                }
                if (channel0 instanceof short[]) {
                    return new LabelledObjectsProcessor3Channels.ForShorts(lists, listHeads, processor, LabelledObjectsProcessor.castToShort(channels));
                }
                if (channel0 instanceof int[]) {
                    return new LabelledObjectsProcessor3Channels.ForInts(lists, listHeads, processor, LabelledObjectsProcessor.castToInt(channels));
                }
                if (channel0 instanceof float[]) {
                    return new LabelledObjectsProcessor3Channels.ForFloats(lists, listHeads, processor, LabelledObjectsProcessor.castToFloat(channels));
                }
                if (channel0 instanceof double[]) {
                    return new LabelledObjectsProcessor3Channels.ForDoubles(lists, listHeads, processor, LabelledObjectsProcessor.castToDouble(channels));
                }
                throw new AssertionError();
            }
            case 4: {
                if (channel0 instanceof byte[]) {
                    return new LabelledObjectsProcessor4Channels.ForBytes(lists, listHeads, processor, LabelledObjectsProcessor.castToByte(channels));
                }
                if (channel0 instanceof short[]) {
                    return new LabelledObjectsProcessor4Channels.ForShorts(lists, listHeads, processor, LabelledObjectsProcessor.castToShort(channels));
                }
                if (channel0 instanceof int[]) {
                    return new LabelledObjectsProcessor4Channels.ForInts(lists, listHeads, processor, LabelledObjectsProcessor.castToInt(channels));
                }
                if (channel0 instanceof float[]) {
                    return new LabelledObjectsProcessor4Channels.ForFloats(lists, listHeads, processor, LabelledObjectsProcessor.castToFloat(channels));
                }
                if (channel0 instanceof double[]) {
                    return new LabelledObjectsProcessor4Channels.ForDoubles(lists, listHeads, processor, LabelledObjectsProcessor.castToDouble(channels));
                }
                throw new AssertionError();
            }
            case 5: {
                if (channel0 instanceof byte[]) {
                    return new LabelledObjectsProcessor5Channels.ForBytes(lists, listHeads, processor, LabelledObjectsProcessor.castToByte(channels));
                }
                if (channel0 instanceof short[]) {
                    return new LabelledObjectsProcessor5Channels.ForShorts(lists, listHeads, processor, LabelledObjectsProcessor.castToShort(channels));
                }
                if (channel0 instanceof int[]) {
                    return new LabelledObjectsProcessor5Channels.ForInts(lists, listHeads, processor, LabelledObjectsProcessor.castToInt(channels));
                }
                if (channel0 instanceof float[]) {
                    return new LabelledObjectsProcessor5Channels.ForFloats(lists, listHeads, processor, LabelledObjectsProcessor.castToFloat(channels));
                }
                if (channel0 instanceof double[]) {
                    return new LabelledObjectsProcessor5Channels.ForDoubles(lists, listHeads, processor, LabelledObjectsProcessor.castToDouble(channels));
                }
                throw new AssertionError();
            }
            case 6: {
                if (channel0 instanceof byte[]) {
                    return new LabelledObjectsProcessor6Channels.ForBytes(lists, listHeads, processor, LabelledObjectsProcessor.castToByte(channels));
                }
                if (channel0 instanceof short[]) {
                    return new LabelledObjectsProcessor6Channels.ForShorts(lists, listHeads, processor, LabelledObjectsProcessor.castToShort(channels));
                }
                if (channel0 instanceof int[]) {
                    return new LabelledObjectsProcessor6Channels.ForInts(lists, listHeads, processor, LabelledObjectsProcessor.castToInt(channels));
                }
                if (channel0 instanceof float[]) {
                    return new LabelledObjectsProcessor6Channels.ForFloats(lists, listHeads, processor, LabelledObjectsProcessor.castToFloat(channels));
                }
                if (channel0 instanceof double[]) {
                    return new LabelledObjectsProcessor6Channels.ForDoubles(lists, listHeads, processor, LabelledObjectsProcessor.castToDouble(channels));
                }
                throw new AssertionError();
            }
            case 7: {
                if (channel0 instanceof byte[]) {
                    return new LabelledObjectsProcessor7Channels.ForBytes(lists, listHeads, processor, LabelledObjectsProcessor.castToByte(channels));
                }
                if (channel0 instanceof short[]) {
                    return new LabelledObjectsProcessor7Channels.ForShorts(lists, listHeads, processor, LabelledObjectsProcessor.castToShort(channels));
                }
                if (channel0 instanceof int[]) {
                    return new LabelledObjectsProcessor7Channels.ForInts(lists, listHeads, processor, LabelledObjectsProcessor.castToInt(channels));
                }
                if (channel0 instanceof float[]) {
                    return new LabelledObjectsProcessor7Channels.ForFloats(lists, listHeads, processor, LabelledObjectsProcessor.castToFloat(channels));
                }
                if (channel0 instanceof double[]) {
                    return new LabelledObjectsProcessor7Channels.ForDoubles(lists, listHeads, processor, LabelledObjectsProcessor.castToDouble(channels));
                }
                throw new AssertionError();
            }
        }
        if (channel0 instanceof byte[]) {
            return new ForBytes(lists, listHeads, processor, LabelledObjectsProcessor.castToByte(channels));
        }
        if (channel0 instanceof short[]) {
            return new ForShorts(lists, listHeads, processor, LabelledObjectsProcessor.castToShort(channels));
        }
        if (channel0 instanceof int[]) {
            return new ForInts(lists, listHeads, processor, LabelledObjectsProcessor.castToInt(channels));
        }
        if (channel0 instanceof float[]) {
            return new ForFloats(lists, listHeads, processor, LabelledObjectsProcessor.castToFloat(channels));
        }
        if (channel0 instanceof double[]) {
            return new ForDoubles(lists, listHeads, processor, LabelledObjectsProcessor.castToDouble(channels));
        }
        throw new AssertionError();
    }

    @Override
    public void close() {
    }

    public int[] cardinalities() {
        return this.cardinalities;
    }

    private static class ForBytes
    extends LabelledObjectsProcessor {
        private final byte[][] data;
        private final byte[][][] threadObjectData;
        private final byte[][][] requestedObjectData;

        ForBytes(int[] lists, int[] listHeads, SingleObjectProcessor processor, byte[][] data) {
            super(lists, listHeads, processor, data.length);
            this.data = data;
            this.requestedObjectData = ForBytes.requestByteArrays(this.numberOfTasks(), this.numberOfChannels);
            this.threadObjectData = new byte[this.requestedObjectData.length][][];
            for (int k = 0; k < this.requestedObjectData.length; ++k) {
                this.threadObjectData[k] = (byte[][])this.requestedObjectData[k].clone();
            }
        }

        @Override
        public void close() {
            ForBytes.releaseByteArrays(this.requestedObjectData);
        }

        @Override
        protected void processSubArr(int p, int count, int threadIndex) {
            int label;
            byte[][] objectData = this.threadObjectData[threadIndex];
            int capacity = objectData[0].length;
            int labelMax = label + count;
            for (label = p; label < labelMax; ++label) {
                int index = this.listHeads[label];
                int pixelCount = 0;
                while (index != -1) {
                    if (pixelCount >= capacity) {
                        ForBytes.ensureCapacityForPixels(objectData, this.lists.length, pixelCount);
                        capacity = objectData[0].length;
                    }
                    for (int c = 0; c < this.numberOfChannels; ++c) {
                        objectData[c][pixelCount] = this.data[c][index];
                    }
                    ++pixelCount;
                    index = this.lists[index];
                }
                if (label > 0) {
                    this.cardinalities[label - 1] = pixelCount;
                }
                this.processor.processPixels(label, objectData, pixelCount, threadIndex);
            }
        }
    }

    private static class ForShorts
    extends LabelledObjectsProcessor {
        private final short[][] data;
        private final short[][][] threadObjectData;
        private final short[][][] requestedObjectData;

        ForShorts(int[] lists, int[] listHeads, SingleObjectProcessor processor, short[][] data) {
            super(lists, listHeads, processor, data.length);
            this.data = data;
            this.requestedObjectData = ForShorts.requestShortArrays(this.numberOfTasks(), this.numberOfChannels);
            this.threadObjectData = new short[this.requestedObjectData.length][][];
            for (int k = 0; k < this.requestedObjectData.length; ++k) {
                this.threadObjectData[k] = (short[][])this.requestedObjectData[k].clone();
            }
        }

        @Override
        public void close() {
            ForShorts.releaseShortArrays(this.requestedObjectData);
        }

        @Override
        protected void processSubArr(int p, int count, int threadIndex) {
            int label;
            short[][] objectData = this.threadObjectData[threadIndex];
            int capacity = objectData[0].length;
            int labelMax = label + count;
            for (label = p; label < labelMax; ++label) {
                int index = this.listHeads[label];
                int pixelCount = 0;
                while (index != -1) {
                    if (pixelCount >= capacity) {
                        ForShorts.ensureCapacityForPixels(objectData, this.lists.length, pixelCount);
                        capacity = objectData[0].length;
                    }
                    for (int c = 0; c < this.numberOfChannels; ++c) {
                        objectData[c][pixelCount] = this.data[c][index];
                    }
                    ++pixelCount;
                    index = this.lists[index];
                }
                if (label > 0) {
                    this.cardinalities[label - 1] = pixelCount;
                }
                this.processor.processPixels(label, objectData, pixelCount, threadIndex);
            }
        }
    }

    private static class ForInts
    extends LabelledObjectsProcessor {
        private final int[][] data;
        private final int[][][] threadObjectData;
        private final int[][][] requestedObjectData;

        ForInts(int[] lists, int[] listHeads, SingleObjectProcessor processor, int[][] data) {
            super(lists, listHeads, processor, data.length);
            this.data = data;
            this.requestedObjectData = ForInts.requestIntArrays(this.numberOfTasks(), this.numberOfChannels);
            this.threadObjectData = new int[this.requestedObjectData.length][][];
            for (int k = 0; k < this.requestedObjectData.length; ++k) {
                this.threadObjectData[k] = (int[][])this.requestedObjectData[k].clone();
            }
        }

        @Override
        public void close() {
            ForInts.releaseIntArrays(this.requestedObjectData);
        }

        @Override
        protected void processSubArr(int p, int count, int threadIndex) {
            int label;
            int[][] objectData = this.threadObjectData[threadIndex];
            int capacity = objectData[0].length;
            int labelMax = label + count;
            for (label = p; label < labelMax; ++label) {
                int index = this.listHeads[label];
                int pixelCount = 0;
                while (index != -1) {
                    if (pixelCount >= capacity) {
                        ForInts.ensureCapacityForPixels(objectData, this.lists.length, pixelCount);
                        capacity = objectData[0].length;
                    }
                    for (int c = 0; c < this.numberOfChannels; ++c) {
                        objectData[c][pixelCount] = this.data[c][index];
                    }
                    ++pixelCount;
                    index = this.lists[index];
                }
                if (label > 0) {
                    this.cardinalities[label - 1] = pixelCount;
                }
                this.processor.processPixels(label, objectData, pixelCount, threadIndex);
            }
        }
    }

    private static class ForFloats
    extends LabelledObjectsProcessor {
        private final float[][] data;
        private final float[][][] threadObjectData;
        private final float[][][] requestedObjectData;

        ForFloats(int[] lists, int[] listHeads, SingleObjectProcessor processor, float[][] data) {
            super(lists, listHeads, processor, data.length);
            this.data = data;
            this.requestedObjectData = ForFloats.requestFloatArrays(this.numberOfTasks(), this.numberOfChannels);
            this.threadObjectData = new float[this.requestedObjectData.length][][];
            for (int k = 0; k < this.requestedObjectData.length; ++k) {
                this.threadObjectData[k] = (float[][])this.requestedObjectData[k].clone();
            }
        }

        @Override
        public void close() {
            ForFloats.releaseFloatArrays(this.requestedObjectData);
        }

        @Override
        protected void processSubArr(int p, int count, int threadIndex) {
            int label;
            float[][] objectData = this.threadObjectData[threadIndex];
            int capacity = objectData[0].length;
            int labelMax = label + count;
            for (label = p; label < labelMax; ++label) {
                int index = this.listHeads[label];
                int pixelCount = 0;
                while (index != -1) {
                    if (pixelCount >= capacity) {
                        ForFloats.ensureCapacityForPixels(objectData, this.lists.length, pixelCount);
                        capacity = objectData[0].length;
                    }
                    for (int c = 0; c < this.numberOfChannels; ++c) {
                        objectData[c][pixelCount] = this.data[c][index];
                    }
                    ++pixelCount;
                    index = this.lists[index];
                }
                if (label > 0) {
                    this.cardinalities[label - 1] = pixelCount;
                }
                this.processor.processPixels(label, objectData, pixelCount, threadIndex);
            }
        }
    }

    private static class ForDoubles
    extends LabelledObjectsProcessor {
        private final double[][] data;
        private final double[][][] threadObjectData;
        private final double[][][] requestedObjectData;

        ForDoubles(int[] lists, int[] listHeads, SingleObjectProcessor processor, double[][] data) {
            super(lists, listHeads, processor, data.length);
            this.data = data;
            this.requestedObjectData = ForDoubles.requestDoubleArrays(this.numberOfTasks(), this.numberOfChannels);
            this.threadObjectData = new double[this.requestedObjectData.length][][];
            for (int k = 0; k < this.requestedObjectData.length; ++k) {
                this.threadObjectData[k] = (double[][])this.requestedObjectData[k].clone();
            }
        }

        @Override
        public void close() {
            ForDoubles.releaseDoubleArrays(this.requestedObjectData);
        }

        @Override
        protected void processSubArr(int p, int count, int threadIndex) {
            int label;
            double[][] objectData = this.threadObjectData[threadIndex];
            int capacity = objectData[0].length;
            int labelMax = label + count;
            for (label = p; label < labelMax; ++label) {
                int index = this.listHeads[label];
                int pixelCount = 0;
                while (index != -1) {
                    if (pixelCount >= capacity) {
                        ForDoubles.ensureCapacityForPixels(objectData, this.lists.length, pixelCount);
                        capacity = objectData[0].length;
                    }
                    for (int c = 0; c < this.numberOfChannels; ++c) {
                        objectData[c][pixelCount] = this.data[c][index];
                    }
                    ++pixelCount;
                    index = this.lists[index];
                }
                if (label > 0) {
                    this.cardinalities[label - 1] = pixelCount;
                }
                this.processor.processPixels(label, objectData, pixelCount, threadIndex);
            }
        }
    }
}

