/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.pixels;

import java.util.Objects;
import net.algart.arrays.Arrays;
import net.algart.arrays.BitArray;
import net.algart.arrays.MemoryModel;
import net.algart.arrays.TooLargeArrayException;
import net.algart.executors.api.Executor;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.api.data.SNumbers;
import net.algart.multimatrix.MultiMatrix;
import net.algart.multimatrix.MultiMatrix2D;

public final class GetLabelledPixels
extends Executor
implements ReadOnlyExecutionInput {
    public static final String INPUT_LABELS = "labels";
    public static final String OUTPUT_PIXEL_VALUES = "pixel_values";
    public static final String OUTPUT_LABEL_VALUES = "label_values";
    private boolean labelValuesInLastColumns = false;
    private boolean rawPixelValues = false;

    public GetLabelledPixels() {
        this.useVisibleResultParameter();
        this.addInputMat(DEFAULT_INPUT_PORT);
        this.addInputMat(INPUT_LABELS);
        this.setDefaultOutputNumbers(OUTPUT_PIXEL_VALUES);
        this.addOutputNumbers(OUTPUT_LABEL_VALUES);
    }

    public boolean isLabelValuesInLastColumns() {
        return this.labelValuesInLastColumns;
    }

    public GetLabelledPixels setLabelValuesInLastColumns(boolean labelValuesInLastColumns) {
        this.labelValuesInLastColumns = labelValuesInLastColumns;
        return this;
    }

    public boolean isRawPixelValues() {
        return this.rawPixelValues;
    }

    public GetLabelledPixels setRawPixelValues(boolean rawPixelValues) {
        this.rawPixelValues = rawPixelValues;
        return this;
    }

    public void process() {
        MultiMatrix2D source = this.getInputMat().toMultiMatrix2D(true);
        MultiMatrix2D labels = this.getInputMat(INPUT_LABELS, true).toMultiMatrix2D();
        this.setStartProcessingTimeStamp();
        SNumbers resultPixelValues = this.getNumbers(OUTPUT_PIXEL_VALUES);
        SNumbers resultLabelValues = this.isOutputNecessary(OUTPUT_LABEL_VALUES) ? this.getNumbers(OUTPUT_LABEL_VALUES) : null;
        this.process(source, labels, resultPixelValues, resultLabelValues);
        this.setEndProcessingTimeStamp();
    }

    public void process(MultiMatrix2D source, MultiMatrix2D labels, SNumbers resultPixelValues, SNumbers resultLabelValues) {
        Objects.requireNonNull(source, "Null source");
        Objects.requireNonNull(resultPixelValues, "Null resultPixelValues");
        source.checkDimensionEquality((MultiMatrix)labels, "source", INPUT_LABELS);
        if (source.size() != (long)((int)source.size())) {
            throw new TooLargeArrayException("Too large matrix: " + String.valueOf(source));
        }
        BitArray nonZeroArray = labels == null ? Arrays.nBitCopies((long)source.size(), (boolean)true) : ((BitArray)labels.nonZeroAnyChannelMatrix().array()).updatableClone((MemoryModel)Arrays.SMM);
        int numberOfLabels = (int)(labels == null ? nonZeroArray.length() : Arrays.cardinality((BitArray)nonZeroArray));
        int numberOfSourceChannels = source.numberOfChannels();
        int numberOfLabelsChannels = labels == null ? 1 : labels.numberOfChannels();
        resultPixelValues.setToZeros(Float.TYPE, numberOfLabels, numberOfSourceChannels + (this.labelValuesInLastColumns ? numberOfLabelsChannels : 0));
        if (resultLabelValues != null && !this.labelValuesInLastColumns) {
            resultLabelValues.setToZeros(Integer.TYPE, numberOfLabels, numberOfLabelsChannels);
        }
        MultiMatrix.PixelValue pixelValue = null;
        MultiMatrix.PixelValue labelValue = null;
        float[] pixelValueArray = new float[numberOfSourceChannels];
        int[] labelValueIntArray = this.labelValuesInLastColumns ? null : new int[numberOfLabelsChannels];
        float[] labelValueArray = this.labelValuesInLastColumns ? new float[numberOfLabelsChannels] : null;
        double mult = 1.0 / source.maxPossibleValue();
        int dispPixels = 0;
        int dispLabels = 0;
        int n = (int)nonZeroArray.length();
        for (int p = 0; p < n; ++p) {
            if (!nonZeroArray.getBit((long)p)) continue;
            pixelValue = source.getPixel((long)p, pixelValue);
            pixelValue.getFloatChannels(pixelValueArray);
            if (!this.rawPixelValues) {
                int i = 0;
                while (i < pixelValueArray.length) {
                    int n2 = i++;
                    pixelValueArray[n2] = (float)((double)pixelValueArray[n2] * mult);
                }
            }
            resultPixelValues.setValues(dispPixels, numberOfSourceChannels, (Object)pixelValueArray);
            dispPixels += numberOfSourceChannels;
            if (this.labelValuesInLastColumns) {
                if (labels != null) {
                    labelValue = labels.getPixel((long)p, labelValue);
                    labelValue.getFloatChannels(labelValueArray);
                    resultPixelValues.setValues(dispPixels, numberOfLabelsChannels, (Object)labelValueArray);
                } else {
                    resultLabelValues.setValue(dispPixels, 1.0);
                }
                dispPixels += numberOfLabelsChannels;
                continue;
            }
            if (resultLabelValues == null) continue;
            if (labels != null) {
                labelValue = labels.getPixel((long)p, labelValue);
                labelValue.getIntChannels(labelValueIntArray);
                resultLabelValues.setValues(dispLabels, numberOfLabelsChannels, (Object)labelValueIntArray);
            } else {
                resultLabelValues.setValue(dispLabels, 1.0);
            }
            dispLabels += numberOfLabelsChannels;
        }
    }
}

