/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.opencv.matrices.ml;

import java.io.IOError;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import net.algart.executors.api.data.DataType;
import net.algart.executors.api.data.Port;
import net.algart.executors.api.data.SMat;
import net.algart.executors.api.data.SNumbers;
import net.algart.executors.modules.opencv.matrices.ml.AbstractMLOperation;
import net.algart.executors.modules.opencv.matrices.ml.MLKind;
import net.algart.executors.modules.opencv.matrices.ml.MLMetadataJson;
import net.algart.executors.modules.opencv.matrices.ml.MLPredictor;
import net.algart.executors.modules.opencv.matrices.ml.MLSamplesType;
import net.algart.executors.modules.opencv.util.OTools;
import org.bytedeco.opencv.opencv_core.Mat;
import org.bytedeco.opencv.opencv_core.UMat;

public abstract class AbstractMLPredict
extends AbstractMLOperation {
    public static final String OUTPUT_PREDICTION_MODEL_KIND = "model_kind";
    public static final String OUTPUT_IS_CLASSIFIER = "is_classifier";
    private boolean selectIndexesOfMaximalResponses = true;
    private boolean predictionRoundResponses = false;
    private int predictionFlags = 0;

    protected AbstractMLPredict(MLSamplesType samplesType) {
        super(samplesType);
        this.addPort(Port.newInput((String)"samples", (DataType)samplesType.portDataType));
        this.addPort(Port.newOutput((String)DEFAULT_OUTPUT_PORT, (DataType)samplesType.portDataType));
        this.addOutputScalar(OUTPUT_PREDICTION_MODEL_KIND);
        this.addOutputScalar(OUTPUT_IS_CLASSIFIER);
    }

    public final boolean isSelectIndexesOfMaximalResponses() {
        return this.selectIndexesOfMaximalResponses;
    }

    public final void setSelectIndexesOfMaximalResponses(boolean selectIndexesOfMaximalResponses) {
        this.selectIndexesOfMaximalResponses = selectIndexesOfMaximalResponses;
    }

    public final boolean isPredictionRoundResponses() {
        return this.predictionRoundResponses;
    }

    public final void setPredictionRoundResponses(boolean predictionRoundResponses) {
        this.predictionRoundResponses = predictionRoundResponses;
    }

    public final boolean isPredictionRawOutput() {
        return this.getPredictionFlagByMask(1);
    }

    public final void setPredictionRawOutput(boolean predictionRawOutput) {
        this.setPredictionFlagByMask(1, predictionRawOutput);
    }

    public final int getPredictionFlags() {
        return this.predictionFlags;
    }

    public final void setPredictionFlags(int predictionFlags) {
        this.predictionFlags = predictionFlags;
    }

    public final void setPredictionFlagByMask(int bitMask, boolean value) {
        this.predictionFlags = value ? (this.predictionFlags |= bitMask) : (this.predictionFlags &= ~bitMask);
    }

    public final boolean getPredictionFlagByMask(int bitMask) {
        return (this.predictionFlags & bitMask) != 0;
    }

    public final boolean selectIndexesOfMaximalResponses(MLPredictor predictor, int responseLength) {
        return this.selectIndexesOfMaximalResponses && responseLength > 1 && !predictor.isClassifier();
    }

    public final void predict(MLPredictor predictor) {
        Objects.requireNonNull(predictor, "Null predictor");
        this.samplesType().predict(this, predictor);
    }

    /*
     * Exception decompiling
     */
    public SNumbers predictNumbers(MLPredictor predictor, SNumbers samples) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK], 18[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public SMat predictPixels(MLPredictor predictor, SMat samples) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [18[CATCHBLOCK], 1[TRYBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public final MLPredictor readStandardPredictor(MLKind defaultKind) {
        return this.readPredictor(defaultKind, MLKind.StatModelBased::of);
    }

    public final MLPredictor readPredictor(MLKind defaultKind, Function<String, Optional<MLKind>> modelNameToKind) {
        Objects.requireNonNull(defaultKind, "Null defaultKind");
        Objects.requireNonNull(modelNameToKind, "Null modelNameToKind function");
        Path file = this.statModelFile();
        AbstractMLPredict.logDebug(() -> "Loading model file " + String.valueOf(file));
        try {
            Path metadataJsonFile = MLMetadataJson.metadataFile(file);
            MLKind kind = null;
            if (Files.exists(metadataJsonFile, new LinkOption[0])) {
                MLMetadataJson metadata = MLMetadataJson.read(metadataJsonFile, modelNameToKind);
                kind = metadata.getModelKind();
            }
            if (kind == null) {
                kind = defaultKind;
            }
            MLPredictor predictor = kind.loadPredictor(file);
            this.getScalar(OUTPUT_PREDICTION_MODEL_KIND).setTo(kind.modelName());
            this.getScalar(OUTPUT_IS_CLASSIFIER).setTo(predictor.isClassifier());
            return predictor;
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public final void setPredictionFlags(MLPredictor predictor) {
        Objects.requireNonNull(predictor, "Null predictor");
        predictor.setPredictionFlags(this.predictionFlags);
    }

    protected void doPredict(MLPredictor predictor, Mat samples, Mat result) {
        predictor.predict(samples, result);
    }

    protected void doPredict(MLPredictor predictor, UMat samples, UMat result) {
        predictor.predict(samples, result);
    }

    private void predictionRoundResponses(Mat responses) {
        if (this.isPredictionRoundResponses() && OTools.isFloatingPoint(responses.depth())) {
            responses.convertTo(responses, 4);
        }
    }

    private void predictionRoundResponses(UMat responses) {
        if (this.isPredictionRoundResponses() && OTools.isFloatingPoint(responses.depth())) {
            responses.convertTo(responses, 4);
        }
    }
}

