/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.opencv.numbers.misc;

import java.util.Arrays;
import java.util.List;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.api.data.SNumbers;
import net.algart.executors.modules.core.common.numbers.IndexingBase;
import net.algart.executors.modules.core.common.numbers.SeveralNumbersOperation;
import net.algart.executors.modules.core.numbers.misc.ValuesDistanceMetric;
import net.algart.executors.modules.opencv.util.O2SMat;
import net.algart.executors.modules.opencv.util.OTools;
import org.bytedeco.opencv.global.opencv_core;
import org.bytedeco.opencv.opencv_core.Mat;
import org.bytedeco.opencv.opencv_core.Scalar;
import org.bytedeco.opencv.opencv_core.TermCriteria;
import org.bytedeco.opencv.opencv_core.UMat;

public final class KMeans
extends SeveralNumbersOperation
implements ReadOnlyExecutionInput {
    public static final String INPUT_LABELS = "labels";
    public static final String OUTPUT_LABELS = "labels";
    public static final String OUTPUT_CENTERS = "centers";
    public static final String OUTPUT_DISTANCES = "distances";
    private int numberOfClusters = 1;
    private CentersMode centersMode = CentersMode.KMEANS_PP_CENTERS;
    private int attempts = 3;
    private int terminationMaxCount = 0;
    private double terminationEpsilon = 0.1;
    private IndexingBase indexingBase = IndexingBase.ONE_BASED;

    public KMeans() {
        super(new String[]{DEFAULT_INPUT_PORT, "labels"});
        this.setDefaultOutputNumbers("labels");
        this.addOutputNumbers(OUTPUT_CENTERS);
        this.addOutputNumbers(OUTPUT_DISTANCES);
    }

    public int getNumberOfClusters() {
        return this.numberOfClusters;
    }

    public KMeans setNumberOfClusters(int numberOfClusters) {
        this.numberOfClusters = KMeans.nonNegative((int)numberOfClusters);
        return this;
    }

    public CentersMode getCentersMode() {
        return this.centersMode;
    }

    public void setCentersMode(CentersMode centersMode) {
        this.centersMode = (CentersMode)((Object)KMeans.nonNull((Object)((Object)centersMode)));
    }

    public int getAttempts() {
        return this.attempts;
    }

    public KMeans setAttempts(int attempts) {
        this.attempts = KMeans.nonNegative((int)attempts);
        return this;
    }

    public int getTerminationMaxCount() {
        return this.terminationMaxCount;
    }

    public KMeans setTerminationMaxCount(int terminationMaxCount) {
        this.terminationMaxCount = KMeans.nonNegative((int)terminationMaxCount);
        return this;
    }

    public double getTerminationEpsilon() {
        return this.terminationEpsilon;
    }

    public KMeans setTerminationEpsilon(double terminationEpsilon) {
        this.terminationEpsilon = KMeans.nonNegative((double)terminationEpsilon);
        return this;
    }

    public IndexingBase getIndexingBase() {
        return this.indexingBase;
    }

    public KMeans setIndexingBase(IndexingBase indexingBase) {
        this.indexingBase = (IndexingBase)KMeans.nonNull((Object)indexingBase);
        return this;
    }

    public SNumbers processNumbers(List<SNumbers> sources, SNumbers resultCenters, SNumbers resultDistancesToCenters) {
        return OTools.isGPUOptimizationEnabled() ? this.processNumbersUMat(sources, resultCenters, resultDistancesToCenters) : this.processNumbersMat(sources, resultCenters, resultDistancesToCenters);
    }

    protected SNumbers processNumbers(List<SNumbers> sources) {
        return this.processNumbers(sources, this.getNumbers(OUTPUT_CENTERS), this.getNumbers(OUTPUT_DISTANCES));
    }

    protected boolean allowUninitializedInput(int inputIndex) {
        return inputIndex >= 1;
    }

    protected boolean blockLengthEqualityRequired() {
        return false;
    }

    private SNumbers processNumbersMat(List<SNumbers> sources, SNumbers resultCenters, SNumbers resultDistancesToCenters) {
        Mat labelsMat;
        SNumbers data = sources.get(0);
        int dimCount = data.getBlockLength();
        Mat dataMat = O2SMat.numbersToMulticolumn32BitMat(data, false);
        SNumbers labels = sources.get(1);
        if (labels == null) {
            labelsMat = new Mat();
        } else {
            labelsMat = O2SMat.numbersToMulticolumn32BitMat(labels, true);
            if (this.indexingBase.start != 0) {
                try (Scalar startIndex = new Scalar((double)this.indexingBase.start);){
                    opencv_core.subtract((Mat)labelsMat, (Scalar)startIndex).asMat().copyTo(labelsMat);
                }
            }
        }
        try (TermCriteria termCriteria = OTools.termCriteria(this.terminationMaxCount, this.terminationEpsilon, false);){
            int flags = this.centersMode.kmeansFlag | (labels == null ? 0 : 1);
            Mat centersMat = new Mat();
            KMeans.logDebug(() -> "KMeans array segmentation: K = " + this.numberOfClusters + ", attempts = " + this.attempts + ", maxCount = " + termCriteria.maxCount() + ", epsilon = " + termCriteria.epsilon() + ", flags = " + flags);
            opencv_core.kmeans((Mat)dataMat, (int)this.numberOfClusters, (Mat)labelsMat, (TermCriteria)termCriteria, (int)this.attempts, (int)flags, (Mat)centersMat);
            SNumbers resultLabels = O2SMat.multicolumnMatToNumbers(labelsMat);
            if (resultLabels.getBlockLength() != 1) {
                throw new AssertionError((Object)("Strange kmeans behaviour: it returned matrix with " + resultLabels.getBlockLength() + "!=1 columns"));
            }
            int numberOfLabels = resultLabels.n();
            if (data.n() != numberOfLabels) {
                throw new AssertionError((Object)("Strange kmeans behaviour: different number of labels " + numberOfLabels + " and data " + data.n()));
            }
            SNumbers centers = O2SMat.multicolumnMatToNumbers(centersMat);
            if (resultCenters != null) {
                resultCenters.setTo(centers);
            }
            if (resultDistancesToCenters != null) {
                if (centers.getBlockLength() != dimCount) {
                    throw new AssertionError((Object)("Strange kmeans behaviour: different number of dimensions in source data " + dimCount + " and cluster centers " + centers.getBlockLength()));
                }
                int numberOfCenters = centers.n();
                float[] distances = new float[data.n()];
                double[] weights = new double[dimCount];
                Arrays.fill(weights, 1.0);
                double[] a = new double[dimCount];
                double[] b = new double[dimCount];
                for (int k = 0; k < distances.length; ++k) {
                    int label = (int)resultLabels.getValue(k);
                    if (label < 0 || label >= numberOfCenters) {
                        throw new AssertionError((Object)("Strange kmeans behaviour: it returned label " + label + ", which is out of range 0..number_of_result_clusters-1=" + (numberOfCenters - 1)));
                    }
                    data.getBlockDoubleValues(k, a);
                    centers.getBlockDoubleValues(label, b);
                    distances[k] = (float)ValuesDistanceMetric.EUCLIDEAN.distance(a, b, weights);
                }
                resultDistancesToCenters.setTo(distances, 1);
            }
            if (this.indexingBase.start != 0) {
                for (int k = 0; k < numberOfLabels; ++k) {
                    resultLabels.setValue(k, resultLabels.getValue(k) + (double)this.indexingBase.start);
                }
            }
            SNumbers sNumbers = resultLabels;
            return sNumbers;
        }
    }

    public SNumbers processNumbersUMat(List<SNumbers> sources, SNumbers resultCenters, SNumbers resultDistancesToCenters) {
        UMat labelsUMat;
        SNumbers data = sources.get(0);
        int dimCount = data.getBlockLength();
        UMat dataUMat = OTools.toUMat(O2SMat.numbersToMulticolumn32BitMat(data, false));
        SNumbers labels = sources.get(1);
        if (labels == null) {
            labelsUMat = new UMat();
        } else {
            try (Mat labelsMat = O2SMat.numbersToMulticolumn32BitMat(labels, true);){
                if (this.indexingBase.start != 0) {
                    try (Scalar startIndex = new Scalar((double)this.indexingBase.start);){
                        opencv_core.subtract((Mat)labelsMat, (Scalar)startIndex).asMat().copyTo(labelsMat);
                    }
                }
                labelsUMat = OTools.toUMat(labelsMat);
            }
        }
        UMat centersUMat = null;
        try {
            SNumbers sNumbers;
            block35: {
                TermCriteria termCriteria = OTools.termCriteria(this.terminationMaxCount, this.terminationEpsilon, false);
                try {
                    int flags = this.centersMode.kmeansFlag | (labels == null ? 0 : 1);
                    centersUMat = new UMat();
                    KMeans.logDebug(() -> "KMeans array segmentation (GPU): K = " + this.numberOfClusters + ", attempts = " + this.attempts + ", maxCount = " + termCriteria.maxCount() + ", epsilon = " + termCriteria.epsilon() + ", flags = " + flags);
                    opencv_core.kmeans((UMat)dataUMat, (int)this.numberOfClusters, (UMat)labelsUMat, (TermCriteria)termCriteria, (int)this.attempts, (int)flags, (UMat)centersUMat);
                    SNumbers resultLabels = O2SMat.multicolumnMatToNumbers(labelsUMat);
                    if (resultLabels.getBlockLength() != 1) {
                        throw new AssertionError((Object)("Strange kmeans behaviour: it returned matrix with " + resultLabels.getBlockLength() + "!=1 columns"));
                    }
                    int numberOfLabels = resultLabels.n();
                    if (data.n() != numberOfLabels) {
                        throw new AssertionError((Object)("Strange kmeans behaviour: different number of labels " + numberOfLabels + " and data " + data.n()));
                    }
                    SNumbers centers = O2SMat.multicolumnMatToNumbers(centersUMat);
                    if (resultCenters != null) {
                        resultCenters.setTo(centers);
                    }
                    if (resultDistancesToCenters != null) {
                        if (centers.getBlockLength() != dimCount) {
                            throw new AssertionError((Object)("Strange kmeans behaviour: different number of dimensions in source data " + dimCount + " and cluster centers " + centers.getBlockLength()));
                        }
                        int numberOfCenters = centers.n();
                        float[] distances = new float[data.n()];
                        double[] weights = new double[dimCount];
                        Arrays.fill(weights, 1.0);
                        double[] a = new double[dimCount];
                        double[] b = new double[dimCount];
                        for (int k = 0; k < distances.length; ++k) {
                            int label = (int)resultLabels.getValue(k);
                            if (label < 0 || label >= numberOfCenters) {
                                throw new AssertionError((Object)("Strange kmeans behaviour: it returned label " + label + ", which is out of range 0..number_of_result_clusters-1=" + (numberOfCenters - 1)));
                            }
                            data.getBlockDoubleValues(k, a);
                            centers.getBlockDoubleValues(label, b);
                            distances[k] = (float)ValuesDistanceMetric.EUCLIDEAN.distance(a, b, weights);
                        }
                        resultDistancesToCenters.setTo(distances, 1);
                    }
                    if (this.indexingBase.start != 0) {
                        for (int k = 0; k < numberOfLabels; ++k) {
                            resultLabels.setValue(k, resultLabels.getValue(k) + (double)this.indexingBase.start);
                        }
                    }
                    sNumbers = resultLabels;
                    if (termCriteria == null) break block35;
                }
                catch (Throwable throwable) {
                    if (termCriteria != null) {
                        try {
                            termCriteria.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                termCriteria.close();
            }
            return sNumbers;
        }
        finally {
            if (centersUMat != null) {
                centersUMat.close();
            }
            labelsUMat.close();
        }
    }

    public static enum CentersMode {
        KMEANS_RANDOM_CENTERS(0),
        KMEANS_PP_CENTERS(2);

        private final int kmeansFlag;

        private CentersMode(int kmeansFlag) {
            this.kmeansFlag = kmeansFlag;
        }
    }
}

